/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.ResourceTree;
import org.gradle.api.internal.changedetection.state.ResourceWithContentsVisitor;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;

public class ZipTree
implements ResourceTree {
    private final FileSnapshot zipFile;

    public ZipTree(FileSnapshot zipFile) {
        this.zipFile = zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(ResourceWithContentsVisitor visitor) throws IOException {
        String zipFilePath = this.zipFile.getPath();
        InputStream fileInputStream = null;
        try {
            ZipEntry zipEntry;
            fileInputStream = Files.newInputStream(Paths.get(zipFilePath, new String[0]), new OpenOption[0]);
            ZipInputStream zipInput = new ZipInputStream(fileInputStream);
            while ((zipEntry = zipInput.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                visitor.visitZipFileEntry(zipEntry, zipInput);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }
}

