/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.io.File;
import java.util.List;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerDecorator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class CompilationSourceDirs {
    private static final Logger LOG = Logging.getLogger(IncrementalCompilerDecorator.class);
    private final List<Object> sources;
    private List<File> sourceRoots;

    public CompilationSourceDirs(List<Object> sources) {
        this.sources = sources;
    }

    List<File> getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = Lists.newArrayList();
            for (Object source : this.sources) {
                if (this.isDirectory(source)) {
                    this.sourceRoots.add((File)source);
                    continue;
                }
                if (this.isDirectoryTree(source)) {
                    this.sourceRoots.add(((DirectoryTree)source).getDir());
                    continue;
                }
                if (this.isSourceDirectorySet(source)) {
                    this.sourceRoots.addAll(((SourceDirectorySet)source).getSrcDirs());
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        return this.sourceRoots;
    }

    public boolean canInferSourceRoots() {
        for (Object source : this.sources) {
            if (this.canInferSourceRoot(source)) continue;
            LOG.info("Cannot infer source root(s) for input with type `{}`. Supported types are `File`, `DirectoryTree` and `SourceDirectorySet`. Unsupported input: {}", source.getClass().getSimpleName(), source);
            return false;
        }
        return true;
    }

    private boolean canInferSourceRoot(Object source) {
        return this.isSourceDirectorySet(source) || this.isDirectoryTree(source) || this.isDirectory(source);
    }

    private boolean isSourceDirectorySet(Object source) {
        return source instanceof SourceDirectorySet;
    }

    private boolean isDirectoryTree(Object source) {
        return source instanceof DirectoryTree;
    }

    private boolean isDirectory(Object source) {
        return source instanceof File && ((File)source).isDirectory();
    }
}

