/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.report.PackageTestResults;
import org.gradle.api.internal.tasks.testing.report.PageRenderer;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.html.SimpleHtmlWriter;

class PackagePageRenderer
extends PageRenderer<PackageTestResults> {
    PackagePageRenderer() {
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("div").attribute("class", "breadcrumbs");
        htmlWriter.startElement("a").attribute("href", ((PackageTestResults)this.getResults()).getUrlTo(((PackageTestResults)this.getResults()).getParent())).characters("all").endElement();
        htmlWriter.characters(" > " + ((PackageTestResults)this.getResults()).getName());
        htmlWriter.endElement();
    }

    private void renderClasses(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table");
        htmlWriter.startElement("thread");
        htmlWriter.startElement("tr");
        htmlWriter.startElement("th").characters("Class").endElement();
        htmlWriter.startElement("th").characters("Tests").endElement();
        htmlWriter.startElement("th").characters("Failures").endElement();
        htmlWriter.startElement("th").characters("Ignored").endElement();
        htmlWriter.startElement("th").characters("Duration").endElement();
        htmlWriter.startElement("th").characters("Success rate").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        for (ClassTestResults testClass : ((PackageTestResults)this.getResults()).getClasses()) {
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td").attribute("class", testClass.getStatusClass());
            htmlWriter.startElement("a").attribute("href", this.asHtmlLinkEncoded(((PackageTestResults)this.getResults()).getUrlTo(testClass))).characters(testClass.getSimpleName()).endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td").characters(Integer.toString(testClass.getTestCount())).endElement();
            htmlWriter.startElement("td").characters(Integer.toString(testClass.getFailureCount())).endElement();
            htmlWriter.startElement("td").characters(Integer.toString(testClass.getIgnoredCount())).endElement();
            htmlWriter.startElement("td").characters(testClass.getFormattedDuration()).endElement();
            htmlWriter.startElement("td").attribute("class", testClass.getStatusClass()).characters(testClass.getFormattedSuccessRate()).endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addIgnoredTab();
        this.addTab("Classes", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            @Override
            public void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                PackagePageRenderer.this.renderClasses(htmlWriter);
            }
        });
    }
}

