/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.BuildAdapter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.tasks.DefaultScalaSourceSet;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.SourceSetUtil;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.ScalaRuntime;
import org.gradle.api.tasks.ScalaSourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.jvm.tasks.Jar;

public class ScalaBasePlugin
implements Plugin<Project> {
    @VisibleForTesting
    public static final String ZINC_CONFIGURATION_NAME = "zinc";
    public static final String SCALA_RUNTIME_EXTENSION_NAME = "scalaRuntime";
    private final SourceDirectorySetFactory sourceDirectorySetFactory;

    @Inject
    public ScalaBasePlugin(SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.sourceDirectorySetFactory = sourceDirectorySetFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        ScalaBasePlugin.configureConfigurations(project);
        ScalaRuntime scalaRuntime = ScalaBasePlugin.configureScalaRuntimeExtension(project);
        ScalaBasePlugin.configureCompileDefaults(project, scalaRuntime);
        ScalaBasePlugin.configureSourceSetDefaults(project, this.sourceDirectorySetFactory);
        ScalaBasePlugin.configureScaladoc(project, scalaRuntime);
    }

    private static void configureConfigurations(Project project) {
        ((Configuration)project.getConfigurations().create(ZINC_CONFIGURATION_NAME)).setVisible(false).setDescription("The Zinc incremental compiler to be used for this Scala project.");
    }

    private static ScalaRuntime configureScalaRuntimeExtension(Project project) {
        return project.getExtensions().create(SCALA_RUNTIME_EXTENSION_NAME, ScalaRuntime.class, project);
    }

    private static void configureSourceSetDefaults(final Project project, final SourceDirectorySetFactory sourceDirectorySetFactory) {
        project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets().all(new Action<SourceSet>(){

            @Override
            public void execute(final SourceSet sourceSet) {
                String displayName = (String)InvokerHelper.invokeMethod((Object)sourceSet, (String)"getDisplayName", null);
                Convention sourceSetConvention = (Convention)InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
                DefaultScalaSourceSet scalaSourceSet = new DefaultScalaSourceSet(displayName, sourceDirectorySetFactory);
                sourceSetConvention.getPlugins().put("scala", scalaSourceSet);
                final SourceDirectorySet scalaDirectorySet = scalaSourceSet.getScala();
                scalaDirectorySet.srcDir(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return project.file("src/" + sourceSet.getName() + "/scala");
                    }
                });
                sourceSet.getAllJava().source(scalaDirectorySet);
                sourceSet.getAllSource().source(scalaDirectorySet);
                sourceSet.getResources().getFilter().exclude(new Spec<FileTreeElement>(){

                    @Override
                    public boolean isSatisfiedBy(FileTreeElement element) {
                        return scalaDirectorySet.contains(element.getFile());
                    }
                });
                ScalaBasePlugin.configureScalaCompile(project, sourceSet);
            }
        });
    }

    private static void configureScalaCompile(final Project project, final SourceSet sourceSet) {
        String taskName = sourceSet.getCompileTaskName("scala");
        final ScalaCompile scalaCompile = project.getTasks().create(taskName, ScalaCompile.class);
        scalaCompile.dependsOn(sourceSet.getCompileJavaTaskName());
        Convention scalaConvention = (Convention)InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
        ScalaSourceSet scalaSourceSet = scalaConvention.findPlugin(ScalaSourceSet.class);
        SourceSetUtil.configureForSourceSet(sourceSet, scalaSourceSet.getScala(), scalaCompile, project);
        scalaCompile.setDescription("Compiles the " + scalaSourceSet.getScala() + ".");
        scalaCompile.setSource(scalaSourceSet.getScala());
        project.getTasks().getByName(sourceSet.getClassesTaskName()).dependsOn(taskName);
        project.getGradle().addBuildListener(new BuildAdapter(){

            @Override
            public void projectsEvaluated(Gradle gradle) {
                IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
                if (incrementalOptions.getAnalysisFile() == null) {
                    String analysisFilePath = project.getBuildDir().getPath() + "/tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".analysis";
                    incrementalOptions.setAnalysisFile(new File(analysisFilePath));
                }
                if (incrementalOptions.getPublishedCode() == null) {
                    Jar jarTask = (Jar)project.getTasks().findByName(sourceSet.getJarTaskName());
                    incrementalOptions.setPublishedCode(jarTask == null ? null : jarTask.getArchivePath());
                }
            }
        });
    }

    private static void configureCompileDefaults(final Project project, final ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaCompile.class, new Action<ScalaCompile>(){

            @Override
            public void execute(final ScalaCompile compile) {
                compile.getConventionMapping().map("scalaClasspath", new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return scalaRuntime.inferScalaClasspath(compile.getClasspath());
                    }
                });
                compile.getConventionMapping().map("zincClasspath", new Callable<Configuration>(){

                    @Override
                    public Configuration call() throws Exception {
                        Configuration config = project.getConfigurations().getAt(ScalaBasePlugin.ZINC_CONFIGURATION_NAME);
                        if (config.getDependencies().isEmpty()) {
                            project.getDependencies().add(ScalaBasePlugin.ZINC_CONFIGURATION_NAME, "com.typesafe.zinc:zinc:0.3.15");
                        }
                        return config;
                    }
                });
            }
        });
    }

    private static void configureScaladoc(final Project project, final ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaDoc.class, new Action<ScalaDoc>(){

            @Override
            public void execute(final ScalaDoc scalaDoc) {
                scalaDoc.getConventionMapping().map("destinationDir", new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        File docsDir = project.getConvention().getPlugin(JavaPluginConvention.class).getDocsDir();
                        return project.file(docsDir.getPath() + "/scaladoc");
                    }
                });
                scalaDoc.getConventionMapping().map("title", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle();
                    }
                });
                scalaDoc.getConventionMapping().map("scalaClasspath", new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return scalaRuntime.inferScalaClasspath(scalaDoc.getClasspath());
                    }
                });
            }
        });
    }
}

