/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.tasks.Internal;
import org.gradle.internal.Factory;
import org.gradle.internal.logging.LoggingManagerInternal;

@Incubating
public abstract class AbstractPublishToMaven
extends DefaultTask {
    private MavenPublicationInternal publication;

    public AbstractPublishToMaven() {
        this.getInputs().files(new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                MavenPublicationInternal publicationInternal = AbstractPublishToMaven.this.getPublicationInternal();
                return publicationInternal == null ? null : publicationInternal.getPublishableFiles();
            }
        }).withPropertyName("publication.publishableFiles");
    }

    @Internal
    public MavenPublication getPublication() {
        return this.publication;
    }

    public void setPublication(MavenPublication publication) {
        this.publication = AbstractPublishToMaven.toPublicationInternal(publication);
    }

    @Internal
    protected MavenPublicationInternal getPublicationInternal() {
        return AbstractPublishToMaven.toPublicationInternal(this.getPublication());
    }

    private static MavenPublicationInternal toPublicationInternal(MavenPublication publication) {
        if (publication == null) {
            return null;
        }
        if (publication instanceof MavenPublicationInternal) {
            return (MavenPublicationInternal)publication;
        }
        throw new InvalidUserDataException(String.format("publication objects must implement the '%s' interface, implementation '%s' does not", MavenPublicationInternal.class.getName(), publication.getClass().getName()));
    }

    @Inject
    protected Factory<LoggingManagerInternal> getLoggingManagerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected LocalMavenRepositoryLocator getMavenRepositoryLocator() {
        throw new UnsupportedOperationException();
    }
}

