/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing.testng;

import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.xml.MarkupBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.testing.TestFrameworkOptions;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;

public class TestNGOptions
extends TestFrameworkOptions {
    public static final String DEFAULT_CONFIG_FAILURE_POLICY = "skip";
    private File outputDirectory;
    private Set<String> includeGroups = new LinkedHashSet<String>();
    private Set<String> excludeGroups = new LinkedHashSet<String>();
    private String configFailurePolicy = "skip";
    private Set<String> listeners = new LinkedHashSet<String>();
    private String parallel;
    private int threadCount = 1;
    private boolean useDefaultListeners;
    private String suiteName = "Gradle suite";
    private String testName = "Gradle test";
    private List<File> suiteXmlFiles = new ArrayList<File>();
    private boolean preserveOrder;
    private boolean groupByInstances;
    private transient StringWriter suiteXmlWriter;
    private transient MarkupBuilder suiteXmlBuilder;
    private final File projectDir;

    public TestNGOptions(File projectDir) {
        this.projectDir = projectDir;
    }

    public MarkupBuilder suiteXmlBuilder() {
        this.suiteXmlWriter = new StringWriter();
        this.suiteXmlBuilder = new MarkupBuilder((Writer)this.suiteXmlWriter);
        return this.suiteXmlBuilder;
    }

    public void suites(String ... suiteFiles) {
        for (String suiteFile : suiteFiles) {
            this.suiteXmlFiles.add(new File(this.getProjectDir(), suiteFile));
        }
    }

    protected File getProjectDir() {
        return this.projectDir;
    }

    public void suites(File ... suiteFiles) {
        this.suiteXmlFiles.addAll(Arrays.asList(suiteFiles));
    }

    public List<File> getSuites(File testSuitesDir) {
        ArrayList<File> suites = new ArrayList<File>();
        suites.addAll(this.suiteXmlFiles);
        if (this.suiteXmlBuilder != null) {
            File buildSuiteXml = new File(testSuitesDir.getAbsolutePath(), "build-suite.xml");
            if (buildSuiteXml.exists() && !buildSuiteXml.delete()) {
                throw new RuntimeException("failed to remove already existing build-suite.xml file");
            }
            IoActions.writeTextFile(buildSuiteXml, (Action<? super BufferedWriter>)new ErroringAction<BufferedWriter>(){

                @Override
                protected void doExecute(BufferedWriter writer) throws Exception {
                    writer.write("<!DOCTYPE suite SYSTEM \"http://testng.org/testng-1.0.dtd\">");
                    writer.newLine();
                    writer.write(TestNGOptions.this.suiteXmlWriter.toString());
                }
            });
            suites.add(buildSuiteXml);
        }
        return suites;
    }

    public TestNGOptions includeGroups(String ... includeGroups) {
        this.includeGroups.addAll(Arrays.asList(includeGroups));
        return this;
    }

    public TestNGOptions excludeGroups(String ... excludeGroups) {
        this.excludeGroups.addAll(Arrays.asList(excludeGroups));
        return this;
    }

    public TestNGOptions useDefaultListeners() {
        this.useDefaultListeners = true;
        return this;
    }

    public TestNGOptions useDefaultListeners(boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
        return this;
    }

    public Object propertyMissing(String name) {
        if (this.suiteXmlBuilder != null) {
            return this.suiteXmlBuilder.getMetaClass().getProperty((Object)this.suiteXmlBuilder, name);
        }
        throw new MissingPropertyException(name, this.getClass());
    }

    public Object methodMissing(String name, Object args) {
        if (this.suiteXmlBuilder != null) {
            return this.suiteXmlBuilder.getMetaClass().invokeMethod((Object)this.suiteXmlBuilder, name, args);
        }
        throw new MissingMethodException(name, this.getClass(), (Object[])args);
    }

    @Incubating
    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Incubating
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public Set<String> getIncludeGroups() {
        return this.includeGroups;
    }

    public void setIncludeGroups(Set<String> includeGroups) {
        this.includeGroups = includeGroups;
    }

    public Set<String> getExcludeGroups() {
        return this.excludeGroups;
    }

    public void setExcludeGroups(Set<String> excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    public String getConfigFailurePolicy() {
        return this.configFailurePolicy;
    }

    public void setConfigFailurePolicy(String configFailurePolicy) {
        this.configFailurePolicy = configFailurePolicy;
    }

    public Set<String> getListeners() {
        return this.listeners;
    }

    public void setListeners(Set<String> listeners) {
        this.listeners = listeners;
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        this.parallel = parallel;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean getUseDefaultListeners() {
        return this.useDefaultListeners;
    }

    public boolean isUseDefaultListeners() {
        return this.useDefaultListeners;
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public List<File> getSuiteXmlFiles() {
        return this.suiteXmlFiles;
    }

    public void setSuiteXmlFiles(List<File> suiteXmlFiles) {
        this.suiteXmlFiles = suiteXmlFiles;
    }

    public boolean getPreserveOrder() {
        return this.preserveOrder;
    }

    @Incubating
    public boolean isPreserveOrder() {
        return this.preserveOrder;
    }

    @Incubating
    public void setPreserveOrder(boolean preserveOrder) {
        this.preserveOrder = preserveOrder;
    }

    @Incubating
    public boolean getGroupByInstances() {
        return this.groupByInstances;
    }

    @Incubating
    public boolean isGroupByInstances() {
        return this.groupByInstances;
    }

    @Incubating
    public void setGroupByInstances(boolean groupByInstances) {
        this.groupByInstances = groupByInstances;
    }

    public StringWriter getSuiteXmlWriter() {
        return this.suiteXmlWriter;
    }

    public void setSuiteXmlWriter(StringWriter suiteXmlWriter) {
        this.suiteXmlWriter = suiteXmlWriter;
    }

    public MarkupBuilder getSuiteXmlBuilder() {
        return this.suiteXmlBuilder;
    }

    public void setSuiteXmlBuilder(MarkupBuilder suiteXmlBuilder) {
        this.suiteXmlBuilder = suiteXmlBuilder;
    }
}

