/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationNotFoundException;
import org.gradle.internal.component.model.DefaultDependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class IvyDependencyMetadata
extends DefaultDependencyMetadata {
    private final String dynamicConstraintVersion;
    private final boolean force;
    private final boolean changing;
    private final boolean transitive;
    private final SetMultimap<String, String> confs;
    private final List<Exclude> excludes;

    public IvyDependencyMetadata(ModuleComponentSelector selector, String dynamicConstraintVersion, boolean force, boolean changing, boolean transitive, boolean optional, Multimap<String, String> confMappings, List<Artifact> artifacts, List<Exclude> excludes) {
        super(selector, artifacts, optional);
        this.dynamicConstraintVersion = dynamicConstraintVersion;
        this.force = force;
        this.changing = changing;
        this.transitive = transitive;
        this.confs = ImmutableSetMultimap.copyOf(confMappings);
        this.excludes = ImmutableList.copyOf(excludes);
    }

    public IvyDependencyMetadata(ModuleComponentSelector requested, ListMultimap<String, String> confMappings) {
        this(requested, requested.getVersionConstraint().getPreferredVersion(), false, false, true, false, (Multimap<String, String>)confMappings, Collections.emptyList(), Collections.emptyList());
    }

    public String toString() {
        return "dependency: " + this.getSelector() + ", confs: " + this.confs;
    }

    @Override
    protected ModuleDependencyMetadata withRequested(ModuleComponentSelector newRequested) {
        return new IvyDependencyMetadata(newRequested, this.dynamicConstraintVersion, this.force, this.changing, this.transitive, this.isOptional(), (Multimap<String, String>)this.confs, this.getDependencyArtifacts(), this.excludes);
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public String getDynamicConstraintVersion() {
        return this.dynamicConstraintVersion;
    }

    @Override
    public Set<String> getModuleConfigurations() {
        return this.confs.keySet();
    }

    public SetMultimap<String, String> getConfMappings() {
        return this.confs;
    }

    @Override
    public Set<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata fromComponent, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema) {
        Set wildcardPatterns;
        LinkedHashSet targets = Sets.newLinkedHashSet();
        boolean matched = false;
        String fromConfigName = fromConfiguration.getName();
        for (String config : fromConfiguration.getHierarchy()) {
            if (!this.confs.containsKey((Object)config)) continue;
            Set targetPatterns = this.confs.get((Object)config);
            if (!targetPatterns.isEmpty()) {
                matched = true;
            }
            for (String targetPattern : targetPatterns) {
                this.findMatches(fromComponent, targetComponent, fromConfigName, config, targetPattern, targets);
            }
        }
        if (!matched && this.confs.containsKey((Object)"%")) {
            for (String targetPattern : this.confs.get((Object)"%")) {
                this.findMatches(fromComponent, targetComponent, fromConfigName, fromConfigName, targetPattern, targets);
            }
        }
        if (!(wildcardPatterns = this.confs.get((Object)"*")).isEmpty()) {
            boolean excludeWildcards = false;
            for (String confName : fromConfiguration.getHierarchy()) {
                if (!this.confs.containsKey((Object)("!" + confName))) continue;
                excludeWildcards = true;
                break;
            }
            if (!excludeWildcards) {
                for (String targetPattern : wildcardPatterns) {
                    this.findMatches(fromComponent, targetComponent, fromConfigName, fromConfigName, targetPattern, targets);
                }
            }
        }
        return targets;
    }

    private void findMatches(ComponentResolveMetadata fromComponent, ComponentResolveMetadata targetComponent, String fromConfiguration, String patternConfiguration, String targetPattern, Set<ConfigurationMetadata> targetConfigurations) {
        int startFallback = targetPattern.indexOf(40);
        if (startFallback >= 0 && targetPattern.endsWith(")")) {
            String preferred = targetPattern.substring(0, startFallback);
            ConfigurationMetadata configuration = targetComponent.getConfiguration(preferred);
            if (configuration != null) {
                targetConfigurations.add(configuration);
                return;
            }
            targetPattern = targetPattern.substring(startFallback + 1, targetPattern.length() - 1);
        }
        if (targetPattern.equals("*")) {
            for (String targetName : targetComponent.getConfigurationNames()) {
                ConfigurationMetadata configuration = targetComponent.getConfiguration(targetName);
                if (!configuration.isVisible()) continue;
                targetConfigurations.add(configuration);
            }
            return;
        }
        if (targetPattern.equals("@")) {
            targetPattern = patternConfiguration;
        } else if (targetPattern.equals("#")) {
            targetPattern = fromConfiguration;
        }
        ConfigurationMetadata configuration = targetComponent.getConfiguration(targetPattern);
        if (configuration == null) {
            throw new ConfigurationNotFoundException(fromComponent.getComponentId(), fromConfiguration, targetPattern, targetComponent.getComponentId());
        }
        targetConfigurations.add(configuration);
    }

    @Override
    public List<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public List<Exclude> getExcludes(Collection<String> configurations) {
        ArrayList rules = Lists.newArrayList();
        for (Exclude exclude : this.excludes) {
            Set<String> ruleConfigurations = exclude.getConfigurations();
            if (!IvyDependencyMetadata.include(ruleConfigurations, configurations)) continue;
            rules.add(exclude);
        }
        return rules;
    }
}

