/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.local.model.DefaultProjectDependencyMetadata;
import org.gradle.internal.component.model.AbstractDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public abstract class DefaultDependencyMetadata
extends AbstractDependencyMetadata
implements ModuleDependencyMetadata {
    private final Set<IvyArtifactName> artifacts;
    private final List<Artifact> dependencyArtifacts;
    private final ModuleComponentSelector selector;
    private final boolean optional;

    protected DefaultDependencyMetadata(ModuleComponentSelector selector, List<Artifact> artifacts, boolean optional) {
        this.selector = selector;
        this.dependencyArtifacts = ImmutableList.copyOf(artifacts);
        this.optional = optional;
        this.artifacts = DefaultDependencyMetadata.map(this.dependencyArtifacts);
    }

    private static Set<IvyArtifactName> map(List<Artifact> dependencyArtifacts) {
        if (dependencyArtifacts.isEmpty()) {
            return ImmutableSet.of();
        }
        LinkedHashSet result = Sets.newLinkedHashSetWithExpectedSize((int)dependencyArtifacts.size());
        for (Artifact artifact : dependencyArtifacts) {
            result.add(artifact.getArtifactName());
        }
        return result;
    }

    @Override
    public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata fromConfiguration, ConfigurationMetadata toConfiguration) {
        if (this.dependencyArtifacts.isEmpty()) {
            return Collections.emptySet();
        }
        Collection<String> includedConfigurations = fromConfiguration.getHierarchy();
        LinkedHashSet artifacts = Sets.newLinkedHashSet();
        for (Artifact depArtifact : this.dependencyArtifacts) {
            IvyArtifactName ivyArtifactName = depArtifact.getArtifactName();
            Set<String> artifactConfigurations = depArtifact.getConfigurations();
            if (!DefaultDependencyMetadata.include(artifactConfigurations, includedConfigurations)) continue;
            ComponentArtifactMetadata artifact = toConfiguration.artifact(ivyArtifactName);
            artifacts.add(artifact);
        }
        return artifacts;
    }

    protected static boolean include(Iterable<String> configurations, Collection<String> acceptedConfigurations) {
        for (String configuration : configurations) {
            if (configuration.equals("*")) {
                return true;
            }
            if (!acceptedConfigurations.contains(configuration)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public ModuleDependencyMetadata withRequestedVersion(VersionConstraint requestedVersion) {
        if (requestedVersion.equals(this.selector.getVersionConstraint())) {
            return this;
        }
        ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(this.selector.getGroup(), this.selector.getModule(), requestedVersion);
        return this.withRequested(newSelector);
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(moduleTarget.getGroup(), moduleTarget.getModule(), moduleTarget.getVersionConstraint());
            if (newSelector.equals(this.selector)) {
                return this;
            }
            return this.withRequested(newSelector);
        }
        if (target instanceof ProjectComponentSelector) {
            ProjectComponentSelector projectTarget = (ProjectComponentSelector)target;
            return new DefaultProjectDependencyMetadata(projectTarget, this);
        }
        throw new IllegalArgumentException("Unexpected selector provided: " + target);
    }

    protected abstract ModuleDependencyMetadata withRequested(ModuleComponentSelector var1);

    @Override
    public ModuleComponentSelector getSelector() {
        return this.selector;
    }

    public List<Artifact> getDependencyArtifacts() {
        return this.dependencyArtifacts;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }
}

