/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.ProgressBar;
import org.gradle.internal.logging.console.StyledLabel;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.UpdateNowEvent;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.time.Clock;

public class BuildStatusRenderer
implements OutputEventListener {
    public static final int PROGRESS_BAR_WIDTH = 13;
    public static final String PROGRESS_BAR_PREFIX = "<";
    public static final char PROGRESS_BAR_COMPLETE_CHAR = '=';
    public static final char PROGRESS_BAR_INCOMPLETE_CHAR = '-';
    public static final String PROGRESS_BAR_SUFFIX = ">";
    public static final String BUILD_PROGRESS_CATEGORY = "org.gradle.internal.progress.BuildProgressLogger";
    private final OutputEventListener listener;
    private final StyledLabel buildStatusLabel;
    private final Console console;
    private final ConsoleMetaData consoleMetaData;
    private final Clock clock;
    private long currentPhaseProgressOperationId;
    private ProgressBar progressBar;
    private long buildStartTimestamp;
    private boolean timerEnabled;

    public BuildStatusRenderer(OutputEventListener listener, StyledLabel buildStatusLabel, Console console, ConsoleMetaData consoleMetaData, Clock clock) {
        this.listener = listener;
        this.buildStatusLabel = buildStatusLabel;
        this.console = console;
        this.consoleMetaData = consoleMetaData;
        this.clock = clock;
    }

    public void onOutput(OutputEvent event) {
        ProgressEvent progressEvent;
        if (event instanceof ProgressStartEvent) {
            ProgressStartEvent startEvent = (ProgressStartEvent)event;
            if (startEvent.getBuildOperationId() != null && startEvent.getParentBuildOperationId() == null) {
                this.buildStarted(startEvent);
            } else if (BUILD_PROGRESS_CATEGORY.equals(startEvent.getCategory())) {
                this.phaseStarted(startEvent);
            }
        } else if (event instanceof ProgressCompleteEvent) {
            ProgressCompleteEvent completeEvent = (ProgressCompleteEvent)event;
            if (this.isPhaseProgressEvent(completeEvent.getProgressOperationId())) {
                this.phaseEnded(completeEvent);
            }
        } else if (event instanceof ProgressEvent && this.isPhaseProgressEvent((progressEvent = (ProgressEvent)event).getProgressOperationId())) {
            this.phaseProgressed(progressEvent);
        }
        this.listener.onOutput(event);
        if (event instanceof UpdateNowEvent || event instanceof EndOutputEvent) {
            this.renderNow(this.clock.getCurrentTime());
        }
    }

    private boolean isPhaseProgressEvent(OperationIdentifier progressOpId) {
        return progressOpId.getId() == this.currentPhaseProgressOperationId;
    }

    private void renderNow(long now) {
        if (this.progressBar != null) {
            this.buildStatusLabel.setText(this.progressBar.formatProgress(this.consoleMetaData.getCols(), this.timerEnabled, now - this.buildStartTimestamp));
        }
        this.console.flush();
    }

    private void buildStarted(ProgressStartEvent startEvent) {
        this.buildStartTimestamp = this.clock.getCurrentTime();
    }

    private void phaseStarted(ProgressStartEvent progressStartEvent) {
        this.timerEnabled = true;
        this.currentPhaseProgressOperationId = progressStartEvent.getProgressOperationId().getId();
        this.progressBar = this.newProgressBar(progressStartEvent.getShortDescription(), 0, progressStartEvent.getTotalProgress());
    }

    private void phaseProgressed(ProgressEvent progressEvent) {
        if (this.progressBar != null) {
            this.progressBar.update(progressEvent.isFailing());
        }
    }

    private void phaseEnded(ProgressCompleteEvent progressCompleteEvent) {
        this.progressBar = this.newProgressBar(progressCompleteEvent.getStatus(), 0, 1);
        this.timerEnabled = false;
    }

    @VisibleForTesting
    public ProgressBar newProgressBar(String initialSuffix, int initialProgress, int totalProgress) {
        return new ProgressBar(PROGRESS_BAR_PREFIX, 13, PROGRESS_BAR_SUFFIX, '=', '-', initialSuffix, initialProgress, totalProgress);
    }
}

