/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.logging.console.AnsiContext;
import org.gradle.internal.logging.console.Cursor;
import org.gradle.internal.logging.console.RedrawableLabel;
import org.gradle.internal.logging.events.StyledTextOutputEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRedrawableLabel
implements RedrawableLabel {
    private final Cursor writePos;
    private List<StyledTextOutputEvent.Span> spans = Collections.EMPTY_LIST;
    private List<StyledTextOutputEvent.Span> writtenSpans = Collections.EMPTY_LIST;
    private int absolutePositionRow;
    private int previousWriteRow = this.absolutePositionRow;
    private boolean isVisible;
    private boolean previousVisibility = this.isVisible = true;

    DefaultRedrawableLabel(Cursor writePos) {
        this.writePos = writePos;
    }

    @Override
    public void setText(String text) {
        this.setText(new StyledTextOutputEvent.Span(text));
    }

    @Override
    public void setText(List<StyledTextOutputEvent.Span> spans) {
        this.spans = spans;
    }

    @Override
    public void setText(StyledTextOutputEvent.Span ... spans) {
        this.setText(Arrays.asList(spans));
    }

    public Cursor getWritePosition() {
        return this.writePos;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isOverlappingWith(Cursor cursor) {
        return cursor.row == this.writePos.row && this.writePos.col > cursor.col;
    }

    @Override
    public void redraw(AnsiContext ansi) {
        if (this.writePos.row < 0) {
            return;
        }
        if (!this.isVisible && this.previousVisibility) {
            if (this.previousWriteRow == this.absolutePositionRow && this.writtenSpans.equals(Collections.EMPTY_LIST)) {
                return;
            }
            this.writePos.col = 0;
            ansi.cursorAt(this.writePos).eraseAll();
            this.writtenSpans = Collections.EMPTY_LIST;
        }
        if (this.isVisible) {
            if (this.previousWriteRow == this.absolutePositionRow && this.writtenSpans.equals(this.spans)) {
                return;
            }
            int writtenTextLength = this.writePos.col;
            this.writePos.col = 0;
            this.redrawText(ansi.writeAt(this.writePos), writtenTextLength);
            this.writtenSpans = this.spans;
            this.previousWriteRow = this.absolutePositionRow;
        }
    }

    private void redrawText(AnsiContext ansi, int writtenTextLength) {
        int textLength = 0;
        for (StyledTextOutputEvent.Span span : this.spans) {
            ansi.withStyle(span.getStyle(), DefaultRedrawableLabel.writeText(span.getText()));
            textLength += span.getText().length();
        }
        if (this.previousWriteRow == this.absolutePositionRow && textLength < writtenTextLength) {
            ansi.eraseForward();
        }
    }

    private static Action<AnsiContext> writeText(final String text) {
        return new Action<AnsiContext>(){

            @Override
            public void execute(AnsiContext ansi) {
                ansi.a(text);
            }
        };
    }

    public void newLineAdjustment() {
        ++this.writePos.row;
    }

    public void scrollBy(int rows) {
        this.writePos.row -= rows;
        this.absolutePositionRow += rows;
    }

    public void scrollUpBy(int rows) {
        this.scrollBy(-rows);
    }

    public void scrollDownBy(int rows) {
        this.scrollBy(rows);
    }
}

