/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.util.GUtil;

public class ProgressOperation {
    private final String shortDescription;
    private String status;
    private final String category;
    private final OperationIdentifier operationId;
    private ProgressOperation parent;
    private Set<ProgressOperation> children;

    public ProgressOperation(String shortDescription, String status, String category, OperationIdentifier operationId, ProgressOperation parent) {
        this.shortDescription = shortDescription;
        this.status = status;
        this.category = category;
        this.operationId = operationId;
        this.parent = parent;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        if (GUtil.isTrue(this.status)) {
            return this.status;
        }
        if (GUtil.isTrue(this.shortDescription)) {
            return this.shortDescription;
        }
        return null;
    }

    public String getCategory() {
        return this.category;
    }

    public OperationIdentifier getOperationId() {
        return this.operationId;
    }

    public ProgressOperation getParent() {
        return this.parent;
    }

    public boolean addChild(ProgressOperation operation) {
        if (this.children == null) {
            this.children = new HashSet<ProgressOperation>();
        }
        return this.children.add(operation);
    }

    public boolean removeChild(ProgressOperation operation) {
        if (this.children == null) {
            throw new IllegalStateException(String.format("Cannot remove child operation [%s] from operation with no children [%s]", operation.getMessage(), this.getMessage()));
        }
        return this.children.remove(operation);
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }
}

