/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.SingleIncludePatternFileTree;
import org.gradle.api.internal.file.delete.Deleter;
import org.gradle.internal.FileUtils;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.local.AbstractLocallyAvailableResource;
import org.gradle.internal.resource.local.FileStoreAddActionException;
import org.gradle.internal.resource.local.FileStoreException;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.util.GFileUtils;
import org.gradle.util.RelativePathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPathKeyFileStore
implements PathKeyFileStore {
    public static final String IN_PROGRESS_MARKER_FILE_SUFFIX = ".fslck";
    private File baseDir;
    private final Deleter deleter;

    public DefaultPathKeyFileStore(File baseDir) {
        this.baseDir = baseDir;
        IdentityFileResolver fileResolver = new IdentityFileResolver();
        this.deleter = new Deleter(fileResolver, fileResolver.getFileSystem());
    }

    protected File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public LocallyAvailableResource move(String path, File source) {
        return this.saveIntoFileStore(source, this.getFile(path), true);
    }

    @Override
    public LocallyAvailableResource copy(String path, File source) {
        return this.saveIntoFileStore(source, this.getFile(path), false);
    }

    private File getFile(String path) {
        return new File(this.baseDir, path);
    }

    private File getFileWhileCleaningInProgress(String path) {
        File file = this.getFile(path);
        File markerFile = this.getInProgressMarkerFile(file);
        if (markerFile.exists()) {
            this.deleter.delete(file);
            this.deleter.delete(markerFile);
        }
        return file;
    }

    @Override
    public void moveFilestore(File destination) {
        if (this.baseDir.exists()) {
            GFileUtils.moveDirectory(this.baseDir, destination);
        }
        this.baseDir = destination;
    }

    @Override
    public LocallyAvailableResource add(final String path, final Action<File> addAction) {
        try {
            return this.doAdd(this.getFile(path), new Action<File>(){

                @Override
                public void execute(File file) {
                    try {
                        addAction.execute(file);
                    }
                    catch (Throwable e) {
                        throw new FileStoreAddActionException(String.format("Failed to add into filestore '%s' at '%s' ", DefaultPathKeyFileStore.this.getBaseDir().getAbsolutePath(), path), e);
                    }
                }
            });
        }
        catch (FileStoreAddActionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new FileStoreException(String.format("Failed to add into filestore '%s' at '%s' ", this.getBaseDir().getAbsolutePath(), path), e);
        }
    }

    protected LocallyAvailableResource saveIntoFileStore(final File source, File destination, final boolean isMove) {
        String verb;
        String string = verb = isMove ? "move" : "copy";
        if (!source.exists()) {
            throw new FileStoreException(String.format("Cannot %s '%s' into filestore @ '%s' as it does not exist", verb, source, destination));
        }
        try {
            return this.doAdd(destination, new Action<File>(){

                @Override
                public void execute(File file) {
                    if (isMove) {
                        if (source.isDirectory()) {
                            GFileUtils.moveDirectory(source, file);
                        } else {
                            GFileUtils.moveFile(source, file);
                        }
                    } else if (source.isDirectory()) {
                        GFileUtils.copyDirectory(source, file);
                    } else {
                        GFileUtils.copyFile(source, file);
                    }
                }
            });
        }
        catch (Throwable e) {
            throw new FileStoreException(String.format("Failed to %s file '%s' into filestore at '%s' ", verb, source, destination), e);
        }
    }

    protected LocallyAvailableResource doAdd(File destination, Action<File> action) {
        GFileUtils.parentMkdirs(destination);
        File inProgressMarkerFile = this.getInProgressMarkerFile(destination);
        GFileUtils.touch(inProgressMarkerFile);
        try {
            this.deleter.delete(destination);
            action.execute(destination);
        }
        catch (Throwable t) {
            try {
                this.deleter.delete(destination);
                throw UncheckedException.throwAsUncheckedException(t);
            }
            catch (Throwable throwable) {
                this.deleter.delete(inProgressMarkerFile);
                throw throwable;
            }
        }
        this.deleter.delete(inProgressMarkerFile);
        return this.entryAt(destination);
    }

    @Override
    public Set<? extends LocallyAvailableResource> search(String pattern) {
        if (!this.getBaseDir().exists()) {
            return Collections.emptySet();
        }
        final HashSet entries = new HashSet();
        this.findFiles(pattern).visit(new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                File file = fileDetails.getFile();
                if (!DefaultPathKeyFileStore.this.isInProgressMarkerFile(file) && !DefaultPathKeyFileStore.this.isInProgressFile(file)) {
                    entries.add(DefaultPathKeyFileStore.this.entryAt(file));
                }
            }
        });
        return entries;
    }

    private File getInProgressMarkerFile(File file) {
        return new File(file.getParent(), file.getName() + IN_PROGRESS_MARKER_FILE_SUFFIX);
    }

    private boolean isInProgressMarkerFile(File file) {
        return FileUtils.hasExtension(file, IN_PROGRESS_MARKER_FILE_SUFFIX);
    }

    private boolean isInProgressFile(File file) {
        return this.getInProgressMarkerFile(file).exists();
    }

    private MinimalFileTree findFiles(String pattern) {
        return new SingleIncludePatternFileTree(this.baseDir, pattern);
    }

    protected LocallyAvailableResource entryAt(File file) {
        return this.entryAt(RelativePathUtil.relativePath(this.baseDir, file));
    }

    protected LocallyAvailableResource entryAt(String path) {
        return new RelativeToBaseDirResource(path);
    }

    @Override
    public LocallyAvailableResource get(String key) {
        File file = this.getFileWhileCleaningInProgress(key);
        if (file.exists()) {
            return new RelativeToBaseDirResource(key);
        }
        return null;
    }

    private class RelativeToBaseDirResource
    extends AbstractLocallyAvailableResource {
        private final String path;

        public RelativeToBaseDirResource(String path) {
            this.path = path;
        }

        public File getFile() {
            return new File(DefaultPathKeyFileStore.this.baseDir, this.path);
        }
    }
}

