/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.BuildableCompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.DefaultIncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncementalCompileSourceProcessor;
import org.gradle.language.nativeplatform.internal.incremental.IncludeFileState;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.SourceFileState;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalCompileFilesFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementalCompileFilesFactory.class);
    private static final String IGNORE_UNRESOLVED_HEADERS_IN_DEPENDENCIES_PROPERTY_NAME = "org.gradle.internal.native.headers.unresolved.dependencies.ignore";
    private final SourceIncludesParser sourceIncludesParser;
    private final SourceIncludesResolver sourceIncludesResolver;
    private final FileSystemSnapshotter snapshotter;
    private final boolean ignoreUnresolvedHeadersInDependencies;

    public IncrementalCompileFilesFactory(SourceIncludesParser sourceIncludesParser, SourceIncludesResolver sourceIncludesResolver, FileSystemSnapshotter snapshotter) {
        this.sourceIncludesParser = sourceIncludesParser;
        this.sourceIncludesResolver = sourceIncludesResolver;
        this.snapshotter = snapshotter;
        this.ignoreUnresolvedHeadersInDependencies = Boolean.getBoolean(IGNORE_UNRESOLVED_HEADERS_IN_DEPENDENCIES_PROPERTY_NAME);
    }

    public IncementalCompileSourceProcessor filesFor(CompilationState previousCompileState) {
        return new DefaultIncementalCompileSourceProcessor(previousCompileState);
    }

    private static class FileVisitResult {
        private final IncludeFileResolutionResult result;
        private final IncludeFileState fileState;
        private final IncludeDirectives includeDirectives;
        private final Set<IncludeFileState> includeFileStates;
        private final Set<IncludeDirectives> includeFileDirectives;

        FileVisitResult(IncludeFileResolutionResult result, IncludeFileState fileState, IncludeDirectives includeDirectives, Set<IncludeFileState> dependentFiles, Set<IncludeDirectives> dependentIncludeDirectives) {
            this.result = result;
            this.fileState = fileState;
            this.includeDirectives = includeDirectives;
            this.includeFileStates = dependentFiles;
            this.includeFileDirectives = dependentIncludeDirectives;
        }

        FileVisitResult() {
            this.result = IncludeFileResolutionResult.NoMacroIncludes;
            this.fileState = null;
            this.includeDirectives = null;
            this.includeFileStates = Collections.emptySet();
            this.includeFileDirectives = Collections.emptySet();
        }

        void collectDependencies(Collection<IncludeFileState> fileStates, Collection<IncludeDirectives> directives) {
            if (this.fileState != null) {
                fileStates.add(this.fileState);
                fileStates.addAll(this.includeFileStates);
                directives.add(this.includeDirectives);
                directives.addAll(this.includeFileDirectives);
            }
        }
    }

    private static class FileDetails {
        final IncludeFileState state;
        final IncludeDirectives directives;
        @Nullable
        FileVisitResult results;

        FileDetails(IncludeFileState state, IncludeDirectives directives) {
            this.state = state;
            this.directives = directives;
        }
    }

    private static enum IncludeFileResolutionResult {
        NoMacroIncludes,
        HasMacroIncludes,
        UnresolvedMacroIncludes;

    }

    private class DefaultIncementalCompileSourceProcessor
    implements IncementalCompileSourceProcessor {
        private final CompilationState previous;
        private final BuildableCompilationState current = new BuildableCompilationState();
        private final List<File> toRecompile = new ArrayList<File>();
        private final Set<File> discoveredInputs = Sets.newHashSet();
        private final Set<File> existingHeaders = Sets.newHashSet();
        private final Map<File, IncludeDirectives> includeDirectivesMap = new HashMap<File, IncludeDirectives>();
        private final Map<File, FileDetails> visitedFiles = new HashMap<File, FileDetails>();
        private boolean hasUnresolvedHeaders;

        DefaultIncementalCompileSourceProcessor(CompilationState previousCompileState) {
            this.previous = previousCompileState == null ? new CompilationState() : previousCompileState;
        }

        @Override
        public IncrementalCompilation getResult() {
            return new DefaultIncrementalCompilation(this.current.snapshot(), this.toRecompile, this.getRemovedSources(), this.discoveredInputs, this.existingHeaders, this.hasUnresolvedHeaders, this.includeDirectivesMap);
        }

        @Override
        public void processSource(File sourceFile) {
            if (this.visitSourceFile(sourceFile)) {
                this.toRecompile.add(sourceFile);
            }
        }

        private boolean visitSourceFile(File sourceFile) {
            FileSnapshot fileSnapshot = IncrementalCompileFilesFactory.this.snapshotter.snapshotSelf(sourceFile);
            if (fileSnapshot.getType() != FileType.RegularFile) {
                return false;
            }
            SourceFileState previousState = this.previous.getState(sourceFile);
            FileVisitResult result = this.visitFile(sourceFile, new ArrayList<IncludeDirectives>(), new HashSet<File>(), true);
            SourceFileState newState = new SourceFileState(fileSnapshot.getContent().getContentMd5(), (ImmutableSet<IncludeFileState>)ImmutableSet.copyOf((Collection)result.includeFileStates));
            this.current.setState(sourceFile, newState);
            this.includeDirectivesMap.put(sourceFile, result.includeDirectives);
            return previousState == null || result.result == IncludeFileResolutionResult.UnresolvedMacroIncludes || newState.hasChanged(previousState);
        }

        private FileVisitResult visitFile(File file, List<IncludeDirectives> visibleIncludeDirectives, Set<File> visited, boolean isSourceFile) {
            FileDetails fileDetails = this.visitedFiles.get(file);
            if (fileDetails != null && fileDetails.results != null) {
                visibleIncludeDirectives.addAll(fileDetails.results.includeFileDirectives);
                return fileDetails.results;
            }
            if (!visited.add(file)) {
                return new FileVisitResult();
            }
            if (fileDetails == null) {
                FileSnapshot fileSnapshot = IncrementalCompileFilesFactory.this.snapshotter.snapshotSelf(file);
                HashCode newHash = fileSnapshot.getContent().getContentMd5();
                IncludeDirectives includeDirectives = IncrementalCompileFilesFactory.this.sourceIncludesParser.parseIncludes(file);
                fileDetails = new FileDetails(new IncludeFileState(newHash, file), includeDirectives);
                this.visitedFiles.put(file, fileDetails);
            }
            LinkedHashSet<IncludeFileState> includedFileStates = new LinkedHashSet<IncludeFileState>();
            LinkedHashSet<IncludeDirectives> includedFileDirectives = new LinkedHashSet<IncludeDirectives>();
            visibleIncludeDirectives.add(fileDetails.directives);
            IncludeFileResolutionResult result = IncludeFileResolutionResult.NoMacroIncludes;
            for (Include include : fileDetails.directives.getAll()) {
                if (include.getType() == IncludeType.MACRO && result == IncludeFileResolutionResult.NoMacroIncludes) {
                    result = IncludeFileResolutionResult.HasMacroIncludes;
                }
                SourceIncludesResolver.IncludeResolutionResult resolutionResult = IncrementalCompileFilesFactory.this.sourceIncludesResolver.resolveInclude(file, include, visibleIncludeDirectives);
                this.discoveredInputs.addAll(resolutionResult.getCheckedLocations());
                if (!resolutionResult.isComplete()) {
                    LOGGER.info("Cannot locate header file for include '{}' in source file '{}'. Assuming changed.", (Object)resolutionResult.getInclude(), (Object)file.getName());
                    result = IncludeFileResolutionResult.UnresolvedMacroIncludes;
                    if (isSourceFile || !IncrementalCompileFilesFactory.this.ignoreUnresolvedHeadersInDependencies) {
                        this.hasUnresolvedHeaders = true;
                    }
                }
                for (File includeFile : resolutionResult.getFiles()) {
                    this.existingHeaders.add(includeFile);
                    FileVisitResult includeVisitResult = this.visitFile(includeFile, visibleIncludeDirectives, visited, false);
                    if (includeVisitResult.result.ordinal() > result.ordinal()) {
                        result = includeVisitResult.result;
                    }
                    includeVisitResult.collectDependencies(includedFileStates, includedFileDirectives);
                }
            }
            FileVisitResult visitResult = new FileVisitResult(result, fileDetails.state, fileDetails.directives, includedFileStates, includedFileDirectives);
            if (result == IncludeFileResolutionResult.NoMacroIncludes) {
                fileDetails.results = visitResult;
            }
            return visitResult;
        }

        private List<File> getRemovedSources() {
            ArrayList<File> removed = new ArrayList<File>();
            for (File previousSource : this.previous.getSourceInputs()) {
                if (this.current.getSourceInputs().contains(previousSource)) continue;
                removed.add(previousSource);
            }
            return removed;
        }
    }
}

