/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.groovy.scripts.internal.AbstractScriptTransformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.model.dsl.internal.transform.RuleVisitor;
import org.gradle.model.dsl.internal.transform.RulesVisitor;

public class ModelBlockTransformer
extends AbstractScriptTransformer {
    public static final String MODEL = "model";
    private static final List<String> SCRIPT_BLOCK_NAMES = Collections.singletonList("model");
    public static final String NON_LITERAL_CLOSURE_TO_TOP_LEVEL_MODEL_MESSAGE = "The top level model() method can only be called with a literal closure argument";
    private final String scriptSourceDescription;
    @Nullable
    private final URI location;

    protected int getPhase() {
        return 5;
    }

    public ModelBlockTransformer(String scriptSourceDescription, @Nullable URI location) {
        this.scriptSourceDescription = scriptSourceDescription;
        this.location = location;
    }

    public void call(SourceUnit source) throws CompilationFailedException {
        List statements = source.getAST().getStatementBlock().getStatements();
        for (Statement statement : statements) {
            ScriptBlock scriptBlock = AstUtils.detectScriptBlock(statement, SCRIPT_BLOCK_NAMES);
            if (scriptBlock == null) {
                String methodName;
                MethodCallExpression methodCall = AstUtils.extractBareMethodCall(statement);
                if (methodCall == null || (methodName = AstUtils.extractConstantMethodName(methodCall)) == null || !methodName.equals(MODEL)) continue;
                source.getErrorCollector().addError(new SyntaxException(NON_LITERAL_CLOSURE_TO_TOP_LEVEL_MODEL_MESSAGE, statement.getLineNumber(), statement.getColumnNumber()), source);
                continue;
            }
            RuleVisitor ruleVisitor = new RuleVisitor(source, this.scriptSourceDescription, this.location);
            RulesVisitor rulesVisitor = new RulesVisitor(source, ruleVisitor);
            scriptBlock.getClosureExpression().getCode().visit((GroovyCodeVisitor)rulesVisitor);
        }
    }
}

