/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitComponent;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitComponentLocator;
import org.gradle.util.TreeVisitor;
import org.gradle.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWindowsKitComponentLocator<T extends WindowsKitComponent>
implements WindowsKitComponentLocator<T> {
    private static final String USER_PROVIDED = "User-provided";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWindowsKitComponentLocator.class);
    private final Map<File, Set<T>> foundComponents = new HashMap<File, Set<T>>();
    private final WindowsRegistry windowsRegistry;
    private boolean initialised;
    private static final String[] REGISTRY_BASEPATHS = new String[]{"SOFTWARE\\", "SOFTWARE\\Wow6432Node\\"};
    private static final String REGISTRY_ROOTPATH_KIT = "Microsoft\\Windows Kits\\Installed Roots";
    private static final String REGISTRY_KIT_10 = "KitsRoot10";
    private final Pattern windowsKitVersionPattern = Pattern.compile("[0-9]+(\\.[0-9]+)*");
    private final FileFilter windowsKitVersionFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            Matcher matcher = AbstractWindowsKitComponentLocator.this.windowsKitVersionPattern.matcher(pathname.getName());
            return pathname.isDirectory() && matcher.matches();
        }
    };

    AbstractWindowsKitComponentLocator(WindowsRegistry windowsRegistry) {
        this.windowsRegistry = windowsRegistry;
    }

    @Override
    public WindowsKitComponentLocator.SearchResult<T> locateComponents(File candidate) {
        this.initializeComponents();
        if (candidate != null) {
            return this.locateUserSpecifiedComponent(candidate);
        }
        return this.locateDefaultComponent();
    }

    @Override
    public List<T> locateAllComponents() {
        this.initializeComponents();
        ArrayList allComponents = Lists.newArrayList();
        for (Set<T> components : this.foundComponents.values()) {
            allComponents.addAll(components);
        }
        return allComponents;
    }

    private void initializeComponents() {
        if (!this.initialised) {
            this.locateComponentsInRegistry();
            this.initialised = true;
        }
    }

    private WindowsKitComponentLocator.SearchResult<T> locateDefaultComponent() {
        T selected = this.getBestComponent();
        return selected == null ? new ComponentNotFound("Could not locate a " + this.getDisplayName() + " installation using the Windows registry.") : new ComponentFound(this, selected);
    }

    private T getBestComponent(File baseDir) {
        TreeSet<T> candidates = new TreeSet<T>(new DescendingComponentVersionComparator());
        Set<T> components = this.foundComponents.get(baseDir);
        if (components != null) {
            candidates.addAll(components);
        }
        return (T)(candidates.isEmpty() ? null : (WindowsKitComponent)candidates.iterator().next());
    }

    private T getBestComponent() {
        TreeSet<T> candidates = new TreeSet<T>(new DescendingComponentVersionComparator());
        for (Set<T> components : this.foundComponents.values()) {
            candidates.addAll(components);
        }
        return (T)(candidates.isEmpty() ? null : (WindowsKitComponent)candidates.iterator().next());
    }

    private void locateComponentsInRegistry() {
        for (String baseKey : REGISTRY_BASEPATHS) {
            this.locateComponentsInRegistry(baseKey);
        }
    }

    private void locateComponentsInRegistry(String baseKey) {
        try {
            File windowsKitDir = FileUtils.canonicalize(new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_KIT, REGISTRY_KIT_10)));
            String[] versionDirs = this.getComponentVersionDirs(windowsKitDir);
            if (this.isValidComponentBaseDir(windowsKitDir) && versionDirs.length > 0) {
                for (String versionDir : versionDirs) {
                    VersionNumber version = VersionNumber.withPatchNumber().parse(versionDir);
                    LOGGER.debug("Found {} {} at {}", new Object[]{this.getDisplayName(), version.toString(), windowsKitDir});
                    this.putComponent(this.newComponent(windowsKitDir, version, DiscoveryType.REGISTRY));
                }
            } else {
                LOGGER.debug("Ignoring candidate directory {} as it does not look like a {} installation.", (Object)windowsKitDir, (Object)this.getDisplayName());
            }
        }
        catch (MissingRegistryEntryException missingRegistryEntryException) {
            // empty catch block
        }
    }

    private WindowsKitComponentLocator.SearchResult<T> locateUserSpecifiedComponent(File candidate) {
        File windowsKitDir = FileUtils.canonicalize(candidate);
        String[] versionDirs = this.getComponentVersionDirs(windowsKitDir);
        if (this.isValidComponentBaseDir(windowsKitDir) && versionDirs.length > 0) {
            for (String versionDir : versionDirs) {
                VersionNumber version = VersionNumber.withPatchNumber().parse(versionDir);
                LOGGER.debug("Found {} {} ({}) at {}", new Object[]{this.getDisplayName(), version.toString(), versionDir, windowsKitDir});
                if (this.foundComponents.containsKey(windowsKitDir)) continue;
                this.putComponent(this.newComponent(windowsKitDir, version, DiscoveryType.USER));
            }
            return new ComponentFound(this, this.getBestComponent(candidate));
        }
        return new ComponentNotFound(String.format("The specified installation directory '%s' does not appear to contain a %s installation.", candidate, this.getDisplayName()));
    }

    private String[] getComponentVersionDirs(File candidate) {
        File includeDir = new File(candidate, "Include");
        File libDir = new File(candidate, "Lib");
        if (!includeDir.isDirectory() || !libDir.isDirectory()) {
            return new String[0];
        }
        HashMap<String, File> includeDirs = new HashMap<String, File>();
        for (File dir : includeDir.listFiles(this.windowsKitVersionFilter)) {
            includeDirs.put(dir.getName(), dir);
        }
        HashMap<String, File> libDirs = new HashMap<String, File>();
        for (File dir : libDir.listFiles(this.windowsKitVersionFilter)) {
            libDirs.put(dir.getName(), dir);
        }
        HashSet kitVersions = new HashSet();
        kitVersions.addAll(includeDirs.keySet());
        kitVersions.addAll(libDirs.keySet());
        ArrayList<String> result = new ArrayList<String>();
        for (String version : kitVersions) {
            File inc = (File)includeDirs.get(version);
            File lib = (File)libDirs.get(version);
            if (inc == null || lib == null) continue;
            File componentInc = new File(inc, this.getComponentName());
            File componentLib = new File(lib, this.getComponentName());
            if (!this.isValidComponentIncludeDir(componentInc) || !this.isValidComponentLibDir(componentLib)) continue;
            result.add(version);
        }
        return result.toArray(new String[result.size()]);
    }

    private void putComponent(T component) {
        Set<T> components = this.foundComponents.get(((WindowsKitComponent)component).getBaseDir());
        if (components == null) {
            components = new HashSet<T>();
            this.foundComponents.put(((WindowsKitComponent)component).getBaseDir(), components);
        }
        components.add(component);
    }

    protected String getVersionedDisplayName(VersionNumber version, DiscoveryType discoveryType) {
        switch (discoveryType) {
            case USER: {
                return "User-provided " + this.getDisplayName() + " " + version.getMajor();
            }
            case REGISTRY: {
                return this.getDisplayName() + " " + version.getMajor();
            }
        }
        throw new IllegalArgumentException("Unknown discovery method for " + this.getDisplayName() + ": " + (Object)((Object)discoveryType));
    }

    abstract String getComponentName();

    abstract String getDisplayName();

    abstract boolean isValidComponentBaseDir(File var1);

    abstract boolean isValidComponentIncludeDir(File var1);

    abstract boolean isValidComponentLibDir(File var1);

    abstract T newComponent(File var1, VersionNumber var2, DiscoveryType var3);

    private class DescendingComponentVersionComparator
    implements Comparator<T> {
        private DescendingComponentVersionComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return ((WindowsKitComponent)o2).getVersion().compareTo(((WindowsKitComponent)o1).getVersion());
        }
    }

    private class ComponentNotFound
    implements WindowsKitComponentLocator.SearchResult<T> {
        private final String message;

        private ComponentNotFound(String message) {
            this.message = message;
        }

        @Override
        public T getComponent() {
            return null;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node(this.message);
        }
    }

    private static class ComponentFound
    implements WindowsKitComponentLocator.SearchResult<T> {
        private final T component;
        final /* synthetic */ AbstractWindowsKitComponentLocator this$0;

        public ComponentFound(T component) {
            this.this$0 = var1_1;
            this.component = component;
        }

        @Override
        public T getComponent() {
            return this.component;
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
        }
    }

    protected static enum DiscoveryType {
        REGISTRY,
        USER;

    }
}

