/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps.builder;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.tools.idea.gradle.output.parser.BuildOutputParser;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.jps.AndroidGradleJps;
import com.android.tools.idea.jps.builder.AndroidGradleBuildTarget;
import com.android.tools.idea.jps.builder.BuilderExecutionSettings;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.service.JpsServiceManager;

public class AndroidGradleTargetBuilder
extends TargetBuilder<AndroidGradleBuildTarget.RootDescriptor, AndroidGradleBuildTarget> {
    private static final Logger LOG = Logger.getInstance(AndroidGradleTargetBuilder.class);
    @NonNls
    private static final String BUILDER_NAME = "Android Gradle Target Builder";
    private static final int BUFFER_SIZE = 2048;

    public AndroidGradleTargetBuilder() {
        super(Collections.singletonList(AndroidGradleBuildTarget.TargetType.INSTANCE));
    }

    public void build(@NotNull AndroidGradleBuildTarget target, @NotNull DirtyFilesHolder<AndroidGradleBuildTarget.RootDescriptor, AndroidGradleBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        BuilderExecutionSettings executionSettings;
        if (target == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(3);
        }
        JpsProject project = target.getProject();
        AndroidGradleTargetBuilder.checkUnsupportedModules(project, context);
        try {
            executionSettings = new BuilderExecutionSettings();
        }
        catch (RuntimeException e) {
            throw new ProjectBuildException((Throwable)e);
        }
        LOG.info("Using execution settings: " + executionSettings);
        List<String> buildTasks = executionSettings.getGradleTasksToInvoke();
        if (buildTasks.isEmpty()) {
            String format = "No build tasks found for project '%1$s'. Nothing done.";
            LOG.info(String.format(format, project.getName()));
            return;
        }
        context.processMessage((BuildMessage)AndroidGradleJps.createCompilerMessage(BuildMessage.Kind.INFO, "Executing tasks: " + buildTasks));
        String msg = "Gradle build using tasks: " + buildTasks;
        context.processMessage((BuildMessage)new ProgressMessage(msg));
        LOG.info(msg);
        AndroidGradleTargetBuilder.ensureTempDirExists();
        String androidHome = null;
        if (!AndroidGradleSettings.isAndroidSdkDirInLocalPropertiesFile((File)executionSettings.getProjectDir())) {
            androidHome = AndroidGradleTargetBuilder.getAndroidHomeFromModuleSdk(project);
        }
        String format = "About to build project '%1$s' located at %2$s";
        LOG.info(String.format(format, project.getName(), executionSettings.getProjectDir().getAbsolutePath()));
        AndroidGradleTargetBuilder.doBuild(context, buildTasks, executionSettings, androidHome);
    }

    private static void checkUnsupportedModules(JpsProject project, CompileContext context) {
        for (JpsTypedModule module : project.getModules((JpsModuleType)JpsJavaModuleType.INSTANCE)) {
            if (AndroidGradleJps.getGradleSystemExtension((JpsModule)module) != null) continue;
            context.processMessage((BuildMessage)AndroidGradleJps.createCompilerMessage(BuildMessage.Kind.WARNING, "module '" + module.getName() + "' won't be compiled. Unfortunately you can't have non-Gradle Java module and Android-Gradle module in one project."));
        }
    }

    private static void ensureTempDirExists() {
        String tmpDirProperty = System.getProperty("java.io.tmpdir");
        if (!Strings.isNullOrEmpty((String)tmpDirProperty)) {
            File tmpDir = new File(tmpDirProperty);
            try {
                FileUtil.ensureExists((File)tmpDir);
            }
            catch (IOException e) {
                LOG.warn("Unable to create temp directory", (Throwable)e);
            }
        }
    }

    @Nullable
    private static String getAndroidHomeFromModuleSdk(@NotNull JpsProject project) {
        JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> androidSdk;
        if (project == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(4);
        }
        if ((androidSdk = AndroidGradleTargetBuilder.getFirstAndroidSdk(project)) == null) {
            String msg = String.format("There is no Android SDK specified for project '%1$s'", project.getName());
            LOG.error(msg);
            return null;
        }
        String androidHome = androidSdk.getHomePath();
        if (Strings.isNullOrEmpty((String)androidHome)) {
            String msg = "Selected Android SDK does not have a home directory path";
            LOG.error(msg);
            return null;
        }
        return androidHome;
    }

    @Nullable
    private static JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> getFirstAndroidSdk(@NotNull JpsProject project) {
        if (project == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(5);
        }
        for (JpsModule module : project.getModules()) {
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsAndroidSdkType.INSTANCE);
            if (sdk == null) continue;
            return sdk;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doBuild(@NotNull CompileContext context, @NotNull List<String> buildTasks, @NotNull BuilderExecutionSettings executionSettings, @Nullable String androidHome) throws ProjectBuildException {
        if (context == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(6);
        }
        if (buildTasks == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(7);
        }
        if (executionSettings == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(8);
        }
        GradleConnector connector = AndroidGradleTargetBuilder.getGradleConnector(executionSettings);
        ProjectConnection connection = connector.connect();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream(2048);
        ByteArrayOutputStream stderr = new ByteArrayOutputStream(2048);
        try {
            File javaHomeDir;
            BuildLauncher launcher = connection.newBuild();
            launcher.forTasks(ArrayUtil.toStringArray(buildTasks));
            ArrayList jvmArgs = Lists.newArrayList();
            BuildMode buildMode = executionSettings.getBuildMode();
            if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
                String arg = AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
                jvmArgs.add(arg);
            }
            if (androidHome != null && !androidHome.isEmpty()) {
                String androidSdkArg = AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHome);
                jvmArgs.add(androidSdkArg);
            }
            jvmArgs.addAll(executionSettings.getJvmOptions());
            LOG.info("Build JVM args: " + jvmArgs);
            if (!jvmArgs.isEmpty()) {
                launcher.setJvmArguments(ArrayUtil.toStringArray((Collection)jvmArgs));
            }
            ArrayList commandLineArgs = Lists.newArrayList();
            commandLineArgs.addAll(executionSettings.getCommandLineOptions());
            commandLineArgs.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
            if (executionSettings.isParallelBuild() && !commandLineArgs.contains("--parallel")) {
                commandLineArgs.add("--parallel");
            }
            if (executionSettings.isOfflineBuild() && !commandLineArgs.contains("--offline")) {
                commandLineArgs.add("--offline");
            }
            if (executionSettings.isConfigureOnDemand() && !commandLineArgs.contains("--configure-on-demand")) {
                commandLineArgs.add("--configure-on-demand");
            }
            LOG.info("Build command line args: " + commandLineArgs);
            if (!commandLineArgs.isEmpty()) {
                launcher.withArguments(ArrayUtil.toStringArray((Collection)commandLineArgs));
            }
            if ((javaHomeDir = executionSettings.getJavaHomeDir()) != null) {
                launcher.setJavaHome(javaHomeDir);
            }
            launcher.setStandardOutput((OutputStream)stdout);
            launcher.setStandardError((OutputStream)stderr);
            launcher.run();
        }
        catch (BuildException e) {
            AndroidGradleTargetBuilder.handleBuildException(e, context, stderr.toString());
        }
        finally {
            String outText = stdout.toString();
            context.processMessage((BuildMessage)new ProgressMessage(outText, 1.0f));
            try {
                Closeables.close((Closeable)stdout, (boolean)true);
                Closeables.close((Closeable)stderr, (boolean)true);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
            connection.close();
        }
    }

    @NotNull
    private static GradleConnector getGradleConnector(@NotNull BuilderExecutionSettings executionSettings) {
        File gradleServiceDir;
        GradleConnector connector;
        if (executionSettings == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(9);
        }
        if ((connector = GradleConnector.newConnector()) instanceof DefaultGradleConnector) {
            DefaultGradleConnector defaultConnector = (DefaultGradleConnector)connector;
            if (executionSettings.isEmbeddedModeEnabled()) {
                LOG.info("Using Gradle embedded mode.");
                defaultConnector.embedded(true);
            }
            defaultConnector.setVerboseLogging(executionSettings.isVerboseLoggingEnabled());
        }
        connector.forProjectDirectory(executionSettings.getProjectDir());
        File gradleHomeDir = executionSettings.getGradleHomeDir();
        if (gradleHomeDir != null) {
            connector.useInstallation(gradleHomeDir);
        }
        if ((gradleServiceDir = executionSettings.getGradleServiceDir()) != null) {
            connector.useGradleUserHomeDir(gradleServiceDir);
        }
        GradleConnector gradleConnector = connector;
        if (gradleConnector == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(10);
        }
        return gradleConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleBuildException(BuildException e, CompileContext context, String stdErr) throws ProjectBuildException {
        Iterable parsers = JpsServiceManager.getInstance().getExtensions(PatternAwareOutputParser.class);
        List compilerMessages = new BuildOutputParser(parsers).parseGradleOutput(stdErr);
        if (!compilerMessages.isEmpty()) {
            boolean hasError = false;
            for (Message message : compilerMessages) {
                if (message.getKind() == Message.Kind.ERROR) {
                    hasError = true;
                }
                for (CompilerMessage compilerMessage : AndroidGradleJps.createCompilerMessages(message)) {
                    context.processMessage((BuildMessage)compilerMessage);
                }
            }
            if (hasError) {
                return;
            }
        }
        if (!stdErr.isEmpty()) {
            context.processMessage((BuildMessage)AndroidGradleTargetBuilder.createCompilerErrorMessage(stdErr));
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            try {
                e.printStackTrace(new PrintStream(out));
                String message = "Internal error:" + SystemProperties.getLineSeparator() + out.toString();
                context.processMessage((BuildMessage)AndroidGradleTargetBuilder.createCompilerErrorMessage(message));
            }
            finally {
                try {
                    Closeables.close((Closeable)out, (boolean)true);
                }
                catch (IOException e1) {
                    LOG.debug((Throwable)e1);
                }
            }
        }
        throw new ProjectBuildException(e.getMessage());
    }

    @NotNull
    private static CompilerMessage createCompilerErrorMessage(@NotNull String msg) {
        if (msg == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(11);
        }
        CompilerMessage compilerMessage = AndroidGradleJps.createCompilerMessage(BuildMessage.Kind.ERROR, msg);
        if (compilerMessage == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(12);
        }
        return compilerMessage;
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            AndroidGradleTargetBuilder.$$$reportNull$$$0(13);
        }
        return BUILDER_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTasks";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettings";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleConnector";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompilerErrorMessage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidHomeFromModuleSdk";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFirstAndroidSdk";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getGradleConnector";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCompilerErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

