/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.handler.unified;

import com.intellij.debugger.streams.trace.dsl.ArrayVariable;
import com.intellij.debugger.streams.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.trace.dsl.CodeContext;
import com.intellij.debugger.streams.trace.dsl.Convertable;
import com.intellij.debugger.streams.trace.dsl.Dsl;
import com.intellij.debugger.streams.trace.dsl.Expression;
import com.intellij.debugger.streams.trace.dsl.LambdaBody;
import com.intellij.debugger.streams.trace.dsl.Statement;
import com.intellij.debugger.streams.trace.dsl.Variable;
import com.intellij.debugger.streams.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.trace.impl.handler.type.ClassTypeImpl;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.trace.impl.handler.unified.HandlerBase;
import com.intellij.debugger.streams.trace.impl.handler.unified.MatchHandler;
import com.intellij.debugger.streams.trace.impl.handler.unified.PeekTraceHandler;
import com.intellij.debugger.streams.wrapper.CallArgument;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import com.intellij.debugger.streams.wrapper.impl.CallArgumentImpl;
import com.intellij.debugger.streams.wrapper.impl.IntermediateStreamCallImpl;
import com.intellij.debugger.streams.wrapper.impl.TerminatorStreamCallImpl;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u001a\u0010\u0015\u001a\u00020\u0003*\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/debugger/streams/trace/impl/handler/unified/MatchHandler;", "Lcom/intellij/debugger/streams/trace/impl/handler/unified/HandlerBase$Terminal;", "call", "Lcom/intellij/debugger/streams/wrapper/TerminatorStreamCall;", "dsl", "Lcom/intellij/debugger/streams/trace/dsl/Dsl;", "(Lcom/intellij/debugger/streams/wrapper/TerminatorStreamCall;Lcom/intellij/debugger/streams/trace/dsl/Dsl;)V", "myPeekHandler", "Lcom/intellij/debugger/streams/trace/impl/handler/unified/PeekTraceHandler;", "myPredicateVariable", "Lcom/intellij/debugger/streams/trace/dsl/Variable;", "additionalCallsBefore", "", "Lcom/intellij/debugger/streams/wrapper/IntermediateStreamCall;", "additionalVariablesDeclaration", "Lcom/intellij/debugger/streams/trace/dsl/VariableDeclaration;", "getResultExpression", "Lcom/intellij/debugger/streams/trace/dsl/Expression;", "prepareResult", "Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "transformCall", "transformArgs", "args", "Lcom/intellij/debugger/streams/wrapper/CallArgument;", "Companion", "intellij.java.debugger.streams"})
public final class MatchHandler
extends HandlerBase.Terminal {
    private final PeekTraceHandler myPeekHandler;
    private final Variable myPredicateVariable;
    private final TerminatorStreamCall call;
    @NotNull
    private static final String PREDICATE_NAME = "predicate42";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<VariableDeclaration> additionalVariablesDeclaration() {
        List variables = new ArrayList();
        variables.addAll((Collection)this.myPeekHandler.additionalVariablesDeclaration());
        CallArgument predicate = (CallArgument)CollectionsKt.first(this.call.getArguments());
        Dsl dsl = this.getDsl();
        String string = predicate.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"predicate.text");
        variables.add(dsl.declaration(this.myPredicateVariable, new TextExpression(string), false));
        return variables;
    }

    @Override
    @NotNull
    public CodeBlock prepareResult() {
        return this.getDsl().block((Function1<? super CodeContext, Unit>)((Function1)new Function1<CodeContext, Unit>(this){
            final /* synthetic */ MatchHandler this$0;

            public final void invoke(@NotNull CodeContext $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                ArrayVariable result = $receiver.array($receiver.getTypes().getANY(), "result");
                $receiver.declare(result, $receiver.newSizedArray($receiver.getTypes().getANY(), 2), false);
                $receiver.scope((Function1<? super CodeBlock, Unit>)((Function1)new Function1<CodeBlock, Unit>(this, result){
                    final /* synthetic */ prepareResult.1 this$0;
                    final /* synthetic */ ArrayVariable $result;

                    public final void invoke(@NotNull CodeBlock $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        $receiver.add(MatchHandler.access$getMyPeekHandler$p(this.this$0.this$0).prepareResult());
                        $receiver.statement((Function0<? extends Statement>)((Function0)new Function0<Expression>(this){
                            final /* synthetic */ prepareResult.1 this$0;

                            @NotNull
                            public final Expression invoke() {
                                return this.this$0.$result.set(0, MatchHandler.access$getMyPeekHandler$p(this.this$0.this$0.this$0).getResultExpression());
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$result = arrayVariable;
                        super(1);
                    }
                }));
                $receiver.statement((Function0<? extends Statement>)((Function0)new Function0<Expression>(result){
                    final /* synthetic */ ArrayVariable $result;

                    @NotNull
                    public final Expression invoke() {
                        return this.$result.set(1, (Expression)new TextExpression("streamResult"));
                    }
                    {
                        this.$result = arrayVariable;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = matchHandler;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public TerminatorStreamCall transformCall(@NotNull TerminatorStreamCall call2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        List<CallArgument> args = call2.getArguments();
        boolean bl2 = bl = args.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Only predicate should be specified";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        CallArgument predicate = (CallArgument)CollectionsKt.first(args);
        String newPredicateBody = Intrinsics.areEqual((Object)call2.getName(), (Object)"allMatch") ? "false" : "true";
        String newPredicate2 = Convertable.DefaultImpls.toCode$default(this.getDsl().lambda("x", (Function2<? super LambdaBody, ? super Expression, Unit>)((Function2)new Function2<LambdaBody, Expression, Unit>(newPredicateBody){
            final /* synthetic */ String $newPredicateBody;

            public final void invoke(@NotNull LambdaBody $receiver, @NotNull Expression it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                $receiver.doReturn(new TextExpression(this.$newPredicateBody));
            }
            {
                this.$newPredicateBody = string;
                super(2);
            }
        })), 0, 1, null);
        return this.transformArgs(call2, CollectionsKt.listOf((Object)new CallArgumentImpl(predicate.getType(), newPredicate2)));
    }

    @Override
    @NotNull
    public Expression getResultExpression() {
        return new TextExpression("result");
    }

    @Override
    @NotNull
    public List<IntermediateStreamCall> additionalCallsBefore() {
        ArrayList result = new ArrayList(this.myPeekHandler.additionalCallsBefore());
        String filterPredicate = Convertable.DefaultImpls.toCode$default(Intrinsics.areEqual((Object)this.call.getName(), (Object)"allMatch") ? this.myPredicateVariable.call("negate", new Expression[0]) : (Expression)this.myPredicateVariable, 0, 1, null);
        CallArgumentImpl filterArg = new CallArgumentImpl(this.myPredicateVariable.getType().getVariableTypeName(), filterPredicate);
        Collection collection = result;
        IntermediateStreamCallImpl intermediateStreamCallImpl = new IntermediateStreamCallImpl("filter", CollectionsKt.listOf((Object)filterArg), this.call.getTypeBefore(), this.call.getTypeBefore(), TextRange.EMPTY_RANGE);
        collection.add(intermediateStreamCallImpl);
        result.addAll(this.myPeekHandler.additionalCallsAfter());
        return result;
    }

    private final TerminatorStreamCall transformArgs(@NotNull TerminatorStreamCall $receiver, List<? extends CallArgument> args) {
        return new TerminatorStreamCallImpl($receiver.getName(), args, $receiver.getTypeBefore(), $receiver.getResultType(), $receiver.getTextRange());
    }

    public MatchHandler(@NotNull TerminatorStreamCall call2, @NotNull Dsl dsl) {
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)dsl, (String)"dsl");
        super(dsl);
        this.call = call2;
        GenericType genericType = this.call.getTypeBefore();
        Intrinsics.checkExpressionValueIsNotNull((Object)genericType, (String)"call.typeBefore");
        GenericType genericType2 = this.call.getTypeBefore();
        Intrinsics.checkExpressionValueIsNotNull((Object)genericType2, (String)"call.typeBefore");
        this.myPeekHandler = new PeekTraceHandler(0, "filterMatch", genericType, genericType2, dsl);
        String string = ((CallArgument)CollectionsKt.first(this.call.getArguments())).getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"call.arguments.first().type");
        this.myPredicateVariable = dsl.variable(new ClassTypeImpl(string, null, 2, null), Companion.getPREDICATE_NAME());
    }

    static {
        PREDICATE_NAME = PREDICATE_NAME;
    }

    @NotNull
    public static final /* synthetic */ PeekTraceHandler access$getMyPeekHandler$p(MatchHandler $this) {
        return $this.myPeekHandler;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/debugger/streams/trace/impl/handler/unified/MatchHandler$Companion;", "", "()V", "PREDICATE_NAME", "", "getPREDICATE_NAME", "()Ljava/lang/String;", "intellij.java.debugger.streams"})
    private static final class Companion {
        @NotNull
        public final String getPREDICATE_NAME() {
            return PREDICATE_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

