/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubAuthData;

@com.intellij.openapi.components.State(name="GithubSettings", storages={@Storage(value="github_settings.xml")})
public class GithubSettings
implements PersistentStateComponent<State> {
    private static final String GITHUB_SETTINGS_PASSWORD_KEY = "GITHUB_SETTINGS_PASSWORD_KEY";
    private State myState = new State();

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            GithubSettings.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    public static GithubSettings getInstance() {
        return (GithubSettings)ServiceManager.getService(GithubSettings.class);
    }

    public int getConnectionTimeout() {
        return this.myState.CONNECTION_TIMEOUT;
    }

    public void setConnectionTimeout(int timeout) {
        this.myState.CONNECTION_TIMEOUT = timeout;
    }

    @NotNull
    public String getHost() {
        String string = this.myState.HOST;
        if (string == null) {
            GithubSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getLogin() {
        return this.myState.LOGIN;
    }

    @NotNull
    public GithubAuthData.AuthType getAuthType() {
        GithubAuthData.AuthType authType = this.myState.AUTH_TYPE;
        if (authType == null) {
            GithubSettings.$$$reportNull$$$0(2);
        }
        return authType;
    }

    public boolean isAuthConfigured() {
        return !this.myState.AUTH_TYPE.equals((Object)GithubAuthData.AuthType.ANONYMOUS);
    }

    private void setHost(@NotNull String host) {
        if (host == null) {
            GithubSettings.$$$reportNull$$$0(3);
        }
        this.myState.HOST = StringUtil.notNullize((String)host, (String)"github.com");
    }

    private void setLogin(@Nullable String login) {
        this.myState.LOGIN = login;
    }

    private void setAuthType(@NotNull GithubAuthData.AuthType authType) {
        if (authType == null) {
            GithubSettings.$$$reportNull$$$0(4);
        }
        this.myState.AUTH_TYPE = authType;
    }

    public boolean isAnonymousGist() {
        return this.myState.ANONYMOUS_GIST;
    }

    public boolean isOpenInBrowserGist() {
        return this.myState.OPEN_IN_BROWSER_GIST;
    }

    public boolean isPrivateGist() {
        return this.myState.PRIVATE_GIST;
    }

    public boolean isSavePassword() {
        return this.myState.SAVE_PASSWORD;
    }

    public boolean isValidGitAuth() {
        return this.myState.VALID_GIT_AUTH;
    }

    public boolean isSavePasswordMakesSense() {
        return !PasswordSafe.getInstance().isMemoryOnly();
    }

    public boolean isCloneGitUsingSsh() {
        return this.myState.CLONE_GIT_USING_SSH;
    }

    @NotNull
    public ThreeState getCreatePullRequestCreateRemote() {
        ThreeState threeState = this.myState.CREATE_PULL_REQUEST_CREATE_REMOTE;
        if (threeState == null) {
            GithubSettings.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    public void setCreatePullRequestCreateRemote(@NotNull ThreeState value) {
        if (value == null) {
            GithubSettings.$$$reportNull$$$0(6);
        }
        this.myState.CREATE_PULL_REQUEST_CREATE_REMOTE = value;
    }

    public void setAnonymousGist(boolean anonymousGist) {
        this.myState.ANONYMOUS_GIST = anonymousGist;
    }

    public void setPrivateGist(boolean secretGist) {
        this.myState.PRIVATE_GIST = secretGist;
    }

    public void setSavePassword(boolean savePassword) {
        this.myState.SAVE_PASSWORD = savePassword;
    }

    public void setValidGitAuth(boolean validGitAuth) {
        this.myState.VALID_GIT_AUTH = validGitAuth;
    }

    public void setOpenInBrowserGist(boolean openInBrowserGist) {
        this.myState.OPEN_IN_BROWSER_GIST = openInBrowserGist;
    }

    public void setCloneGitUsingSsh(boolean value) {
        this.myState.CLONE_GIT_USING_SSH = value;
    }

    @NotNull
    private String getPassword() {
        String string = StringUtil.notNullize((String)PasswordSafe.getInstance().getPassword(GithubSettings.class, GITHUB_SETTINGS_PASSWORD_KEY));
        if (string == null) {
            GithubSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void setPassword(@NotNull String password, boolean rememberPassword) {
        if (password == null) {
            GithubSettings.$$$reportNull$$$0(8);
        }
        if (!rememberPassword) {
            return;
        }
        PasswordSafe.getInstance().setPassword(GithubSettings.class, GITHUB_SETTINGS_PASSWORD_KEY, password);
    }

    private static boolean isValidGitAuth(@NotNull GithubAuthData auth) {
        if (auth == null) {
            GithubSettings.$$$reportNull$$$0(9);
        }
        switch (auth.getAuthType()) {
            case BASIC: {
                assert (auth.getBasicAuth() != null);
                return auth.getBasicAuth().getCode() == null;
            }
            case TOKEN: {
                return true;
            }
            case ANONYMOUS: {
                return false;
            }
        }
        throw new IllegalStateException("GithubSettings: setAuthData - wrong AuthType: " + (Object)((Object)auth.getAuthType()));
    }

    @NotNull
    public GithubAuthData getAuthData() {
        switch (this.getAuthType()) {
            case BASIC: {
                GithubAuthData githubAuthData = GithubAuthData.createBasicAuth(this.getHost(), this.getLogin(), this.getPassword());
                if (githubAuthData == null) {
                    GithubSettings.$$$reportNull$$$0(10);
                }
                return githubAuthData;
            }
            case TOKEN: {
                GithubAuthData githubAuthData = GithubAuthData.createTokenAuth(this.getHost(), this.getPassword());
                if (githubAuthData == null) {
                    GithubSettings.$$$reportNull$$$0(11);
                }
                return githubAuthData;
            }
            case ANONYMOUS: {
                GithubAuthData githubAuthData = GithubAuthData.createAnonymous(this.getHost());
                if (githubAuthData == null) {
                    GithubSettings.$$$reportNull$$$0(12);
                }
                return githubAuthData;
            }
        }
        throw new IllegalStateException("GithubSettings: getAuthData - wrong AuthType: " + (Object)((Object)this.getAuthType()));
    }

    public void setAuthData(@NotNull GithubAuthData auth, boolean rememberPassword) {
        if (auth == null) {
            GithubSettings.$$$reportNull$$$0(13);
        }
        this.setValidGitAuth(GithubSettings.isValidGitAuth(auth));
        this.setAuthType(auth.getAuthType());
        this.setHost(auth.getHost());
        switch (auth.getAuthType()) {
            case BASIC: {
                assert (auth.getBasicAuth() != null);
                this.setLogin(auth.getBasicAuth().getLogin());
                this.setPassword(auth.getBasicAuth().getPassword(), rememberPassword);
                break;
            }
            case TOKEN: {
                assert (auth.getTokenAuth() != null);
                this.setLogin(null);
                this.setPassword(auth.getTokenAuth().getToken(), rememberPassword);
                break;
            }
            case ANONYMOUS: {
                this.setLogin(null);
                this.setPassword("", rememberPassword);
                break;
            }
            default: {
                throw new IllegalStateException("GithubSettings: setAuthData - wrong AuthType: " + (Object)((Object)auth.getAuthType()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/util/GithubSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auth";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/util/GithubSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreatePullRequestCreateRemote";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassword";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setHost";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAuthType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCreatePullRequestCreateRemote";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setPassword";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValidGitAuth";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setAuthData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        @Nullable
        public String LOGIN = null;
        @NotNull
        public String HOST = "github.com";
        @NotNull
        public GithubAuthData.AuthType AUTH_TYPE = GithubAuthData.AuthType.ANONYMOUS;
        public boolean ANONYMOUS_GIST = false;
        public boolean OPEN_IN_BROWSER_GIST = true;
        public boolean PRIVATE_GIST = true;
        public boolean SAVE_PASSWORD = true;
        public int CONNECTION_TIMEOUT = 5000;
        public boolean VALID_GIT_AUTH = true;
        public ThreeState CREATE_PULL_REQUEST_CREATE_REMOTE = ThreeState.UNSURE;
        public boolean CLONE_GIT_USING_SSH = false;
    }
}

