/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.Convertor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;

public class FileStatusResultParser {
    @NotNull
    private Pattern myLinePattern;
    @Nullable
    private ProgressTracker handler;
    @NotNull
    private Convertor<Matcher, ProgressEvent> myConvertor;

    public FileStatusResultParser(@NotNull Pattern linePattern, @Nullable ProgressTracker handler, @NotNull Convertor<Matcher, ProgressEvent> convertor) {
        if (linePattern == null) {
            FileStatusResultParser.$$$reportNull$$$0(0);
        }
        if (convertor == null) {
            FileStatusResultParser.$$$reportNull$$$0(1);
        }
        this.myLinePattern = linePattern;
        this.handler = handler;
        this.myConvertor = convertor;
    }

    public void parse(@NotNull String output) throws VcsException {
        if (output == null) {
            FileStatusResultParser.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)output)) {
            return;
        }
        for (String line : StringUtil.splitByLines((String)output)) {
            this.onLine(line);
        }
    }

    public void onLine(@NotNull String line) throws VcsException {
        Matcher matcher;
        if (line == null) {
            FileStatusResultParser.$$$reportNull$$$0(3);
        }
        if (!(matcher = this.myLinePattern.matcher(line)).matches()) {
            throw new VcsException("unknown state on line " + line);
        }
        this.process(matcher);
    }

    public void process(@NotNull Matcher matcher) throws VcsException {
        if (matcher == null) {
            FileStatusResultParser.$$$reportNull$$$0(4);
        }
        if (this.handler != null) {
            this.handler.consume(this.myConvertor.convert((Object)matcher));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linePattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/api/FileStatusResultParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

