/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.util.Ref;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfiguration;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class UrlSerializationHelper {
    private final SvnVcs myVcs;

    public UrlSerializationHelper(SvnVcs vcs) {
        this.myVcs = vcs;
    }

    public SvnBranchConfiguration prepareForSerialization(SvnBranchConfiguration configuration) {
        Ref withUserInfo = new Ref();
        String trunkUrl = UrlSerializationHelper.serializeUrl(configuration.getTrunkUrl(), (Ref<Boolean>)withUserInfo);
        if (Boolean.FALSE.equals(withUserInfo.get())) {
            return configuration;
        }
        List<String> branches = configuration.getBranchUrls();
        ArrayList<String> newBranchesList = new ArrayList<String>(branches.size());
        for (String s : branches) {
            newBranchesList.add(UrlSerializationHelper.serializeUrl(s, (Ref<Boolean>)withUserInfo));
        }
        return new SvnBranchConfiguration(trunkUrl, newBranchesList, withUserInfo.isNull() ? false : (Boolean)withUserInfo.get());
    }

    public SvnBranchConfiguration afterDeserialization(String path, SvnBranchConfiguration configuration) {
        if (!configuration.isUserinfoInUrl()) {
            return configuration;
        }
        String userInfo = this.getUserInfo(path);
        if (userInfo == null) {
            return configuration;
        }
        String newTrunkUrl = UrlSerializationHelper.deserializeUrl(configuration.getTrunkUrl(), userInfo);
        List<String> branches = configuration.getBranchUrls();
        ArrayList<String> newBranchesList = new ArrayList<String>(branches.size());
        for (String s : branches) {
            newBranchesList.add(UrlSerializationHelper.deserializeUrl(s, userInfo));
        }
        return new SvnBranchConfiguration(newTrunkUrl, newBranchesList, userInfo.length() > 0);
    }

    private static String serializeUrl(String url, Ref<Boolean> withUserInfo) {
        if (Boolean.FALSE.equals(withUserInfo.get())) {
            return url;
        }
        try {
            Url svnurl = SvnUtil.createUrl(url);
            if (withUserInfo.isNull()) {
                String userInfo = svnurl.getUserInfo();
                withUserInfo.set((Object)(userInfo != null && userInfo.length() > 0 ? 1 : 0));
            }
            if (((Boolean)withUserInfo.get()).booleanValue()) {
                return svnurl.setUserInfo(null).toString();
            }
        }
        catch (SvnBindException svnBindException) {
            // empty catch block
        }
        return url;
    }

    @Nullable
    private String getUserInfo(String path) {
        Url svnurl = this.myVcs.getSvnFileUrlMapping().getUrlForFile(new File(path));
        return svnurl != null ? svnurl.getUserInfo() : null;
    }

    private static String deserializeUrl(String url, String userInfo) {
        try {
            Url svnurl = SvnUtil.createUrl(url);
            return svnurl.setUserInfo(userInfo).toString();
        }
        catch (SvnBindException e) {
            return url;
        }
    }
}

