/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopiesContent;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.ChangeFormatDialog;
import org.jetbrains.idea.svn.dialogs.SvnFormatWorker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.QuickMergeInteractionImpl;

public class CopiesPanel {
    private static final Logger LOG = Logger.getInstance(CopiesPanel.class);
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Svn Roots Detection Errors", NotificationDisplayType.STICKY_BALLOON, true);
    private final Project myProject;
    private MessageBusConnection myConnection;
    private SvnVcs myVcs;
    private JPanel myPanel;
    private JComponent myHolder;
    private LinkLabel myRefreshLabel;
    private List<OverrideEqualsWrapper<WCInfo>> myCurrentInfoList;
    private int myTextHeight;
    private static final String CHANGE_FORMAT = "CHANGE_FORMAT";
    private static final String CLEANUP = "CLEANUP";
    private static final String FIX_DEPTH = "FIX_DEPTH";
    private static final String CONFIGURE_BRANCHES = "CONFIGURE_BRANCHES";
    private static final String MERGE_FROM = "MERGE_FROM";

    public CopiesPanel(Project project) {
        this.myProject = project;
        this.myConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        this.myVcs = SvnVcs.getInstance(this.myProject);
        this.myCurrentInfoList = null;
        Runnable focus = () -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myRefreshLabel, true);
        Runnable refreshView = () -> {
            List<WCInfo> infoList = this.myVcs.getWcInfosWithErrors();
            boolean hasErrors = !this.myVcs.getSvnFileUrlMapping().getErrorRoots().isEmpty();
            List<WorkingCopyFormat> supportedFormats = this.getSupportedFormats();
            Runnable runnable = () -> {
                if (this.myCurrentInfoList != null) {
                    List newList = ContainerUtil.map((Collection)infoList, info -> new OverrideEqualsWrapper<WCInfo>(InfoEqualityPolicy.getInstance(), (WCInfo)info));
                    if (Comparing.haveEqualElements((Collection)newList, this.myCurrentInfoList)) {
                        this.myRefreshLabel.setEnabled(true);
                        return;
                    }
                    this.myCurrentInfoList = newList;
                }
                Collections.sort(infoList, WCComparator.getInstance());
                this.updateList(infoList, supportedFormats);
                this.myRefreshLabel.setEnabled(true);
                this.showErrorNotification(hasErrors);
                SwingUtilities.invokeLater(focus);
            };
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
        };
        Consumer refreshOnPooled = somethingNew -> {
            if (Boolean.TRUE.equals(somethingNew)) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    refreshView.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(refreshView);
                }
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.myRefreshLabel.setEnabled(true), ModalityState.NON_MODAL);
            }
        };
        this.myConnection.subscribe(SvnVcs.ROOTS_RELOADED, (Object)refreshOnPooled);
        JPanel holderPanel = new JPanel(new BorderLayout());
        FontMetrics fm = holderPanel.getFontMetrics(holderPanel.getFont());
        this.myTextHeight = (int)((double)fm.getHeight() * 1.3);
        this.myPanel = new JPanel(new GridBagLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myPanel, "North");
        holderPanel.add((Component)panel, "West");
        this.myRefreshLabel = new MyLinkLabel(this.myTextHeight, "Refresh", (aSource, aLinkData) -> {
            if (this.myRefreshLabel.isEnabled()) {
                this.myVcs.invokeRefreshSvnRoots();
                this.myRefreshLabel.setEnabled(false);
            }
        });
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)holderPanel);
        CopiesPanel.registerHelp(pane);
        this.myHolder = pane;
        this.myHolder.setBorder(null);
        this.setFocusableForLinks(this.myRefreshLabel);
        refreshOnPooled.consume((Object)true);
        this.initView();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRefreshLabel;
    }

    private void updateList(@NotNull List<WCInfo> infoList, @NotNull List<WorkingCopyFormat> supportedFormats) {
        if (infoList == null) {
            CopiesPanel.$$$reportNull$$$0(0);
        }
        if (supportedFormats == null) {
            CopiesPanel.$$$reportNull$$$0(1);
        }
        this.myPanel.removeAll();
        Insets nullIndent = new Insets(1, 3, 1, 0);
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 0, 0), 0, 0);
        gb.insets.left = 4;
        this.myPanel.add((Component)this.myRefreshLabel, gb);
        gb.insets.left = 1;
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        Insets topIndent = new Insets(10, 3, 0, 0);
        for (final WCInfo wcInfo : infoList) {
            final Set<WorkingCopyFormat> upgradeFormats = CopiesPanel.getUpgradeFormats(wcInfo, supportedFormats);
            VirtualFile vf = lfs.refreshAndFindFileByIoFile(new File(wcInfo.getPath()));
            final VirtualFile root = vf == null ? wcInfo.getVcsRoot() : vf;
            final JEditorPane editorPane = new JEditorPane("text/html", "");
            editorPane.setEditable(false);
            editorPane.setFocusable(true);
            editorPane.setBackground(UIUtil.getPanelBackground());
            editorPane.setOpaque(false);
            editorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (CopiesPanel.CONFIGURE_BRANCHES.equals(e.getDescription())) {
                            if (!this.checkRoot(root, wcInfo.getPath(), " invoke Configure Branches")) {
                                return;
                            }
                            BranchConfigurationDialog.configureBranches(CopiesPanel.this.myProject, root);
                        } else if (CopiesPanel.FIX_DEPTH.equals(e.getDescription())) {
                            int result = Messages.showOkCancelDialog((Project)CopiesPanel.this.myVcs.getProject(), (String)("You are going to checkout into '" + wcInfo.getPath() + "' with 'infinity' depth.\nThis will update your working copy to HEAD revision as well."), (String)"Set Working Copy Infinity Depth", (Icon)Messages.getWarningIcon());
                            if (result == 0) {
                                SvnCheckoutProvider.checkout(CopiesPanel.this.myVcs.getProject(), new File(wcInfo.getPath()), wcInfo.getUrl(), Revision.HEAD, Depth.INFINITY, false, null, wcInfo.getFormat());
                            }
                        } else if (CopiesPanel.CHANGE_FORMAT.equals(e.getDescription())) {
                            CopiesPanel.this.changeFormat(wcInfo, upgradeFormats);
                        } else if (CopiesPanel.MERGE_FROM.equals(e.getDescription())) {
                            if (!this.checkRoot(root, wcInfo.getPath(), " invoke Merge From")) {
                                return;
                            }
                            CopiesPanel.this.mergeFrom(wcInfo, root, editorPane);
                        } else if (CopiesPanel.CLEANUP.equals(e.getDescription())) {
                            if (!this.checkRoot(root, wcInfo.getPath(), " invoke Cleanup")) {
                                return;
                            }
                            new CleanupWorker(CopiesPanel.this.myVcs, Collections.singletonList(root)).execute();
                        }
                    }
                }

                private boolean checkRoot(VirtualFile root2, String path, String actionName) {
                    if (root2 == null) {
                        Messages.showWarningDialog((Project)CopiesPanel.this.myProject, (String)("Invalid working copy root: " + path), (String)("Can not " + actionName));
                        return false;
                    }
                    return true;
                }
            });
            editorPane.setBorder(null);
            editorPane.setText(this.formatWc(wcInfo, upgradeFormats));
            JPanel copyPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gb1 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, nullIndent, 0, 0);
            gb1.insets.top = 1;
            gb1.gridwidth = 3;
            gb.insets = topIndent;
            gb.fill = 2;
            ++gb.gridy;
            JPanel contForCopy = new JPanel(new BorderLayout());
            contForCopy.add((Component)copyPanel, "West");
            this.myPanel.add((Component)contForCopy, gb);
            copyPanel.add((Component)editorPane, gb1);
            gb1.insets = nullIndent;
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    private String formatWc(@NotNull WCInfo info, @NotNull Collection<WorkingCopyFormat> upgradeFormats) {
        if (info == null) {
            CopiesPanel.$$$reportNull$$$0(2);
        }
        if (upgradeFormats == null) {
            CopiesPanel.$$$reportNull$$$0(3);
        }
        StringBuilder sb = new StringBuilder().append("<html><head>").append(UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont())).append("</head><body><table bgColor=\"").append(ColorUtil.toHex((Color)UIUtil.getPanelBackground())).append("\">");
        sb.append("<tr valign=\"top\"><td colspan=\"3\"><b>").append(info.getPath()).append("</b></td></tr>");
        if (info.hasError()) {
            sb.append("<tr valign=\"top\"><td>URL:</td><td colspan=\"2\" color=\"").append(ColorUtil.toHex((Color)JBColor.red)).append("\">").append(info.getErrorMessage()).append("</td></tr>");
        } else {
            sb.append("<tr valign=\"top\"><td>URL:</td><td colspan=\"2\">").append(info.getUrl().toDecodedString()).append("</td></tr>");
        }
        if (upgradeFormats.size() > 1) {
            sb.append("<tr valign=\"top\"><td>Format:</td><td>").append(info.getFormat().getName()).append("</td><td><a href=\"").append(CHANGE_FORMAT).append("\">Change</a></td></tr>");
        } else {
            sb.append("<tr valign=\"top\"><td>Format:</td><td colspan=\"2\">").append(info.getFormat().getName()).append("</td></tr>");
        }
        if (!Depth.INFINITY.equals((Object)info.getStickyDepth()) && !info.hasError()) {
            sb.append("<tr valign=\"top\"><td>Depth:</td><td>").append(info.getStickyDepth().getName()).append("</td><td><a href=\"").append(FIX_DEPTH).append("\">Fix</a></td></tr>");
        } else {
            sb.append("<tr valign=\"top\"><td>Depth:</td><td colspan=\"2\">").append(info.getStickyDepth().getName()).append("</td></tr>");
        }
        NestedCopyType type = info.getType();
        if (NestedCopyType.external.equals((Object)type) || NestedCopyType.switched.equals((Object)type)) {
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><i>").append(type.getName()).append("</i></td></tr>");
        }
        if (info.isIsWcRoot()) {
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><i>").append("Working copy root</i></td></tr>");
        }
        if (!info.hasError()) {
            if (info.getFormat().isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN)) {
                sb.append("<tr valign=\"top\"><td colspan=\"3\"><a href=\"").append(CLEANUP).append("\">Cleanup</a></td></tr>");
            }
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><a href=\"").append(CONFIGURE_BRANCHES).append("\">Configure Branches</a></td></tr>");
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><a href=\"").append(MERGE_FROM).append("\"><b>Merge From...</b></a></i></td></tr>");
            sb.append("</table></body></html>");
        }
        return sb.toString();
    }

    @NotNull
    private List<WorkingCopyFormat> getSupportedFormats() {
        ArrayList result = ContainerUtil.newArrayList();
        ClientFactory factory = this.myVcs.getFactory();
        try {
            result.addAll(factory.createUpgradeClient().getSupportedFormats());
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            CopiesPanel.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static Set<WorkingCopyFormat> getUpgradeFormats(@NotNull WCInfo info, @NotNull List<WorkingCopyFormat> supportedFormats) {
        if (info == null) {
            CopiesPanel.$$$reportNull$$$0(5);
        }
        if (supportedFormats == null) {
            CopiesPanel.$$$reportNull$$$0(6);
        }
        EnumSet<WorkingCopyFormat> canUpgradeTo = EnumSet.noneOf(WorkingCopyFormat.class);
        for (WorkingCopyFormat format : supportedFormats) {
            if (!format.isOrGreater(info.getFormat())) continue;
            canUpgradeTo.add(format);
        }
        canUpgradeTo.add(info.getFormat());
        return canUpgradeTo;
    }

    private void mergeFrom(@NotNull WCInfo wcInfo, @NotNull VirtualFile root, @Nullable Component mergeLabel) {
        if (wcInfo == null) {
            CopiesPanel.$$$reportNull$$$0(7);
        }
        if (root == null) {
            CopiesPanel.$$$reportNull$$$0(8);
        }
        SelectBranchPopup.showForBranchRoot(this.myProject, root, (project, configuration, branchUrl, revision) -> {
            if (wcInfo == null) {
                CopiesPanel.$$$reportNull$$$0(16);
            }
            if (root == null) {
                CopiesPanel.$$$reportNull$$$0(17);
            }
            try {
                Url workingCopyUrlInSelectedBranch = CopiesPanel.getCorrespondingUrlInOtherBranch(configuration, wcInfo.getUrl(), branchUrl);
                MergeContext mergeContext = new MergeContext(this.myVcs, workingCopyUrlInSelectedBranch, wcInfo, Url.tail(branchUrl), root);
                new QuickMerge(mergeContext, new QuickMergeInteractionImpl(mergeContext)).execute();
            }
            catch (SvnBindException e) {
                AbstractVcsHelper.getInstance((Project)this.myProject).showError((VcsException)e, "Merge from " + Url.tail(branchUrl));
            }
        }, "Select branch", mergeLabel);
    }

    @NotNull
    private static Url getCorrespondingUrlInOtherBranch(@NotNull SvnBranchConfigurationNew configuration, @NotNull Url url, @NotNull String otherBranchUrl) throws SvnBindException {
        if (configuration == null) {
            CopiesPanel.$$$reportNull$$$0(9);
        }
        if (url == null) {
            CopiesPanel.$$$reportNull$$$0(10);
        }
        if (otherBranchUrl == null) {
            CopiesPanel.$$$reportNull$$$0(11);
        }
        Url url2 = SvnUtil.append(SvnUtil.createUrl(otherBranchUrl), StringUtil.notNullize((String)configuration.getRelativeUrl(url.toDecodedString())));
        if (url2 == null) {
            CopiesPanel.$$$reportNull$$$0(12);
        }
        return url2;
    }

    private void setFocusableForLinks(final LinkLabel label) {
        DottedBorder border = new DottedBorder(new Insets(1, 2, 1, 1), (Color)JBColor.BLACK);
        label.setFocusable(true);
        label.addFocusListener((FocusListener)new FocusAdapter((Border)border){
            final /* synthetic */ Border val$border;
            {
                this.val$border = border;
            }

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                label.setBorder(this.val$border);
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                label.setBorder(null);
            }
        });
        label.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    label.doClick();
                }
            }
        });
    }

    private void changeFormat(@NotNull WCInfo wcInfo, @NotNull Collection<WorkingCopyFormat> supportedFormats) {
        if (wcInfo == null) {
            CopiesPanel.$$$reportNull$$$0(13);
        }
        if (supportedFormats == null) {
            CopiesPanel.$$$reportNull$$$0(14);
        }
        ChangeFormatDialog dialog = new ChangeFormatDialog(this.myProject, new File(wcInfo.getPath()), false, !wcInfo.isIsWcRoot());
        dialog.setSupported(supportedFormats);
        dialog.setData(wcInfo.getFormat());
        if (!dialog.showAndGet()) {
            return;
        }
        WorkingCopyFormat newFormat = dialog.getUpgradeMode();
        if (!wcInfo.getFormat().equals((Object)newFormat)) {
            ApplicationManager.getApplication().saveAll();
            SvnFormatWorker task = new SvnFormatWorker(this.myProject, newFormat, wcInfo){

                @Override
                public void onSuccess() {
                    super.onSuccess();
                    CopiesPanel.this.myRefreshLabel.doClick();
                }
            };
            ProgressManager.getInstance().run((Task)task);
        }
    }

    private void initView() {
        this.myRefreshLabel.doClick();
    }

    private void showErrorNotification(boolean hasErrors) {
        NotificationsManager manager = NotificationsManager.getNotificationsManager();
        ErrorsFoundNotification[] notifications = (ErrorsFoundNotification[])manager.getNotificationsOfType(ErrorsFoundNotification.class, this.myProject);
        if (hasErrors) {
            if (notifications.length == 0) {
                new ErrorsFoundNotification(this.myProject).notify(this.myProject.isDefault() ? null : this.myProject);
            }
        } else {
            for (ErrorsFoundNotification notification : notifications) {
                notification.expire();
            }
        }
    }

    private static void registerHelp(@NotNull JComponent component) {
        if (component == null) {
            CopiesPanel.$$$reportNull$$$0(15);
        }
        DataManager.registerDataProvider((JComponent)component, dataId -> {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "reference.vcs.svn.working.copies.information";
            }
            return null;
        });
    }

    public JComponent getComponent() {
        return this.myHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoList";
                break;
            }
            case 1: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedFormats";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upgradeFormats";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/CopiesPanel";
                break;
            }
            case 7: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wcInfo";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBranchUrl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/CopiesPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFormats";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingUrlInOtherBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatWc";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUpgradeFormats";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeFrom";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingUrlInOtherBranch";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "changeFormat";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerHelp";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mergeFrom$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ErrorsFoundNotification
    extends Notification {
        private static final String FIX_ACTION = "FIX";
        private static final String TITLE = "";
        private static final String DESCRIPTION = SvnBundle.message("subversion.roots.detection.errors.found.description", new Object[0]);

        private ErrorsFoundNotification(@NotNull Project project) {
            if (project == null) {
                ErrorsFoundNotification.$$$reportNull$$$0(0);
            }
            super(NOTIFICATION_GROUP.getDisplayId(), TITLE, DESCRIPTION, NotificationType.ERROR, (NotificationListener)ErrorsFoundNotification.createListener(project));
        }

        private static NotificationListener.Adapter createListener(final @NotNull Project project) {
            if (project == null) {
                ErrorsFoundNotification.$$$reportNull$$$0(1);
            }
            return new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (ErrorsFoundNotification.FIX_ACTION.equals(event.getDescription())) {
                        WorkingCopiesContent.show(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/svn/dialogs/CopiesPanel$ErrorsFoundNotification$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "org/jetbrains/idea/svn/dialogs/CopiesPanel$ErrorsFoundNotification";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyLinkLabel
    extends LinkLabel {
        private final int myHeight;

        public MyLinkLabel(int height, String text, LinkListener linkListener) {
            super(text, null, linkListener);
            this.myHeight = height;
        }

        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            return new Dimension(preferredSize.width, this.myHeight);
        }
    }

    private static class WCComparator
    implements Comparator<WCInfo> {
        private static final WCComparator ourComparator = new WCComparator();

        private WCComparator() {
        }

        public static WCComparator getInstance() {
            return ourComparator;
        }

        @Override
        public int compare(WCInfo o1, WCInfo o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }

    private static class InfoEqualityPolicy
    implements EqualityPolicy<WCInfo> {
        private static final InfoEqualityPolicy ourInstance = new InfoEqualityPolicy();

        private InfoEqualityPolicy() {
        }

        public static InfoEqualityPolicy getInstance() {
            return ourInstance;
        }

        public int getHashCode(WCInfo value) {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append(value.getPath());
            builder.append(value.getUrl());
            builder.append((Object)value.getFormat());
            builder.append((Object)value.getType());
            builder.append((Object)value.getStickyDepth());
            return builder.getCode();
        }

        public boolean isEqual(WCInfo val1, WCInfo val2) {
            if (val1 == val2) {
                return true;
            }
            if (val1 == null || val2 == null || val1.getClass() != val2.getClass()) {
                return false;
            }
            if (!Comparing.equal((Object)((Object)val1.getFormat()), (Object)((Object)val2.getFormat()))) {
                return false;
            }
            if (!Comparing.equal((String)val1.getPath(), (String)val2.getPath())) {
                return false;
            }
            if (!Comparing.equal((Object)((Object)val1.getStickyDepth()), (Object)((Object)val2.getStickyDepth()))) {
                return false;
            }
            if (!Comparing.equal((Object)((Object)val1.getType()), (Object)((Object)val2.getType()))) {
                return false;
            }
            return Comparing.equal((Object)val1.getUrl(), (Object)val2.getUrl());
        }

        private static class HashCodeBuilder {
            private int myCode = 0;

            private HashCodeBuilder() {
            }

            public void append(Object o) {
                this.myCode = 31 * this.myCode + (o != null ? o.hashCode() : 0);
            }

            public int getCode() {
                return this.myCode;
            }
        }
    }

    public static class OverrideEqualsWrapper<T> {
        private final EqualityPolicy<T> myPolicy;
        private final T myT;

        public OverrideEqualsWrapper(EqualityPolicy<T> policy, T t) {
            this.myPolicy = policy;
            this.myT = t;
        }

        public T getT() {
            return this.myT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OverrideEqualsWrapper that = (OverrideEqualsWrapper)o;
            return this.myPolicy.isEqual(this.myT, that.getT());
        }

        public int hashCode() {
            return this.myPolicy.getHashCode(this.myT);
        }
    }
}

