/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import icons.XpathIcons;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPath2ElementTypes;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunction;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.PrefixReferenceImpl;
import org.intellij.lang.xpath.psi.impl.PrefixedNameImpl;
import org.intellij.lang.xpath.psi.impl.ReferenceBase;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathFunctionCallImpl
extends XPathElementImpl
implements XPathFunctionCall {
    public XPathFunctionCallImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public XPathExpression[] getArgumentList() {
        ASTNode[] nodes = this.getNode().getChildren(XPath2ElementTypes.EXPRESSIONS);
        XPathExpression[] expressions = new XPathExpression[nodes.length];
        for (int i = 0; i < expressions.length; ++i) {
            expressions[i] = (XPathExpression)nodes[i].getPsi();
        }
        if (expressions == null) {
            XPathFunctionCallImpl.$$$reportNull$$$0(0);
        }
        return expressions;
    }

    @Override
    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        ASTNode paren;
        if (psiElement == null) {
            XPathFunctionCallImpl.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof XPathExpression && this.getNode().getChildren(XPath2ElementTypes.EXPRESSIONS).length > 0) {
            XPathExpression child = XPathChangeUtil.createExpression(this, "f(a,b)");
            ASTNode comma = child.getNode().findChildByType(XPathTokenTypes.COMMA);
            assert (comma != null);
            PsiElement psi = comma.getPsi();
            assert (psi != null);
            this.add(psi);
        }
        if ((paren = this.getNode().findChildByType(XPathTokenTypes.RPAREN)) != null) {
            return super.addBefore(psiElement, paren.getPsi());
        }
        return super.add(psiElement);
    }

    @Override
    @NotNull
    public String getFunctionName() {
        String name;
        ASTNode node = this.getNameNode();
        String string = name = node != null ? node.getText() : null;
        assert (name != null) : this.unexpectedPsiAssertion();
        String string2 = name;
        if (string2 == null) {
            XPathFunctionCallImpl.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Nullable
    protected ASTNode getNameNode() {
        return this.getNode().findChildByType(XPathTokenTypes.FUNCTION_NAME);
    }

    @Nullable
    protected ASTNode getPrefixNode() {
        return this.getNode().findChildByType(XPathTokenTypes.EXT_PREFIX);
    }

    @Override
    @NotNull
    public PrefixedName getQName() {
        ASTNode node = this.getNameNode();
        assert (node != null) : this.unexpectedPsiAssertion();
        PrefixedNameImpl prefixedNameImpl = new PrefixedNameImpl(this.getPrefixNode(), node);
        if (prefixedNameImpl == null) {
            XPathFunctionCallImpl.$$$reportNull$$$0(3);
        }
        return prefixedNameImpl;
    }

    @Override
    @Nullable
    public XPathFunction resolve() {
        Reference reference = this.getReference();
        return reference != null ? reference.resolve() : null;
    }

    @Nullable
    public Reference getReference() {
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            return new Reference(nameNode);
        }
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        if (this.getPrefixNode() != null && this.getNameNode() != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{this.getReference(), new PrefixReferenceImpl(this, this.getPrefixNode())};
            if (psiReferenceArray == null) {
                XPathFunctionCallImpl.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = super.getReferences();
        if (psiReferenceArray == null) {
            XPathFunctionCallImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathFunction f = this.resolve();
        if (f == null) {
            XPathType xPathType = XPathType.UNKNOWN;
            if (xPathType == null) {
                XPathFunctionCallImpl.$$$reportNull$$$0(6);
            }
            return xPathType;
        }
        Function function = f.getDeclaration();
        XPathType xPathType = function != null ? function.getReturnType() : XPathType.UNKNOWN;
        if (xPathType == null) {
            XPathFunctionCallImpl.$$$reportNull$$$0(7);
        }
        return xPathType;
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathFunctionCall(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/psi/impl/XPathFunctionCallImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/psi/impl/XPathFunctionCallImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class Reference
    extends ReferenceBase {
        private volatile Pair<String, XPathFunction> myFunction;

        public Reference(ASTNode node) {
            super(XPathFunctionCallImpl.this, node);
        }

        @Override
        @Nullable
        public XPathFunction resolve() {
            if (this.myFunction != null && ((String)this.myFunction.first).equals(XPathFunctionCallImpl.this.getQName().toString())) {
                return (XPathFunction)this.myFunction.second;
            }
            XPathFunctionCallImpl call = XPathFunctionCallImpl.this;
            ContextProvider contextProvider = call.getXPathContext();
            QName name = contextProvider.getQName(call);
            if (name == null) {
                return null;
            }
            Function functionDecl = contextProvider.getFunctionContext().resolve(name, XPathFunctionCallImpl.this.getArgumentList().length);
            XPathFunction impl = functionDecl == null ? null : (functionDecl instanceof XPathFunction ? (XPathFunction)((Object)functionDecl) : new FunctionImpl(functionDecl));
            this.myFunction = Pair.create((Object)XPathFunctionCallImpl.this.getQName().toString(), (Object)impl);
            return (XPathFunction)this.myFunction.second;
        }

        @Override
        @NotNull
        public Object[] getVariants() {
            if (EMPTY_ARRAY == null) {
                Reference.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }

        @Override
        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            XPathFunctionCall child = (XPathFunctionCall)XPathChangeUtil.createExpression(this.getElement(), newElementName + "()");
            PrefixedNameImpl newName = (PrefixedNameImpl)child.getQName();
            PrefixedNameImpl oldName = (PrefixedNameImpl)XPathFunctionCallImpl.this.getQName();
            ASTNode localNode = newName.getLocalNode();
            XPathFunctionCallImpl.this.getNode().replaceChild(oldName.getLocalNode(), localNode);
            PsiElement psi = XPathFunctionCallImpl.this.getNode().getPsi();
            assert (psi != null);
            return psi;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathFunctionCallImpl$Reference", "getVariants"));
        }

        class FunctionImpl
        extends LightElement
        implements XPathFunction,
        ItemPresentation,
        NavigationItem {
            private final Function myFunctionDecl;

            public FunctionImpl(Function functionDecl) {
                super(Reference.this.getElement().getManager(), Reference.this.getElement().getContainingFile().getLanguage());
                this.myFunctionDecl = functionDecl;
            }

            public PsiElement getContext() {
                return XPathFunctionCallImpl.this;
            }

            public String getName() {
                return this.myFunctionDecl != null ? this.myFunctionDecl.getName() : XPathFunctionCallImpl.this.getFunctionName();
            }

            public String toString() {
                return "Function: " + this.getName();
            }

            public String getText() {
                return this.getName();
            }

            public ItemPresentation getPresentation() {
                return this;
            }

            @Nullable
            public Icon getIcon(boolean open) {
                return this.getIcon(0);
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public String getPresentableText() {
                return this.myFunctionDecl != null ? this.myFunctionDecl.buildSignature() + ": " + this.myFunctionDecl.getReturnType().getName() : null;
            }

            public Icon getIcon(int i) {
                return XpathIcons.Function;
            }

            public PsiElement copy() {
                return this;
            }

            public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
                if (name == null) {
                    FunctionImpl.$$$reportNull$$$0(0);
                }
                throw new IncorrectOperationException();
            }

            public boolean isValid() {
                return true;
            }

            public int hashCode() {
                String name = this.getName();
                return name != null ? name.hashCode() : 0;
            }

            public boolean equals(Object obj) {
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                String name = ((FunctionImpl)obj).getName();
                return name != null && name.equals(this.getName()) || this.getName() == null;
            }

            @Override
            public Function getDeclaration() {
                return this.myFunctionDecl;
            }

            public boolean isPhysical() {
                return true;
            }

            @Override
            public ContextProvider getXPathContext() {
                return ContextProvider.getContextProvider(Reference.this.getElement());
            }

            @Override
            public XPathVersion getXPathVersion() {
                return Reference.this.getElement().getXPathVersion();
            }

            @Override
            public void accept(XPathElementVisitor visitor) {
                visitor.visitXPathFunction(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/intellij/lang/xpath/psi/impl/XPathFunctionCallImpl$Reference$FunctionImpl", "setName"));
            }
        }
    }
}

