/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.PackageAnnotator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="JavaCoverageOptionsProvider", storages={@Storage(value="$WORKSPACE_FILE$")})
public class JavaCoverageOptionsProvider
implements PersistentStateComponent<State> {
    private State myState = new State();
    private Project myProject;

    public JavaCoverageOptionsProvider(Project project) {
        this.myProject = project;
    }

    public boolean ignoreImplicitConstructors() {
        return this.myState.myIgnoreImplicitConstructors;
    }

    public static JavaCoverageOptionsProvider getInstance(Project project) {
        return (JavaCoverageOptionsProvider)ServiceManager.getService((Project)project, JavaCoverageOptionsProvider.class);
    }

    public void setIgnoreImplicitConstructors(boolean state) {
        this.myState.myIgnoreImplicitConstructors = state;
    }

    public void setIgnoreEmptyPrivateConstructors(boolean state) {
        this.myState.myIgnoreEmptyPrivateConstructors = state;
    }

    public boolean ignoreEmptyPrivateConstructors() {
        return this.myState.myIgnoreEmptyPrivateConstructors;
    }

    public boolean isGeneratedConstructor(String qualifiedName, String methodSignature) {
        if (this.myState.myIgnoreImplicitConstructors || this.myState.myIgnoreEmptyPrivateConstructors) {
            PsiClass psiClass = (PsiClass)ReadAction.compute(() -> ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)qualifiedName));
            return PackageAnnotator.isGeneratedDefaultConstructor(psiClass, methodSignature, this.myState.myIgnoreImplicitConstructors, this.myState.myIgnoreEmptyPrivateConstructors);
        }
        return false;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            JavaCoverageOptionsProvider.$$$reportNull$$$0(0);
        }
        this.myState.myIgnoreEmptyPrivateConstructors = state.myIgnoreEmptyPrivateConstructors;
        this.myState.myIgnoreImplicitConstructors = state.myIgnoreImplicitConstructors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/coverage/JavaCoverageOptionsProvider", "loadState"));
    }

    public static class State {
        public boolean myIgnoreEmptyPrivateConstructors = true;
        public boolean myIgnoreImplicitConstructors = true;
    }
}

