/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.utils.ILogger;
import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleAvds
extends AndroidFacetScopedService {
    private static final Key<ModuleAvds> KEY = Key.create((String)ModuleAvds.class.getName());
    private AvdManager myAvdManager;

    @NotNull
    public static ModuleAvds getInstance(@NotNull AndroidFacet facet) {
        ModuleAvds avds;
        if (facet == null) {
            ModuleAvds.$$$reportNull$$$0(0);
        }
        if ((avds = (ModuleAvds)facet.getUserData(KEY)) == null) {
            avds = new ModuleAvds(facet);
            facet.putUserData(KEY, avds);
        }
        ModuleAvds moduleAvds = avds;
        if (moduleAvds == null) {
            ModuleAvds.$$$reportNull$$$0(1);
        }
        return moduleAvds;
    }

    public static void disposeInstance(@NotNull AndroidFacet facet) {
        ModuleAvds avds;
        if (facet == null) {
            ModuleAvds.$$$reportNull$$$0(2);
        }
        if ((avds = (ModuleAvds)facet.getUserData(KEY)) != null) {
            Disposer.dispose((Disposable)avds);
        }
    }

    private ModuleAvds(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleAvds.$$$reportNull$$$0(3);
        }
        super(facet);
    }

    @NotNull
    public AvdInfo[] getAllAvds() {
        AvdManager manager = this.getAvdManagerSilently();
        if (manager != null && this.reloadAvds(manager)) {
            AvdInfo[] avdInfoArray = manager.getAllAvds();
            if (avdInfoArray == null) {
                ModuleAvds.$$$reportNull$$$0(4);
            }
            return avdInfoArray;
        }
        AvdInfo[] avdInfoArray = new AvdInfo[]{};
        if (avdInfoArray == null) {
            ModuleAvds.$$$reportNull$$$0(5);
        }
        return avdInfoArray;
    }

    private boolean reloadAvds(@NotNull AvdManager manager) {
        if (manager == null) {
            ModuleAvds.$$$reportNull$$$0(6);
        }
        Project project = this.getModule().getProject();
        try {
            MessageBuildingSdkLog log = new MessageBuildingSdkLog();
            manager.reloadAvds((ILogger)log);
            if (!log.getErrorMessage().isEmpty()) {
                String message = AndroidBundle.message("cant.load.avds.error.prefix", new Object[0]) + ' ' + log.getErrorMessage();
                Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
            }
            return true;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("cant.load.avds.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return false;
        }
    }

    @NotNull
    public AvdInfo[] getValidCompatibleAvds() {
        AvdManager manager = this.getAvdManagerSilently();
        ArrayList<AvdInfo> result = new ArrayList<AvdInfo>();
        if (manager != null && this.reloadAvds(manager)) {
            this.addCompatibleAvds(result, manager.getValidAvds());
        }
        AvdInfo[] avdInfoArray = result.toArray(new AvdInfo[result.size()]);
        if (avdInfoArray == null) {
            ModuleAvds.$$$reportNull$$$0(7);
        }
        return avdInfoArray;
    }

    @NotNull
    private AvdInfo[] addCompatibleAvds(@NotNull List<AvdInfo> to, @NotNull AvdInfo[] from) {
        if (to == null) {
            ModuleAvds.$$$reportNull$$$0(8);
        }
        if (from == null) {
            ModuleAvds.$$$reportNull$$$0(9);
        }
        AndroidVersion minSdk = AndroidModuleInfo.getInstance(this.getFacet()).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            Logger.getInstance(this.getClass()).error("Android Platform not set for module: " + this.getModule().getName());
            AvdInfo[] avdInfoArray = new AvdInfo[]{};
            if (avdInfoArray == null) {
                ModuleAvds.$$$reportNull$$$0(10);
            }
            return avdInfoArray;
        }
        for (AvdInfo avd : from) {
            ISystemImage systemImage = avd.getSystemImage();
            if (systemImage != null && LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), systemImage).isCompatible() == ThreeState.NO) continue;
            to.add(avd);
        }
        AvdInfo[] avdInfoArray = to.toArray(new AvdInfo[to.size()]);
        if (avdInfoArray == null) {
            ModuleAvds.$$$reportNull$$$0(11);
        }
        return avdInfoArray;
    }

    @Nullable
    public AvdManager getAvdManagerSilently() {
        try {
            return this.getAvdManager(new AvdManagerLog());
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            return null;
        }
    }

    @Nullable
    public AvdManager getAvdManager(@NotNull ILogger log) throws AndroidLocation.AndroidLocationException {
        if (log == null) {
            ModuleAvds.$$$reportNull$$$0(12);
        }
        if (this.myAvdManager == null) {
            AndroidSdkData.getSdkData(this.getFacet());
            this.myAvdManager = AvdManager.getInstance((AndroidSdkHandler)AndroidSdkData.getSdkHolder(this.getFacet()), (ILogger)log);
        }
        return this.myAvdManager;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleAvds.$$$reportNull$$$0(13);
        }
        facet.putUserData(KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/ModuleAvds";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/ModuleAvds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAvds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidCompatibleAvds";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addCompatibleAvds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "disposeInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reloadAvds";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCompatibleAvds";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAvdManager";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onServiceDisposal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

