/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.sdklib.repository.targets.SystemImageManager;
import com.android.tools.idea.avdmanager.ApiLevelComparator;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemImageListModel
extends ListTableModel<SystemImageDescription> {
    private final Project myProject;
    private final StatusIndicator myIndicator;
    private final AndroidSdkHandler mySdkHandler;
    private boolean myUpdating;
    private int myCompletedCalls;
    private final Object myLock;
    private static final ProgressIndicator LOGGER = new StudioLoggerProgressIndicator(SystemImageListModel.class);
    private final ColumnInfo[] ourColumnInfos;

    public SystemImageListModel(@Nullable Project project, @NotNull StatusIndicator indicator) {
        if (indicator == null) {
            SystemImageListModel.$$$reportNull$$$0(0);
        }
        super(new ColumnInfo[0]);
        this.myLock = new Object();
        this.ourColumnInfos = new ColumnInfo[]{new SystemImageColumnInfo("Release Name"){

            @Nullable
            public String valueOf(SystemImageDescription systemImage) {
                String codeName;
                AndroidVersion version = systemImage.getVersion();
                String string = codeName = version.isPreview() ? version.getCodename() : SdkVersionInfo.getCodeName((int)version.getApiLevel());
                if (codeName == null) {
                    codeName = "API " + version.getApiLevel();
                }
                String maybeDeprecated = systemImage.obsolete() || version.getApiLevel() < 14 ? " (Deprecated)" : "";
                return codeName + maybeDeprecated;
            }
        }, new SystemImageColumnInfo("API Level", JBUI.scale((int)100)){

            @Nullable
            public String valueOf(SystemImageDescription systemImage) {
                return systemImage.getVersion().getApiString();
            }
        }, new SystemImageColumnInfo("ABI", JBUI.scale((int)100)){

            @Nullable
            public String valueOf(SystemImageDescription systemImage) {
                return systemImage.getAbiType();
            }
        }, new SystemImageColumnInfo("Target"){

            @Nullable
            public String valueOf(SystemImageDescription systemImage) {
                IdDisplay tag = systemImage.getTag();
                String name = systemImage.getName();
                return String.format("%1$s%2$s", name, tag.equals((Object)SystemImage.DEFAULT_TAG) ? "" : String.format(" (%s)", tag.getDisplay()));
            }
        }};
        this.myProject = project;
        this.myIndicator = indicator;
        this.mySdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        this.setColumnInfos(this.ourColumnInfos);
        this.setSortable(true);
    }

    public void refreshLocalImagesSynchronously() {
        try {
            this.myIndicator.onRefreshStart("Get local images...");
            this.setItems(this.getLocalImages());
        }
        finally {
            this.myIndicator.onRefreshDone("", true);
        }
    }

    public void setItems(@NotNull List<SystemImageDescription> items) {
        if (items == null) {
            SystemImageListModel.$$$reportNull$$$0(1);
        }
        this.myUpdating = true;
        super.setItems(items);
        this.myUpdating = false;
    }

    public boolean isUpdating() {
        return this.myUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshImages(boolean forceRefresh) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCompletedCalls = 0;
        }
        this.myIndicator.onRefreshStart("Refreshing...");
        ArrayList items = Lists.newArrayList();
        RepoManager.RepoLoadedCallback localComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            items.addAll(this.getLocalImages());
            this.setItems(items);
            this.completedDownload("");
        }, ModalityState.any());
        RepoManager.RepoLoadedCallback remoteComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            List<SystemImageDescription> remotes = SystemImageListModel.getRemoteImages(packages);
            if (remotes != null) {
                items.addAll(remotes);
                this.setItems(items);
            }
            this.completedDownload("");
        }, ModalityState.any());
        Runnable error = () -> ApplicationManager.getApplication().invokeLater(() -> this.completedDownload("Error loading remote images"), ModalityState.any());
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Loading Images", this.myProject);
        this.mySdkHandler.getSdkManager(LOGGER).load(forceRefresh ? 0L : RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)localComplete), (List)ImmutableList.of((Object)remoteComplete), (List)ImmutableList.of((Object)error), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completedDownload(@NotNull String message) {
        if (message == null) {
            SystemImageListModel.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCompletedCalls;
            this.myIndicator.onRefreshDone(message, this.myCompletedCalls < 2);
            if (this.myCompletedCalls < 2) {
                this.myIndicator.onRefreshStart("Refreshing...");
            }
        }
    }

    private List<SystemImageDescription> getLocalImages() {
        SystemImageManager systemImageManager = this.mySdkHandler.getSystemImageManager(LOGGER);
        ArrayList items = Lists.newArrayList();
        for (ISystemImage image : systemImageManager.getImages()) {
            SystemImageDescription desc = new SystemImageDescription(image);
            items.add(desc);
        }
        return items;
    }

    @Nullable
    private static List<SystemImageDescription> getRemoteImages(@NotNull RepositoryPackages packages) {
        if (packages == null) {
            SystemImageListModel.$$$reportNull$$$0(3);
        }
        ArrayList items = Lists.newArrayList();
        Set infos = packages.getNewPkgs();
        if (infos.isEmpty()) {
            return null;
        }
        for (RemotePackage info : infos) {
            if (!SystemImageDescription.hasSystemImage((RepoPackage)info)) continue;
            SystemImageDescription image = new SystemImageDescription(info);
            items.add(image);
        }
        return items;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/avdmanager/SystemImageListModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setItems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "completedDownload";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRemoteImages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface StatusIndicator {
        public void onRefreshStart(@NotNull String var1);

        public void onRefreshDone(@NotNull String var1, boolean var2);
    }

    public abstract class SystemImageColumnInfo
    extends ColumnInfo<SystemImageDescription, String> {
        private final int myWidth;
        final /* synthetic */ SystemImageListModel this$0;

        public SystemImageColumnInfo(@NotNull SystemImageListModel this$0, String name, int width) {
            if (name == null) {
                SystemImageColumnInfo.$$$reportNull$$$0(0);
            }
            this.this$0 = this$0;
            super(name);
            this.myWidth = width;
        }

        public SystemImageColumnInfo(@NotNull SystemImageListModel this$0, String name) {
            if (name == null) {
                SystemImageColumnInfo.$$$reportNull$$$0(1);
            }
            this(this$0, name, -1);
        }

        public boolean isCellEditable(SystemImageDescription systemImageDescription) {
            return systemImageDescription.isRemote();
        }

        @Nullable
        public TableCellEditor getEditor(SystemImageDescription o) {
            return new SystemImageDescriptionRenderer(o);
        }

        @Nullable
        public TableCellRenderer getRenderer(SystemImageDescription o) {
            return new SystemImageDescriptionRenderer(o);
        }

        private void downloadImage(SystemImageDescription image) {
            ArrayList requestedPackages = Lists.newArrayList((Object[])new String[]{image.getRemotePackage().getPath()});
            ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(this.this$0.myProject, requestedPackages);
            if (dialog != null) {
                dialog.show();
                this.this$0.refreshImages(true);
            }
        }

        @Nullable
        public Comparator<SystemImageDescription> getComparator() {
            return new Comparator<SystemImageDescription>(){
                ApiLevelComparator myComparator = new ApiLevelComparator();

                @Override
                public int compare(SystemImageDescription o1, SystemImageDescription o2) {
                    int res = this.myComparator.compare((String)SystemImageColumnInfo.this.valueOf(o1), (String)SystemImageColumnInfo.this.valueOf(o2));
                    if (res == 0) {
                        return o1.getTag().compareTo(o2.getTag());
                    }
                    return res;
                }
            };
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/SystemImageListModel$SystemImageColumnInfo", "<init>"));
        }

        private class SystemImageDescriptionRenderer
        extends AbstractTableCellEditor
        implements TableCellRenderer {
            private SystemImageDescription image;

            SystemImageDescriptionRenderer(SystemImageDescription o) {
                this.image = o;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JPanel panel = new JPanel(new FlowLayout(0));
                if (isSelected) {
                    if (this.image.isRemote()) {
                        panel.setBackground(UIUtil.getListUnfocusedSelectionBackground());
                    } else {
                        panel.setBackground(table.getSelectionBackground());
                    }
                    panel.setForeground(table.getSelectionForeground());
                    panel.setOpaque(true);
                } else {
                    panel.setBackground(table.getBackground());
                    panel.setForeground(table.getForeground());
                    panel.setOpaque(true);
                }
                JBLabel label = new JBLabel((String)value);
                Font labelFont = UIUtil.getLabelFont();
                if (column == 0) {
                    label.setFont(labelFont.deriveFont(1));
                }
                if (this.image.isRemote()) {
                    Font font = labelFont.deriveFont(label.getFont().getStyle() | 2);
                    label.setFont(font);
                    label.setForeground(UIUtil.getLabelDisabledForeground());
                    if (!label.getText().isEmpty()) {
                        int fontMetricsWidth = label.getFontMetrics(label.getFont()).stringWidth(label.getText());
                        TextLayout l = new TextLayout(label.getText(), label.getFont(), label.getFontMetrics(label.getFont()).getFontRenderContext());
                        int offset = (int)Math.ceil(l.getBounds().getWidth()) - fontMetricsWidth;
                        if (offset > 0) {
                            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, offset));
                        }
                    }
                    panel.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyTyped(KeyEvent e) {
                            if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                                SystemImageColumnInfo.this.downloadImage(SystemImageDescriptionRenderer.this.image);
                            }
                        }
                    });
                }
                panel.add((Component)label);
                if (this.image.isRemote() && column == 0) {
                    JBLabel link = new JBLabel("Download");
                    link.setBackground(table.getBackground());
                    link.setCursor(Cursor.getPredefinedCursor(12));
                    link.setForeground((Color)JBColor.BLUE);
                    Font font = link.getFont();
                    if (isSelected) {
                        HashMap attrs = Maps.newHashMap();
                        attrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                        font = font.deriveFont(attrs);
                    }
                    link.setFont(font);
                    link.addMouseListener((MouseListener)new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            SystemImageColumnInfo.this.downloadImage(SystemImageDescriptionRenderer.this.image);
                        }
                    });
                    panel.add((Component)link);
                }
                return panel;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return this.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }

            public Object getCellEditorValue() {
                return null;
            }

            public boolean isCellEditable(EventObject e) {
                return true;
            }
        }
    }
}

