/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ui;

import com.android.layoutinspector.model.DisplayInfo;
import com.android.layoutinspector.model.ViewNode;
import com.android.tools.idea.editors.theme.MaterialColors;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewNodeActiveDisplay
extends JComponent {
    private static final Color DEFAULT_COLOR = Color.GRAY;
    private static final Color HOVER_COLOR = MaterialColors.DEEP_ORANGE_900;
    private static final Color SELECTED_COLOR = MaterialColors.LIGHT_BLUE_800;
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Stroke THICK_STROKE = new BasicStroke(2.0f);
    @NotNull
    private final ViewNode mRoot;
    @Nullable
    private final Image mPreview;
    private final List<ViewNodeActiveDisplayListener> mListeners;
    private int mLastWidth;
    private int mLastHeight;
    private int mDrawShiftX;
    private int mDrawShiftY;
    @Nullable
    private ViewNode mHoverNode;
    @Nullable
    private ViewNode mSelectedNode;

    public ViewNodeActiveDisplay(@NotNull ViewNode root, @Nullable Image preview) {
        if (root == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(0);
        }
        this.mListeners = Lists.newArrayList();
        this.mRoot = root;
        this.mPreview = preview;
        MyMouseAdapter adapter = new MyMouseAdapter();
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    public void addViewNodeActiveDisplayListener(ViewNodeActiveDisplayListener listener) {
        this.mListeners.add(listener);
    }

    public void removeViewNodeActiveDisplayListener(ViewNodeActiveDisplayListener listener) {
        this.mListeners.remove(listener);
    }

    public void setHoverNode(@Nullable ViewNode node) {
        if (!Objects.equal((Object)node, (Object)this.mHoverNode)) {
            this.mHoverNode = node;
            this.repaint();
            for (ViewNodeActiveDisplayListener listener : this.mListeners) {
                listener.onViewNodeOver(this.mHoverNode);
            }
        }
    }

    public void setSelectedNode(@NotNull ViewNode node) {
        if (node == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(1);
        }
        if (!Objects.equal((Object)node, (Object)this.mSelectedNode)) {
            this.mSelectedNode = node;
            this.repaint();
            for (ViewNodeActiveDisplayListener listener : this.mListeners) {
                listener.onNodeSelected(this.mSelectedNode);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mLastWidth != this.getWidth() || this.mLastHeight != this.getHeight()) {
            this.mLastWidth = this.getWidth();
            this.mLastHeight = this.getHeight();
            this.recalculateNodeBounds();
        }
        this.paintPreview((Graphics2D)g);
    }

    private void recalculateNodeBounds() {
        float width = this.getWidth() - 20;
        float height = this.getHeight() - 20;
        float rootHeight = this.mRoot.displayInfo.height;
        float rootWidth = this.mRoot.displayInfo.width;
        float drawScale = Math.min(width / rootWidth, height / rootHeight);
        this.mDrawShiftX = (int)((float)this.getWidth() - drawScale * rootWidth) / 2;
        this.mDrawShiftY = (int)((float)this.getHeight() - drawScale * rootHeight) / 2;
        this.calculateNodeBounds(this.mRoot, 0.0f, 0.0f, 1.0f, 1.0f, drawScale);
    }

    private void calculateNodeBounds(@NotNull ViewNode node, float leftShift, float topshift, float scaleX, float scaleY, float drawScale) {
        if (node == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(2);
        }
        DisplayInfo info = node.displayInfo;
        float newScaleX = scaleX * info.scaleX;
        float newScaleY = scaleY * info.scaleY;
        float l = leftShift + ((float)info.left + info.translateX) * scaleX + (float)info.width * (scaleX - newScaleX) / 2.0f;
        float t = topshift + ((float)info.top + info.translateY) * scaleY + (float)info.height * (scaleY - newScaleY) / 2.0f;
        node.previewBox.setBounds((int)(l * drawScale), (int)(t * drawScale), (int)((float)info.width * newScaleX * drawScale), (int)((float)info.height * newScaleY * drawScale));
        if (!node.isLeaf()) {
            float shiftX = l - (float)info.scrollX;
            float shiftY = t - (float)info.scrollY;
            for (ViewNode child : node.children) {
                this.calculateNodeBounds(child, shiftX, shiftY, newScaleX, newScaleY, drawScale);
            }
        }
    }

    private void paintPreview(Graphics2D g) {
        g.translate(this.mDrawShiftX, this.mDrawShiftY);
        if (this.mPreview != null) {
            g.drawImage(this.mPreview, 0, 0, this.mRoot.previewBox.width, this.mRoot.previewBox.height, 0, 0, this.mPreview.getWidth(null), this.mPreview.getHeight(null), null);
        }
        g.clipRect(0, 0, this.mRoot.previewBox.width, this.mRoot.previewBox.height);
        g.setColor(DEFAULT_COLOR);
        g.setStroke(DEFAULT_STROKE);
        this.paintNode(this.mRoot, g);
        g.setStroke(THICK_STROKE);
        if (this.mHoverNode != null && this.mSelectedNode != this.mHoverNode) {
            g.setColor(HOVER_COLOR);
            this.paintBox(this.mHoverNode.previewBox, g);
        }
        if (this.mSelectedNode != null) {
            g.setColor(SELECTED_COLOR);
            this.paintBox(this.mSelectedNode.previewBox, g);
        }
    }

    private void paintNode(ViewNode node, Graphics2D g) {
        if (node != this.mHoverNode && node != this.mSelectedNode) {
            this.paintBox(node.previewBox, g);
        }
        if (!node.isLeaf()) {
            for (ViewNode child : node.children) {
                if (!child.isDrawn()) continue;
                this.paintNode(child, g);
            }
        }
    }

    private void paintBox(Rectangle box, Graphics2D g) {
        g.drawRect(box.x, box.y, box.width, box.height);
    }

    @Nullable
    private ViewNode getNode(MouseEvent e) {
        int y;
        int x = e.getX() - this.mDrawShiftX;
        if (!this.mRoot.previewBox.contains(x, y = e.getY() - this.mDrawShiftY)) {
            return null;
        }
        return this.updateSelection(this.mRoot, x, y, new ViewNode[1], 0, 0, this.mRoot.previewBox.width, this.mRoot.previewBox.height);
    }

    @Nullable
    private ViewNode updateSelection(@NotNull ViewNode node, int x, int y, @NotNull ViewNode[] firstNoDrawChild, int clipX1, int clipY1, int clipX2, int clipY2) {
        if (node == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(3);
        }
        if (firstNoDrawChild == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(4);
        }
        if (!node.isDrawn()) {
            return null;
        }
        boolean wasFirstNoDrawChildNull = firstNoDrawChild[0] == null;
        Rectangle boxpos = node.previewBox;
        int boxRight = boxpos.x + boxpos.width;
        int boxBottom = boxpos.y + boxpos.height;
        if (node.displayInfo.clipChildren) {
            clipX1 = Math.max(clipX1, boxpos.x);
            clipY1 = Math.max(clipY1, boxpos.y);
            clipX2 = Math.min(clipX2, boxRight);
            clipY2 = Math.min(clipY2, boxBottom);
        }
        if (clipX1 < x && clipX2 > x && clipY1 < y && clipY2 > y) {
            for (int i = node.children.size() - 1; i >= 0; --i) {
                ViewNode child = (ViewNode)node.children.get(i);
                ViewNode ret = this.updateSelection(child, x, y, firstNoDrawChild, clipX1, clipY1, clipX2, clipY2);
                if (ret == null) continue;
                return ret;
            }
        }
        if (boxpos.x < x && boxRight > x && boxpos.y < y && boxBottom > y) {
            if (node.displayInfo.willNotDraw) {
                if (firstNoDrawChild[0] == null) {
                    firstNoDrawChild[0] = node;
                }
                return null;
            }
            if (wasFirstNoDrawChildNull && firstNoDrawChild[0] != null) {
                return firstNoDrawChild[0];
            }
            return node;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstNoDrawChild";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/layoutInspector/ui/ViewNodeActiveDisplay";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateNodeBounds";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ViewNodeActiveDisplayListener {
        public void onViewNodeOver(@Nullable ViewNode var1);

        public void onNodeSelected(@NotNull ViewNode var1);
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ViewNodeActiveDisplay.this.setHoverNode(ViewNodeActiveDisplay.this.getNode(e));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ViewNodeActiveDisplay.this.setHoverNode(ViewNodeActiveDisplay.this.getNode(e));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ViewNodeActiveDisplay.this.setHoverNode(null);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ViewNode clicked = ViewNodeActiveDisplay.this.getNode(e);
            if (clicked != null) {
                ViewNodeActiveDisplay.this.setSelectedNode(clicked);
            }
        }
    }
}

