/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.table.NeedsTranslationForLocaleRowFilter;
import com.android.tools.idea.editors.strings.table.NeedsTranslationsRowFilter;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.android.tools.idea.editors.strings.table.TextRowFilter;
import com.android.tools.idea.rendering.Locale;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.ui.DialogBuilder;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FilterKeysAction
extends ComboBoxAction {
    private final StringResourceTable myTable;

    FilterKeysAction(@NotNull StringResourceTable table) {
        if (table == null) {
            FilterKeysAction.$$$reportNull$$$0(0);
        }
        this.myTable = table;
    }

    public void update(@NotNull AnActionEvent event) {
        StringResourceTableRowFilter filter;
        if (event == null) {
            FilterKeysAction.$$$reportNull$$$0(1);
        }
        if ((filter = this.myTable.getRowFilter()) == null) {
            Presentation presentation = event.getPresentation();
            presentation.setIcon(null);
            presentation.setText("Show All Keys");
        } else {
            filter.update(event.getPresentation());
        }
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@Nullable JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        group.add(new AnAction("Show All Keys"){

            public void actionPerformed(@Nullable AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(null);
            }
        });
        group.add(new AnAction("Show Translatable Keys"){

            public void actionPerformed(@Nullable AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(new NeedsTranslationsRowFilter(true));
            }
        });
        group.add(new AnAction("Show Keys Needing Translations"){

            public void actionPerformed(@Nullable AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(new NeedsTranslationsRowFilter(false));
            }
        });
        group.add(new AnAction("Filter by Text", "Filter the translations editor table keys by text", AllIcons.General.Filter){

            public void actionPerformed(@Nullable AnActionEvent e) {
                String filterString;
                JTextField textField = new JTextField();
                DialogBuilder builder = new DialogBuilder();
                builder.setTitle("Filter by Text");
                builder.setCenterPanel((JComponent)textField);
                builder.setPreferredFocusComponent((JComponent)textField);
                if (builder.showAndGet() && !(filterString = textField.getText()).isEmpty()) {
                    FilterKeysAction.this.myTable.setRowFilter(new TextRowFilter(filterString));
                }
            }
        });
        StringResourceTableModel model = this.myTable.getModel();
        IntStream.range(4, model.getColumnCount()).mapToObj(model::getLocale).map(this::newShowKeysNeedingTranslationForLocaleAction).forEach(arg_0 -> ((DefaultActionGroup)group).add(arg_0));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            FilterKeysAction.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @NotNull
    private AnAction newShowKeysNeedingTranslationForLocaleAction(final @NotNull Locale locale) {
        if (locale == null) {
            FilterKeysAction.$$$reportNull$$$0(3);
        }
        String text = "Show Keys Needing a Translation for " + LocaleMenuAction.getLocaleLabel(locale, false);
        AnAction anAction = new AnAction(text, null, locale.getFlagImage()){

            public void actionPerformed(@Nullable AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(new NeedsTranslationForLocaleRowFilter(locale));
            }
        };
        if (anAction == null) {
            FilterKeysAction.$$$reportNull$$$0(4);
        }
        return anAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/FilterKeysAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/FilterKeysAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newShowKeysNeedingTranslationForLocaleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newShowKeysNeedingTranslationForLocaleAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

