/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceRepository {
    private final Map<StringResourceKey, LocalResourceRepository> myKeyToRepositoryMap;

    public StringResourceRepository(@NotNull MultiResourceRepository parent) {
        if (parent == null) {
            StringResourceRepository.$$$reportNull$$$0(0);
        }
        this.myKeyToRepositoryMap = new LinkedHashMap<StringResourceKey, LocalResourceRepository>();
        for (LocalResourceRepository localResourceRepository : parent.getChildren()) {
            VirtualFile directory = localResourceRepository instanceof ResourceFolderRepository ? ((ResourceFolderRepository)localResourceRepository).getResourceDir() : null;
            localResourceRepository.sync();
            for (String name : localResourceRepository.getItemsOfType(ResourceType.STRING)) {
                this.myKeyToRepositoryMap.put(new StringResourceKey(name, directory), localResourceRepository);
            }
        }
    }

    @NotNull
    final StringResourceData getData(@NotNull AndroidFacet facet) {
        if (facet == null) {
            StringResourceRepository.$$$reportNull$$$0(1);
        }
        Project project = facet.getModule().getProject();
        Map map = this.myKeyToRepositoryMap.keySet().stream().collect(Collectors.toMap(Function.identity(), key -> new StringResource((StringResourceKey)key, this, project), (resource1, resource2) -> {
            throw new IllegalStateException("Duplicate key " + resource1);
        }, LinkedHashMap::new));
        StringResourceData stringResourceData = new StringResourceData(facet, map);
        if (stringResourceData == null) {
            StringResourceRepository.$$$reportNull$$$0(2);
        }
        return stringResourceData;
    }

    @NotNull
    public Collection<ResourceItem> getItems(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(3);
        }
        Collection<ResourceItem> collection = StringResourceRepository.getItems(this.myKeyToRepositoryMap.get(key), key);
        if (collection == null) {
            StringResourceRepository.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Nullable
    final ResourceItem getDefaultValue(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(5);
        }
        return this.getItem(key, item -> item.getConfiguration().getLocaleQualifier() == null);
    }

    @Nullable
    final ResourceItem getTranslation(@NotNull StringResourceKey key, @NotNull Locale locale) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(6);
        }
        if (locale == null) {
            StringResourceRepository.$$$reportNull$$$0(7);
        }
        return this.getItem(key, item -> {
            if (locale == null) {
                StringResourceRepository.$$$reportNull$$$0(15);
            }
            return StringResourceRepository.localeEquals((Configurable)item, locale);
        });
    }

    private static boolean localeEquals(@NotNull Configurable item, @NotNull Locale locale) {
        LocaleQualifier qualifier;
        if (item == null) {
            StringResourceRepository.$$$reportNull$$$0(8);
        }
        if (locale == null) {
            StringResourceRepository.$$$reportNull$$$0(9);
        }
        return (qualifier = item.getConfiguration().getLocaleQualifier()) != null && Locale.create(qualifier).equals(locale);
    }

    @Nullable
    private ResourceItem getItem(@NotNull StringResourceKey key, @NotNull Predicate<ResourceItem> predicate) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(10);
        }
        if (predicate == null) {
            StringResourceRepository.$$$reportNull$$$0(11);
        }
        LocalResourceRepository repository = this.myKeyToRepositoryMap.get(key);
        repository.sync();
        Optional<ResourceItem> optionalItem = StringResourceRepository.getItems(repository, key).stream().filter(predicate).findFirst();
        return optionalItem.orElse(null);
    }

    @NotNull
    private static Collection<ResourceItem> getItems(@NotNull AbstractResourceRepository repository, @NotNull StringResourceKey key) {
        List items;
        if (repository == null) {
            StringResourceRepository.$$$reportNull$$$0(12);
        }
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(13);
        }
        List list = (items = repository.getResourceItem(ResourceType.STRING, key.getName())) == null ? Collections.emptyList() : items;
        if (list == null) {
            StringResourceRepository.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceRepository";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 4: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: 
            case 4: 
            case 14: {
                break;
            }
            case 3: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTranslation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "localeEquals";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getItem";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTranslation$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

