/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public abstract class GradleDslFile
extends GradlePropertiesDslElement {
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<GradleDslFile> myChildModuleDslFiles;
    @Nullable
    private GradleDslFile myParentModuleDslFile;
    @Nullable
    private GradleDslFile mySiblingDslFile;

    protected GradleDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            GradleDslFile.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleDslFile.$$$reportNull$$$0(1);
        }
        if (moduleName == null) {
            GradleDslFile.$$$reportNull$$$0(2);
        }
        super(null, null, moduleName);
        this.myChildModuleDslFiles = Sets.newHashSet();
        this.myFile = file;
        this.myProject = project;
    }

    public void reparse() {
        this.clear();
        this.parse();
    }

    public void parse() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        GroovyFile myPsiFile = null;
        if (psiFile instanceof GroovyFile) {
            myPsiFile = (GroovyFile)psiFile;
        }
        if (myPsiFile == null) {
            return;
        }
        this.setPsiElement((GroovyPsiElement)myPsiFile);
        this.parse(myPsiFile);
    }

    protected void parse(@NotNull GroovyFile myPsiFile) {
        if (myPsiFile == null) {
            GradleDslFile.$$$reportNull$$$0(3);
        }
        myPsiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            public void visitMethodCallExpression(GrMethodCallExpression e) {
                this.process((GroovyPsiElement)e);
            }

            public void visitAssignmentExpression(GrAssignmentExpression e) {
                this.process((GroovyPsiElement)e);
            }

            public void visitApplicationStatement(GrApplicationStatement e) {
                this.process((GroovyPsiElement)e);
            }

            void process(GroovyPsiElement e) {
                GradleDslParser.parse(e, GradleDslFile.this);
            }
        }));
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleDslFile.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            GradleDslFile.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    public File getDirectoryPath() {
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile().getParent());
        if (file == null) {
            GradleDslFile.$$$reportNull$$$0(6);
        }
        return file;
    }

    public void setParentModuleDslFile(@NotNull GradleDslFile parentModuleDslFile) {
        if (parentModuleDslFile == null) {
            GradleDslFile.$$$reportNull$$$0(7);
        }
        this.myParentModuleDslFile = parentModuleDslFile;
        this.myParentModuleDslFile.myChildModuleDslFiles.add(this);
    }

    @Nullable
    public GradleDslFile getParentModuleDslFile() {
        return this.myParentModuleDslFile;
    }

    @NotNull
    public Collection<GradleDslFile> getChildModuleDslFiles() {
        Set<GradleDslFile> set = this.myChildModuleDslFiles;
        if (set == null) {
            GradleDslFile.$$$reportNull$$$0(8);
        }
        return set;
    }

    public void setSiblingDslFile(@NotNull GradleDslFile siblingDslFile) {
        if (siblingDslFile == null) {
            GradleDslFile.$$$reportNull$$$0(9);
        }
        this.mySiblingDslFile = siblingDslFile;
    }

    @Nullable
    public GradleDslFile getSiblingDslFile() {
        return this.mySiblingDslFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myPsiFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/GradleDslFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentModuleDslFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblingDslFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/GradleDslFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildModuleDslFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setParentModuleDslFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSiblingDslFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

