/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidProject;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidModuleDependenciesSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupIssues;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.android.tools.idea.gradle.util.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesAndroidModuleSetupStep
extends AndroidModuleSetupStep {
    @NotNull
    private final DependenciesExtractor myDependenciesExtractor;
    @NotNull
    private final AndroidModuleDependenciesSetup myDependenciesSetup;

    public DependenciesAndroidModuleSetupStep() {
        this(DependenciesExtractor.getInstance(), new AndroidModuleDependenciesSetup(LibraryFilePaths.getInstance()));
    }

    @VisibleForTesting
    DependenciesAndroidModuleSetupStep(@NotNull DependenciesExtractor dependenciesExtractor, @NotNull AndroidModuleDependenciesSetup dependenciesSetup) {
        if (dependenciesExtractor == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(0);
        }
        if (dependenciesSetup == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(1);
        }
        this.myDependenciesExtractor = dependenciesExtractor;
        this.myDependenciesSetup = dependenciesSetup;
    }

    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull AndroidModuleModel androidModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(2);
        }
        if (ideModelsProvider == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(3);
        }
        if (androidModel == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(4);
        }
        DependencySet dependencies2 = this.myDependenciesExtractor.extractFrom(androidModel.getSelectedVariant());
        for (Dependency dependency : dependencies2.onLibraries()) {
            this.updateLibraryDependency(module, ideModelsProvider, (LibraryDependency)dependency, androidModel);
        }
        for (Dependency dependency : dependencies2.onModules()) {
            this.updateModuleDependency(module, ideModelsProvider, (ModuleDependency)dependency, androidModel);
        }
        this.addExtraSdkLibrariesAsDependencies(module, ideModelsProvider, androidModel);
        Collection<SyncIssue> syncIssues = androidModel.getSyncIssues();
        if (syncIssues != null) {
            SyncIssuesReporter.getInstance().report(syncIssues, module);
        } else {
            Collection unresolvedDependencies = androidModel.getAndroidProject().getUnresolvedDependencies();
            UnresolvedDependenciesReporter.getInstance().report(unresolvedDependencies, module);
        }
    }

    private static boolean getExported(@NotNull AndroidModuleModel androidModuleModel) {
        if (androidModuleModel == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(5);
        }
        return androidModuleModel.getFeatures().shouldExportDependencies();
    }

    @VisibleForTesting
    void updateModuleDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleDependency dependency, @NotNull AndroidModuleModel moduleModel) {
        if (module == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(6);
        }
        if (modelsProvider == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(7);
        }
        if (dependency == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(8);
        }
        if (moduleModel == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(9);
        }
        Module moduleDependency = dependency.getModule(modelsProvider);
        LibraryDependency compiledArtifact = dependency.getBackupDependency();
        if (moduleDependency != null) {
            ModuleOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module).addModuleOrderEntry(moduleDependency);
            orderEntry.setScope(dependency.getScope());
            orderEntry.setExported(DependenciesAndroidModuleSetupStep.getExported(moduleModel));
            return;
        }
        DependencySetupIssues dependencySetupIssues = DependencySetupIssues.getInstance(module.getProject());
        String backupName = compiledArtifact != null ? compiledArtifact.getName() : null;
        dependencySetupIssues.addMissingModule(dependency.getGradlePath(), module.getName(), backupName);
        if (compiledArtifact != null) {
            this.updateLibraryDependency(module, modelsProvider, compiledArtifact, moduleModel);
        }
    }

    public void updateLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryDependency dependency, @NotNull AndroidModuleModel moduleModel) {
        if (module == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(10);
        }
        if (modelsProvider == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(11);
        }
        if (dependency == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(12);
        }
        if (moduleModel == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(13);
        }
        String name = dependency.getName();
        DependencyScope scope = dependency.getScope();
        this.myDependenciesSetup.setUpLibraryDependency(module, modelsProvider, name, scope, dependency.getArtifactPath(), dependency.getPaths(LibraryDependency.PathType.BINARY), dependency.getPaths(LibraryDependency.PathType.DOCUMENTATION), DependenciesAndroidModuleSetupStep.getExported(moduleModel));
        File buildFolder = moduleModel.getAndroidProject().getBuildFolder();
        ContentEntry[] contentEntries = modelsProvider.getModifiableRootModel(module).getContentEntries();
        if (contentEntries.length > 0) {
            for (File binaryPath : dependency.getPaths(LibraryDependency.PathType.BINARY)) {
                ContentEntry parentContentEntry;
                File parent = binaryPath.getParentFile();
                if (parent == null || !"jars".equals(parent.getName()) || !FileUtil.isAncestor((File)buildFolder, (File)parent, (boolean)true) || (parentContentEntry = ContentEntries.findParentContentEntry(parent, Arrays.stream(contentEntries))) == null) continue;
                parentContentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(parent));
            }
        }
    }

    private void addExtraSdkLibrariesAsDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidModuleModel androidModuleModel) {
        SdkAdditionalData data;
        if (module == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(14);
        }
        if (modelsProvider == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(15);
        }
        if (androidModuleModel == null) {
            DependenciesAndroidModuleSetupStep.$$$reportNull$$$0(16);
        }
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        IdeAndroidProject androidProject = androidModuleModel.getAndroidProject();
        Sdk sdk = moduleModel.getSdk();
        assert (sdk != null);
        String suffix = null;
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData != null && (data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData) {
            VirtualFile[] androidSdkData = (VirtualFile[])data;
            suffix = androidSdkData.getBuildTargetHashString();
        }
        if (suffix == null) {
            suffix = androidProject.getCompileTarget();
        }
        HashSet currentIdeSdkFilePaths = Sets.newHashSetWithExpectedSize((int)5);
        for (VirtualFile sdkFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            File sdkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile);
            currentIdeSdkFilePaths.add(sdkFilePath.getPath());
        }
        Collection bootClasspath = androidProject.getBootClasspath();
        for (String library : bootClasspath) {
            if (!StringUtil.isNotEmpty((String)library) || currentIdeSdkFilePaths.contains(library)) continue;
            File binaryPath = new File(library);
            String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)library);
            name = name + "-" + suffix;
            this.myDependenciesSetup.setUpLibraryDependency(module, modelsProvider, name, DependencyScope.COMPILE, binaryPath, DependenciesAndroidModuleSetupStep.getExported(androidModuleModel));
        }
    }

    @Override
    public boolean invokeOnBuildVariantChange() {
        return true;
    }

    @Override
    public boolean invokeOnSkippedSync() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesExtractor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesSetup";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleModel";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/android/DependenciesAndroidModuleSetupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doSetUpModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getExported";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateModuleDependency";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLibraryDependency";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtraSdkLibrariesAsDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

