/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview;

import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview.DependencyNodes;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AndroidArtifactNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.ArtifactComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.PsDependencyComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsResettableNode;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsDependencyContainer;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.util.containers.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResolvedDependenciesTreeRootNode
extends AbstractPsResettableNode<PsAndroidModule> {
    private boolean myGroupVariants;

    ResolvedDependenciesTreeRootNode(@NotNull PsAndroidModule module) {
        if (module == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(0);
        }
        super(module);
        this.myGroupVariants = PsUISettings.getInstance().RESOLVED_DEPENDENCIES_GROUP_VARIANTS;
    }

    boolean settingsChanged() {
        if (PsUISettings.getInstance().RESOLVED_DEPENDENCIES_GROUP_VARIANTS != this.myGroupVariants) {
            this.myGroupVariants = PsUISettings.getInstance().RESOLVED_DEPENDENCIES_GROUP_VARIANTS;
            this.reset();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected List<? extends AbstractPsModelNode> createChildren() {
        HashMap variantsByName = Maps.newHashMap();
        for (PsAndroidModule module : this.getModels()) {
            module.forEachVariant(variant -> variantsByName.put(variant.getName(), variant));
        }
        PsAndroidModule androidModule = (PsAndroidModule)this.getModels().get(0);
        if (this.myGroupVariants) {
            List<? extends AbstractPsModelNode> list = this.createGroupedChildren(androidModule, variantsByName);
            if (list == null) {
                ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<? extends AndroidArtifactNode> list = this.createChildren(androidModule, variantsByName);
        if (list == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private List<? extends AbstractPsModelNode> createGroupedChildren(@NotNull PsAndroidModule module, @NotNull Map<String, PsVariant> variantsByName) {
        if (module == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(3);
        }
        if (variantsByName == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(4);
        }
        HashMap containersWithMainArtifactByVariant = Maps.newHashMap();
        Map<List<PsDependencyContainer>, List<PsDependency>> groupedDependencies = ResolvedDependenciesTreeRootNode.groupDependencies(module);
        block0: for (List<PsDependencyContainer> containers : groupedDependencies.keySet()) {
            for (PsDependencyContainer container : containers) {
                if (!container.getArtifact().endsWith("_main_")) continue;
                containersWithMainArtifactByVariant.put(container.getVariant(), containers);
                continue block0;
            }
        }
        ArrayList children = Lists.newArrayList();
        for (List<PsDependencyContainer> containers : groupedDependencies.keySet()) {
            AndroidArtifactNode mainArtifactNode;
            List<PsAndroidArtifact> groupArtifacts;
            block8: {
                block9: {
                    List mainArtifactContainers;
                    groupArtifacts = ResolvedDependenciesTreeRootNode.extractArtifacts(containers, variantsByName);
                    mainArtifactNode = null;
                    if (containersWithMainArtifactByVariant.values().contains(containers)) break block8;
                    if (containers.size() != 1) break block9;
                    PsDependencyContainer container = containers.get(0);
                    String variantName = container.getVariant();
                    PsVariant variant = variantsByName.get(variantName);
                    assert (variant != null);
                    PsAndroidArtifact mainArtifact = variant.findArtifact("_main_");
                    if (mainArtifact == null || (mainArtifactContainers = (List)containersWithMainArtifactByVariant.get(variantName)) == null) break block8;
                    List<PsDependency> mainArtifactDependencies = groupedDependencies.get(mainArtifactContainers);
                    mainArtifactNode = this.createArtifactNode(mainArtifact, mainArtifactDependencies, null);
                    break block8;
                }
                for (PsDependencyContainer container : containers) {
                    List mainArtifactContainers = (List)containersWithMainArtifactByVariant.get(container.getVariant());
                    if (mainArtifactContainers == null) continue;
                    List<PsAndroidArtifact> mainArtifacts = ResolvedDependenciesTreeRootNode.extractArtifacts(mainArtifactContainers, variantsByName);
                    mainArtifactNode = this.createArtifactNode(mainArtifacts, groupedDependencies.get(mainArtifactContainers), null);
                    break;
                }
            }
            Collections.sort(groupArtifacts, ArtifactComparator.INSTANCE);
            AndroidArtifactNode artifactNode = this.createArtifactNode(groupArtifacts, groupedDependencies.get(containers), mainArtifactNode);
            if (artifactNode == null) continue;
            children.add(artifactNode);
        }
        Collections.sort(children, (a1, a2) -> a1.getName().compareTo(a2.getName()));
        ArrayList arrayList = children;
        if (arrayList == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @VisibleForTesting
    @NotNull
    static Map<List<PsDependencyContainer>, List<PsDependency>> groupDependencies(@NotNull PsAndroidModule module) {
        if (module == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(6);
        }
        HashMap dependenciesByContainer = Maps.newHashMap();
        HashMap containerWithMainArtifact = Maps.newHashMap();
        module.forEachDependency(dependency -> {
            Collection<PsDependencyContainer> containers = dependency.getContainers();
            for (PsDependencyContainer container : containers) {
                List containerDependencies;
                if (container.getArtifact().equals("_main_")) {
                    containerWithMainArtifact.put(container.getVariant(), container);
                }
                if ((containerDependencies = (List)dependenciesByContainer.get(container)) == null) {
                    containerDependencies = new SortedList((Comparator)PsDependencyComparator.INSTANCE);
                    dependenciesByContainer.put(container, containerDependencies);
                }
                containerDependencies.add(dependency);
            }
        });
        ArrayList containerGroups = Lists.newArrayList();
        ArrayList containers = Lists.newArrayList(dependenciesByContainer.keySet());
        ArrayList currentGroup = Lists.newArrayList();
        while (!containers.isEmpty()) {
            PsDependencyContainer container1 = (PsDependencyContainer)containers.get(0);
            currentGroup.add(container1);
            if (containers.size() > 1) {
                for (int i = 1; i < containers.size(); ++i) {
                    PsDependencyContainer container2 = (PsDependencyContainer)containers.get(i);
                    if (!ResolvedDependenciesTreeRootNode.haveSameDependencies(container1, container2, dependenciesByContainer)) continue;
                    if (containerWithMainArtifact.values().contains(container1)) {
                        currentGroup.add(container2);
                        continue;
                    }
                    PsDependencyContainer mainArtifactContainer1 = (PsDependencyContainer)containerWithMainArtifact.get(container1.getVariant());
                    PsDependencyContainer mainArtifactContainer2 = (PsDependencyContainer)containerWithMainArtifact.get(container2.getVariant());
                    if (mainArtifactContainer1 == null && mainArtifactContainer2 == null) {
                        currentGroup.add(container2);
                    }
                    if (mainArtifactContainer1 == null || mainArtifactContainer2 == null || !ResolvedDependenciesTreeRootNode.haveSameDependencies(mainArtifactContainer1, mainArtifactContainer2, dependenciesByContainer)) continue;
                    currentGroup.add(container2);
                }
            }
            containerGroups.add(currentGroup);
            containers.removeAll(currentGroup);
            currentGroup = Lists.newArrayList();
        }
        HashMap dependenciesByContainers = Maps.newHashMap();
        for (List group : containerGroups) {
            PsDependencyContainer container = (PsDependencyContainer)group.get(0);
            dependenciesByContainers.put(group, dependenciesByContainer.get(container));
        }
        HashMap hashMap = dependenciesByContainers;
        if (hashMap == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    private static boolean haveSameDependencies(@NotNull PsDependencyContainer c1, @NotNull PsDependencyContainer c2, @NotNull Map<PsDependencyContainer, List<PsDependency>> dependenciesByContainer) {
        if (c1 == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(8);
        }
        if (c2 == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(9);
        }
        if (dependenciesByContainer == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(10);
        }
        if (c1.getArtifact().equals(c2.getArtifact())) {
            List<PsDependency> d1 = dependenciesByContainer.get(c1);
            List<PsDependency> d2 = dependenciesByContainer.get(c2);
            return d1.equals(d2);
        }
        return false;
    }

    @NotNull
    private static List<PsAndroidArtifact> extractArtifacts(@NotNull List<PsDependencyContainer> containers, @NotNull Map<String, PsVariant> variantsByName) {
        if (containers == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(11);
        }
        if (variantsByName == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(12);
        }
        ArrayList groupArtifacts = Lists.newArrayList();
        for (PsDependencyContainer container : containers) {
            PsAndroidArtifact foundArtifact = ResolvedDependenciesTreeRootNode.extractArtifact(container, variantsByName);
            groupArtifacts.add(foundArtifact);
        }
        ArrayList arrayList = groupArtifacts;
        if (arrayList == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    private static PsAndroidArtifact extractArtifact(@NotNull PsDependencyContainer container, @NotNull Map<String, PsVariant> variantsByName) {
        if (container == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(14);
        }
        if (variantsByName == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(15);
        }
        PsVariant variant = variantsByName.get(container.getVariant());
        assert (variant != null);
        PsAndroidArtifact artifact = variant.findArtifact(container.getArtifact());
        assert (artifact != null);
        return artifact;
    }

    @Nullable
    private AndroidArtifactNode createArtifactNode(@NotNull List<PsAndroidArtifact> artifacts, @NotNull List<PsDependency> dependencies2, @Nullable AndroidArtifactNode mainArtifactNode) {
        if (artifacts == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(16);
        }
        if (dependencies2 == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(17);
        }
        if (!dependencies2.isEmpty() || mainArtifactNode != null) {
            AndroidArtifactNode artifactNode = new AndroidArtifactNode((AbstractPsNode)this, artifacts);
            ResolvedDependenciesTreeRootNode.populate(artifactNode, dependencies2, mainArtifactNode);
            return artifactNode;
        }
        return null;
    }

    @NotNull
    private List<? extends AndroidArtifactNode> createChildren(@NotNull PsAndroidModule module, @NotNull Map<String, PsVariant> variantsByName) {
        if (module == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(18);
        }
        if (variantsByName == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(19);
        }
        ArrayList childrenNodes = Lists.newArrayList();
        HashMap dependenciesByVariantAndArtifact = Maps.newHashMap();
        module.forEachDependency(dependency -> {
            if (!dependency.isDeclared()) {
                return;
            }
            for (PsDependencyContainer container : dependency.getContainers()) {
                List artifactDependencies;
                Map dependenciesByArtifact = (Map)dependenciesByVariantAndArtifact.get(container.getVariant());
                if (dependenciesByArtifact == null) {
                    dependenciesByArtifact = Maps.newHashMap();
                    dependenciesByVariantAndArtifact.put(container.getVariant(), dependenciesByArtifact);
                }
                if ((artifactDependencies = (List)dependenciesByArtifact.get(container.getArtifact())) == null) {
                    artifactDependencies = Lists.newArrayList();
                    dependenciesByArtifact.put(container.getArtifact(), artifactDependencies);
                }
                artifactDependencies.add(dependency);
            }
        });
        ArrayList variantNames = Lists.newArrayList(dependenciesByVariantAndArtifact.keySet());
        Collections.sort(variantNames);
        for (String variantName : variantNames) {
            PsVariant variant = variantsByName.get(variantName);
            Map dependenciesByArtifact = (Map)dependenciesByVariantAndArtifact.get(variantName);
            if (dependenciesByArtifact == null) continue;
            ArrayList artifactNames = Lists.newArrayList(dependenciesByArtifact.keySet());
            Collections.sort(artifactNames, ArtifactComparator.byName());
            for (String artifactName : artifactNames) {
                AndroidArtifactNode artifactNode;
                PsAndroidArtifact mainArtifact;
                PsAndroidArtifact artifact = variant.findArtifact(artifactName);
                assert (artifact != null);
                AndroidArtifactNode mainArtifactNode = null;
                String mainArtifactName = "_main_";
                if (!mainArtifactName.equals(artifactName) && (mainArtifact = variant.findArtifact(mainArtifactName)) != null) {
                    List<PsDependency> artifactDependencies = (List<PsDependency>)dependenciesByArtifact.get(mainArtifactName);
                    if (artifactDependencies == null) {
                        artifactDependencies = Collections.emptyList();
                    }
                    mainArtifactNode = this.createArtifactNode(mainArtifact, artifactDependencies, null);
                }
                if ((artifactNode = this.createArtifactNode(artifact, (List<PsDependency>)((List)dependenciesByArtifact.get(artifactName)), mainArtifactNode)) == null) continue;
                childrenNodes.add(artifactNode);
            }
        }
        ArrayList arrayList = childrenNodes;
        if (arrayList == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Nullable
    private AndroidArtifactNode createArtifactNode(@NotNull PsAndroidArtifact artifact, @NotNull List<PsDependency> dependencies2, @Nullable AndroidArtifactNode mainArtifactNode) {
        if (artifact == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(21);
        }
        if (dependencies2 == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(22);
        }
        if (!dependencies2.isEmpty() || mainArtifactNode != null) {
            AndroidArtifactNode artifactNode = new AndroidArtifactNode((AbstractPsNode)this, artifact);
            ResolvedDependenciesTreeRootNode.populate(artifactNode, dependencies2, mainArtifactNode);
            return artifactNode;
        }
        return null;
    }

    private static void populate(@NotNull AndroidArtifactNode artifactNode, @NotNull List<PsDependency> dependencies2, @Nullable AndroidArtifactNode mainArtifactNode) {
        if (artifactNode == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(23);
        }
        if (dependencies2 == null) {
            ResolvedDependenciesTreeRootNode.$$$reportNull$$$0(24);
        }
        List<AbstractPsModelNode<?>> children = DependencyNodes.createNodesFor(artifactNode, dependencies2);
        if (mainArtifactNode != null) {
            children.add(0, mainArtifactNode);
        }
        artifactNode.setChildren(children);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/treeview/ResolvedDependenciesTreeRootNode";
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantsByName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesByContainer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containers";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/treeview/ResolvedDependenciesTreeRootNode";
                break;
            }
            case 1: 
            case 2: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupedChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "groupDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 20: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createGroupedChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "groupDependencies";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "haveSameDependencies";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractArtifacts";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractArtifact";
                break;
            }
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactNode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createChildren";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

