/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.collect.Maps;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class Projects {
    private static final Key<Boolean> SYNC_REQUESTED_DURING_BUILD = Key.create((String)"project.sync.requested.during.build");
    private static final Key<Map<String, GradleVersion>> PLUGIN_VERSIONS_BY_MODULE = Key.create((String)"project.plugin.versions.by.module");

    private Projects() {
    }

    @NotNull
    public static File getBaseDirPath(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(0);
        }
        String basePath = project.getBasePath();
        assert (basePath != null);
        File file = new File(FileUtil.toCanonicalPath((String)basePath));
        if (file == null) {
            Projects.$$$reportNull$$$0(1);
        }
        return file;
    }

    public static void executeProjectChanges(@NotNull Project project, @NotNull Runnable changes) {
        if (project == null) {
            Projects.$$$reportNull$$$0(2);
        }
        if (changes == null) {
            Projects.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            if (!project.isDisposed()) {
                changes.run();
            }
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                Projects.$$$reportNull$$$0(23);
            }
            if (changes == null) {
                Projects.$$$reportNull$$$0(24);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    Projects.$$$reportNull$$$0(25);
                }
                if (changes == null) {
                    Projects.$$$reportNull$$$0(26);
                }
                if (!project.isDisposed()) {
                    ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
                }
            });
        });
    }

    public static void open(@NotNull Project project) {
        boolean fullScreen;
        IdeFocusManager instance;
        IdeFrame lastFocusedFrame;
        if (project == null) {
            Projects.$$$reportNull$$$0(4);
        }
        ProjectUtil.updateLastProjectLocation((String)project.getBasePath());
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
            project.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
        }
        ProjectManagerEx.getInstanceEx().openProject(project);
    }

    public static boolean isOfflineBuildModeEnabled(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(5);
        }
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    @Nullable
    public static AndroidModel getAndroidModel(@NotNull Module module) {
        AndroidFacet androidFacet;
        if (module == null) {
            Projects.$$$reportNull$$$0(6);
        }
        return (androidFacet = AndroidFacet.getInstance(module)) != null ? androidFacet.getAndroidModel() : null;
    }

    @NotNull
    public static Module[] getModulesToBuildFromSelection(@NotNull Project project, @Nullable DataContext dataContext) {
        Module[] modules;
        if (project == null) {
            Projects.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)project);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                if (Module.EMPTY_ARRAY == null) {
                    Projects.$$$reportNull$$$0(8);
                }
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && Projects.isProjectModule(modules[0])) {
                Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
                if (moduleArray == null) {
                    Projects.$$$reportNull$$$0(9);
                }
                return moduleArray;
            }
            if (modules == null) {
                Projects.$$$reportNull$$$0(10);
            }
            return modules;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            Module[] moduleArray;
            if (Projects.isProjectModule(module)) {
                moduleArray = ModuleManager.getInstance((Project)project).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module;
            }
            if (moduleArray == null) {
                Projects.$$$reportNull$$$0(11);
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            Projects.$$$reportNull$$$0(12);
        }
        return Module.EMPTY_ARRAY;
    }

    public static boolean isProjectModule(@NotNull Module module) {
        File moduleRootFolderPath;
        if (module == null) {
            Projects.$$$reportNull$$$0(13);
        }
        if ((moduleRootFolderPath = Projects.findModuleRootFolderPath(module)) == null) {
            return false;
        }
        String basePath = module.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootFolderPath, (File)new File(basePath)) && !GradleFacet.isAppliedTo(module);
    }

    @Nullable
    public static File findModuleRootFolderPath(@NotNull Module module) {
        if (module == null) {
            Projects.$$$reportNull$$$0(14);
        }
        File moduleFilePath = FilePaths.toSystemDependentPath(module.getModuleFilePath());
        return moduleFilePath.getParentFile();
    }

    @Deprecated
    public static boolean isBuildWithGradle(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(15);
        }
        return GradleProjectInfo.getInstance(project).isBuildWithGradle();
    }

    public static boolean isIdeaAndroidModule(@NotNull Module module) {
        if (module == null) {
            Projects.$$$reportNull$$$0(16);
        }
        if (GradleFacet.getInstance(module) != null || JavaFacet.getInstance(module) != null) {
            return true;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        return androidFacet != null && androidFacet.requiresAndroidModel();
    }

    public static boolean isGradleProjectModule(@NotNull Module module) {
        if (module == null) {
            Projects.$$$reportNull$$$0(17);
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.requiresAndroidModel() && GradleFacet.isAppliedTo(module)) {
            File moduleFilePath = FilePaths.toSystemDependentPath(module.getModuleFilePath());
            File moduleRootDirPath = moduleFilePath.getParentFile();
            return FileUtil.pathsEqual((String)moduleRootDirPath.getPath(), (String)module.getProject().getBasePath());
        }
        return !GradleFacet.isAppliedTo(module);
    }

    public static boolean canImportAsGradleProject(@NotNull VirtualFile importSource) {
        VirtualFile target;
        if (importSource == null) {
            Projects.$$$reportNull$$$0(18);
        }
        return (target = ProjectImportUtil.findImportTarget(importSource)) != null && "gradle".equals(target.getExtension());
    }

    public static void setSyncRequestedDuringBuild(@NotNull Project project, @Nullable Boolean value) {
        if (project == null) {
            Projects.$$$reportNull$$$0(19);
        }
        project.putUserData(SYNC_REQUESTED_DURING_BUILD, (Object)value);
    }

    public static boolean isSyncRequestedDuringBuild(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(20);
        }
        return (Boolean)SYNC_REQUESTED_DURING_BUILD.get((UserDataHolder)project, (Object)false);
    }

    public static void storePluginVersionsPerModule(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(21);
        }
        HashMap pluginVersionsPerModule = Maps.newHashMap();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GradleVersion modelVersion;
            GradleFacet facet;
            AndroidModuleModel model = AndroidModuleModel.get(module);
            if (model == null || (facet = GradleFacet.getInstance(module)) == null || (modelVersion = model.getModelVersion()) == null) continue;
            pluginVersionsPerModule.put(((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH, modelVersion);
        }
        project.putUserData(PLUGIN_VERSIONS_BY_MODULE, (Object)pluginVersionsPerModule);
    }

    @Nullable
    public static Map<String, GradleVersion> getPluginVersionsPerModule(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(22);
        }
        return (Map)project.getUserData(PLUGIN_VERSIONS_BY_MODULE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/Projects";
                break;
            }
            case 3: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/Projects";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirPath";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToBuildFromSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDirPath";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeProjectChanges";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOfflineBuildModeEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidModel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModulesToBuildFromSelection";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isProjectModule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findModuleRootFolderPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isBuildWithGradle";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isIdeaAndroidModule";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isGradleProjectModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canImportAsGradleProject";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setSyncRequestedDuringBuild";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSyncRequestedDuringBuild";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "storePluginVersionsPerModule";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginVersionsPerModule";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeProjectChanges$1";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

