/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;

public class NavigationInspectorProvider
implements InspectorProvider {
    private static final String[] NAVIGATION_PROPERTIES = new String[]{"name", "id", "label", "navType"};
    private final Map<String, InspectorComponent> myInspectors = new HashMap<String, InspectorComponent>();

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            NavigationInspectorProvider.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            NavigationInspectorProvider.$$$reportNull$$$0(1);
        }
        if (propertiesManager == null) {
            NavigationInspectorProvider.$$$reportNull$$$0(2);
        }
        if (components.size() != 1) {
            return false;
        }
        XmlTag tag = components.get(0).getTag();
        NavigationSchema schema = NavigationSchema.getOrCreateSchema(propertiesManager.getFacet());
        if (schema.getDestinationClassByTag(tag.getName()) == null) {
            return false;
        }
        String tagName = tag.getName();
        if (this.myInspectors.containsKey(tagName)) {
            return true;
        }
        this.myInspectors.put(tagName, new NavigationInspectorComponent(tagName, properties, propertiesManager));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            NavigationInspectorProvider.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            NavigationInspectorProvider.$$$reportNull$$$0(4);
        }
        if (propertiesManager == null) {
            NavigationInspectorProvider.$$$reportNull$$$0(5);
        }
        String tagName = components.get(0).getTagName();
        InspectorComponent inspector = this.myInspectors.get(tagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        InspectorComponent inspectorComponent = inspector;
        if (inspectorComponent == null) {
            NavigationInspectorProvider.$$$reportNull$$$0(6);
        }
        return inspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myInspectors.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/property/inspector/NavigationInspectorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/property/inspector/NavigationInspectorProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomInspector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomInspector";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NavigationInspectorComponent
    implements InspectorComponent {
        private final String myComponentName;
        private final List<NlComponentEditor> myEditors;

        public NavigationInspectorComponent(@NotNull String tagName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (tagName == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(1);
            }
            if (propertiesManager == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(2);
            }
            this.myComponentName = tagName.substring(tagName.lastIndexOf(46) + 1);
            this.myEditors = new ArrayList<NlComponentEditor>(NAVIGATION_PROPERTIES.length);
            this.createEditors(properties, propertiesManager);
        }

        private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (properties == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(3);
            }
            if (propertiesManager == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(4);
            }
            for (String propertyName : NAVIGATION_PROPERTIES) {
                NlProperty property = properties.get(propertyName);
                if (property == null) continue;
                NlComponentEditor editor = propertiesManager.getPropertyEditors().create(property);
                editor.setProperty(property);
                this.myEditors.add(editor);
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(5);
            }
            if (properties == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(6);
            }
            if (propertiesManager == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(7);
            }
            this.myEditors.clear();
            this.createEditors(properties, propertiesManager);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            List<NlComponentEditor> list = this.myEditors;
            if (list == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(8);
            }
            return list;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(9);
            }
            this.refresh();
            inspector.addTitle(this.myComponentName);
            for (NlComponentEditor editor : this.myEditors) {
                NlProperty property = editor.getProperty();
                String propertyName = property.getName();
                JLabel label = inspector.addComponent(propertyName, property.getTooltipText(), editor.getComponent());
                editor.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            this.myEditors.forEach(NlComponentEditor::refresh);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertiesManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/naveditor/property/inspector/NavigationInspectorProvider$NavigationInspectorComponent";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/naveditor/property/inspector/NavigationInspectorProvider$NavigationInspectorComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createEditors";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProperties";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "attachToInspector";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

