/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.scene.draw.DrawAction;
import com.google.common.collect.ImmutableList;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionTarget
extends BaseTarget {
    private Rectangle mySourceRect;
    private Rectangle myDestRect;
    private final NlComponent myNlComponent;
    private final SceneComponent myDestination;

    public ActionTarget(@NotNull SceneComponent component2, @NotNull SceneComponent destination, @NotNull NlComponent actionComponent) {
        if (component2 == null) {
            ActionTarget.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            ActionTarget.$$$reportNull$$$0(1);
        }
        if (actionComponent == null) {
            ActionTarget.$$$reportNull$$$0(2);
        }
        this.setComponent(component2);
        this.myNlComponent = actionComponent;
        this.myDestination = destination;
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        this.myNlComponent.getModel().getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)this.myNlComponent));
    }

    @Override
    public int getPreferenceLevel() {
        return 0;
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int l, int t, int r, int b) {
        if (context == null) {
            ActionTarget.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            ActionTarget.$$$reportNull$$$0(4);
        }
        if (sceneContext == null) {
            ActionTarget.$$$reportNull$$$0(5);
        }
        Rectangle sourceRect = Coordinates.getSwingRectDip(sceneContext, this.getComponent().fillRect(null));
        String targetId = NlComponent.stripId(this.myNlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "destination"));
        if (targetId == null) {
            return;
        }
        this.myDestRect = Coordinates.getSwingRectDip(sceneContext, this.myDestination.fillRect(null));
        this.mySourceRect = sourceRect;
        boolean selected = this.getComponent().getScene().getSelection().contains(this.myNlComponent);
        DrawAction.buildDisplayList(list, ConnectionType.NORMAL, sourceRect, this.myDestRect, selected ? DrawAction.DrawMode.SELECTED : DrawAction.DrawMode.NORMAL);
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker) {
        if (transform == null) {
            ActionTarget.$$$reportNull$$$0(6);
        }
        if (picker == null) {
            ActionTarget.$$$reportNull$$$0(7);
        }
        if (this.mySourceRect == null || this.myDestRect == null) {
            return;
        }
        CurvePoints points = ActionTarget.getCurvePoints(this.mySourceRect, this.myDestRect);
        picker.addCurveTo(this, 5, points.p1.x, points.p1.y, points.p2.x, points.p2.y, points.p3.x, points.p3.y, points.p4.x, points.p4.y);
    }

    @NotNull
    public static CurvePoints getCurvePoints(@NotNull Rectangle source, @NotNull Rectangle dest) {
        if (source == null) {
            ActionTarget.$$$reportNull$$$0(8);
        }
        if (dest == null) {
            ActionTarget.$$$reportNull$$$0(9);
        }
        ConnectionDirection sourceDirection = ConnectionDirection.RIGHT;
        ConnectionDirection destDirection = ConnectionDirection.LEFT;
        int startx = ActionTarget.getConnectionX(sourceDirection, source);
        int starty = ActionTarget.getConnectionY(sourceDirection, source);
        int endx = ActionTarget.getConnectionX(destDirection, dest);
        int endy = ActionTarget.getConnectionY(destDirection, dest);
        int dx = ActionTarget.getDestinationDx(destDirection);
        int dy = ActionTarget.getDestinationDy(destDirection);
        int scale_source = 100;
        int scale_dest = 100;
        CurvePoints result = new CurvePoints();
        result.dir = destDirection;
        result.p1 = new Point(startx, starty);
        result.p2 = new Point(startx + scale_source * sourceDirection.getDeltaX(), starty + scale_source * sourceDirection.getDeltaY());
        result.p3 = new Point(endx + dx + scale_dest * destDirection.getDeltaX(), endy + dy + scale_dest * destDirection.getDeltaY());
        result.p4 = new Point(endx + dx, endy + dy);
        CurvePoints curvePoints = result;
        if (curvePoints == null) {
            ActionTarget.$$$reportNull$$$0(10);
        }
        return curvePoints;
    }

    private static int getConnectionX(@NotNull ConnectionDirection side, @NotNull Rectangle rect) {
        if (side == null) {
            ActionTarget.$$$reportNull$$$0(11);
        }
        if (rect == null) {
            ActionTarget.$$$reportNull$$$0(12);
        }
        return rect.x + (1 + side.getDeltaX()) * rect.width / 2;
    }

    private static int getConnectionY(@NotNull ConnectionDirection side, @NotNull Rectangle rect) {
        if (side == null) {
            ActionTarget.$$$reportNull$$$0(13);
        }
        if (rect == null) {
            ActionTarget.$$$reportNull$$$0(14);
        }
        return rect.y + (1 + side.getDeltaY()) * rect.height / 2;
    }

    public static int getDestinationDx(@NotNull ConnectionDirection side) {
        if (side == null) {
            ActionTarget.$$$reportNull$$$0(15);
        }
        return side.getDeltaX() * 6;
    }

    public static int getDestinationDy(@NotNull ConnectionDirection side) {
        if (side == null) {
            ActionTarget.$$$reportNull$$$0(16);
        }
        return side.getDeltaY() * 6;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/targets/ActionTarget";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/targets/ActionTarget";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurvePoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "layout";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addHit";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCurvePoints";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionX";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionY";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationDx";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationDy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ConnectionDirection {
        LEFT(-1, 0),
        RIGHT(1, 0),
        TOP(0, -1),
        BOTTOM(0, 1);

        private ConnectionDirection myOpposite;
        private final int myDeltaX;
        private final int myDeltaY;

        private ConnectionDirection(int deltaX, int deltaY) {
            this.myDeltaX = deltaX;
            this.myDeltaY = deltaY;
        }

        public int getDeltaX() {
            return this.myDeltaX;
        }

        public int getDeltaY() {
            return this.myDeltaY;
        }

        public ConnectionDirection getOpposite() {
            return this.myOpposite;
        }

        static {
            ConnectionDirection.LEFT.myOpposite = RIGHT;
            ConnectionDirection.RIGHT.myOpposite = LEFT;
            ConnectionDirection.TOP.myOpposite = BOTTOM;
            ConnectionDirection.BOTTOM.myOpposite = TOP;
        }
    }

    public static enum ConnectionType {
        NORMAL,
        SELF;

    }

    public static class CurvePoints {
        public Point p1;
        public Point p2;
        public Point p3;
        public Point p4;
        public ConnectionDirection dir;
    }
}

