/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.res.AppResourceRepository;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class AssetStudioUtils {
    @NotNull
    public static BufferedImage createDummyImage() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        if (bufferedImage == null) {
            AssetStudioUtils.$$$reportNull$$$0(0);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage trim(@NotNull BufferedImage image) {
        BufferedImage cropped;
        if (image == null) {
            AssetStudioUtils.$$$reportNull$$$0(1);
        }
        BufferedImage bufferedImage = (cropped = ImageUtils.cropBlank((BufferedImage)image, null, (int)2)) != null ? cropped : image;
        if (bufferedImage == null) {
            AssetStudioUtils.$$$reportNull$$$0(2);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage pad(@NotNull BufferedImage image, int paddingPercent) {
        if (image == null) {
            AssetStudioUtils.$$$reportNull$$$0(3);
        }
        if (image.getWidth() <= 1 || image.getHeight() <= 1) {
            BufferedImage bufferedImage = image;
            if (bufferedImage == null) {
                AssetStudioUtils.$$$reportNull$$$0(4);
            }
            return bufferedImage;
        }
        if (paddingPercent > 100) {
            paddingPercent = 100;
        }
        int largerSide = Math.max(image.getWidth(), image.getHeight());
        int smallerSide = Math.min(image.getWidth(), image.getHeight());
        int padding = largerSide * paddingPercent / 100;
        padding = Math.max(-(smallerSide / 2 - 1), padding);
        BufferedImage bufferedImage = AssetUtil.paddedImage((BufferedImage)image, (int)padding);
        if (bufferedImage == null) {
            AssetStudioUtils.$$$reportNull$$$0(5);
        }
        return bufferedImage;
    }

    public static boolean resourceExists(@NotNull AndroidProjectPaths paths, @NotNull ResourceFolderType resourceType, @NotNull String name) {
        File resDir;
        if (paths == null) {
            AssetStudioUtils.$$$reportNull$$$0(6);
        }
        if (resourceType == null) {
            AssetStudioUtils.$$$reportNull$$$0(7);
        }
        if (name == null) {
            AssetStudioUtils.$$$reportNull$$$0(8);
        }
        if ((resDir = paths.getResDirectory()) == null) {
            return false;
        }
        File[] resTypes = resDir.listFiles();
        if (resTypes == null) {
            return false;
        }
        for (File resTypeDir : resTypes) {
            File[] files;
            if (!resTypeDir.isDirectory() || !resourceType.equals((Object)ResourceFolderType.getFolderType((String)resTypeDir.getName())) || (files = resTypeDir.listFiles()) == null) continue;
            for (File f : files) {
                if (!FileUtil.getNameWithoutExtension((File)f).equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean resourceExists(@NotNull AndroidFacet facet, @NotNull ResourceType resourceType, @NotNull String name) {
        if (facet == null) {
            AssetStudioUtils.$$$reportNull$$$0(9);
        }
        if (resourceType == null) {
            AssetStudioUtils.$$$reportNull$$$0(10);
        }
        if (name == null) {
            AssetStudioUtils.$$$reportNull$$$0(11);
        }
        AppResourceRepository repository = AppResourceRepository.getOrCreateInstance(facet);
        return repository.hasResourceItem(resourceType, name);
    }

    private AssetStudioUtils() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/AssetStudioUtils";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyImage";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/AssetStudioUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "pad";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pad";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resourceExists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

