/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;

public class TabIconGenerator
extends GraphicGenerator {
    @Override
    public BufferedImage generate(GraphicGeneratorContext context, GraphicGenerator.Options options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        BufferedImage sourceImage = TabIconGenerator.getTrimmedAndPaddedImage(options);
        if (sourceImage == null) {
            sourceImage = AssetStudioUtils.createDummyImage();
        }
        Rectangle iconSizeMdpi = new Rectangle(0, 0, 32, 32);
        Rectangle targetRectMdpi = new Rectangle(2, 2, 28, 28);
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        Rectangle imageRect = AssetUtil.scaleRectangle((Rectangle)iconSizeMdpi, (float)scaleFactor);
        Rectangle targetRect = AssetUtil.scaleRectangle((Rectangle)targetRectMdpi, (float)scaleFactor);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g2 = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCenterInside((Graphics2D)g2, (BufferedImage)sourceImage, (Rectangle)targetRect);
        TabOptions tabOptions = (TabOptions)options;
        if (tabOptions.selected) {
            if (tabOptions.oldStyle) {
                AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new GradientPaint(0.0f, 0.0f, new Color(0xA3A3A3), 0.0f, imageRect.height, new Color(0x787878))), new AssetUtil.ShadowEffect(0.0, (double)(2.0f * scaleFactor), (double)(2.0f * scaleFactor), Color.BLACK, 0.2, true), new AssetUtil.ShadowEffect(0.0, 1.0, 0.0, Color.BLACK, 0.35, true), new AssetUtil.ShadowEffect(0.0, -1.0, 0.0, Color.WHITE, 0.35, true)});
            } else {
                AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)Color.WHITE), new AssetUtil.ShadowEffect(0.0, 0.0, (double)(3.0f * scaleFactor), Color.BLACK, 0.25, false)});
            }
        } else if (tabOptions.oldStyle) {
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new GradientPaint(0.0f, 0.25f * (float)imageRect.height, new Color(0xF9F9F9), 0.0f, imageRect.height, new Color(0xDFDFDF))), new AssetUtil.ShadowEffect(0.0, (double)(2.0f * scaleFactor), (double)(2.0f * scaleFactor), Color.BLACK, 0.1, true), new AssetUtil.ShadowEffect(0.0, 1.0, 0.0, Color.BLACK, 0.35, true), new AssetUtil.ShadowEffect(0.0, -1.0, 0.0, Color.WHITE, 0.35, true)});
        } else {
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(0x808080))});
        }
        g.dispose();
        g2.dispose();
        return outImage;
    }

    @Override
    public void generate(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, GraphicGenerator.Options baseOptions, String name) {
        boolean generateOldStyle;
        TabOptions options = (TabOptions)baseOptions;
        options.selected = true;
        options.oldStyle = false;
        String selectedLabelV5 = "Selected (v5+)";
        String unselectedLabelV5 = "Unselected (v5+)";
        String selectedLabel = "Selected";
        String unselectedLabel = "Unselected";
        boolean bl = generateOldStyle = options.minSdk < 5;
        if (generateOldStyle) {
            options.oldStyle = true;
            options.selected = true;
            super.generate(selectedLabel, categoryMap, context, options, name);
            options.selected = false;
            super.generate(unselectedLabel, categoryMap, context, options, name);
        }
        options.oldStyle = false;
        options.selected = true;
        super.generate(generateOldStyle ? unselectedLabelV5 : unselectedLabel, categoryMap, context, options, name);
        options.selected = false;
        super.generate(generateOldStyle ? selectedLabelV5 : selectedLabel, categoryMap, context, options, name);
    }

    @Override
    protected String getIconFolder(GraphicGenerator.Options options) {
        String folder = super.getIconFolder(options);
        TabOptions tabOptions = (TabOptions)options;
        if (tabOptions.oldStyle || options.minSdk >= 5) {
            return folder;
        }
        return folder + "-v5";
    }

    @Override
    protected String getIconName(GraphicGenerator.Options options, String name) {
        TabOptions tabOptions = (TabOptions)options;
        if (tabOptions.selected) {
            return name + "_selected.png";
        }
        return name + "_unselected.png";
    }

    public static class TabOptions
    extends GraphicGenerator.Options {
        public boolean oldStyle;
        public boolean selected = true;
    }
}

