/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.rendering.GutterIconFactory;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconCache {
    private static final Logger LOG = Logger.getInstance(GutterIconCache.class);
    private static final Icon NONE = AndroidIcons.Android;
    static final int MAX_WIDTH = JBUI.scale((int)16);
    static final int MAX_HEIGHT = JBUI.scale((int)16);
    private static final GutterIconCache ourInstance = new GutterIconCache();
    private Map<String, Icon> myThumbnailCache = Maps.newHashMap();
    private Map<String, Long> myTimestampCache = Maps.newHashMap();
    private boolean myRetina;

    @NotNull
    public static GutterIconCache getInstance() {
        GutterIconCache gutterIconCache = ourInstance;
        if (gutterIconCache == null) {
            GutterIconCache.$$$reportNull$$$0(0);
        }
        return gutterIconCache;
    }

    boolean isIconUpToDate(@NotNull String path) {
        VirtualFile file;
        if (path == null) {
            GutterIconCache.$$$reportNull$$$0(1);
        }
        if (this.myTimestampCache.containsKey(path) && (file = LocalFileSystem.getInstance().findFileByPath(path)) != null) {
            return this.myTimestampCache.get(path).longValue() == file.getTimeStamp() && !FileDocumentManager.getInstance().isFileModified(file);
        }
        return false;
    }

    @Nullable
    public Icon getIcon(@NotNull String path, @Nullable ResourceResolver resolver) {
        Icon myIcon;
        boolean isRetina;
        if (path == null) {
            GutterIconCache.$$$reportNull$$$0(2);
        }
        if (this.myRetina != (isRetina = UIUtil.isRetina())) {
            this.myRetina = isRetina;
            this.myThumbnailCache.clear();
        }
        if ((myIcon = this.myThumbnailCache.get(path)) == null || !this.isIconUpToDate(path)) {
            myIcon = GutterIconFactory.createIcon(path, resolver, MAX_WIDTH, MAX_HEIGHT);
            if (myIcon == null) {
                myIcon = NONE;
            }
            this.myThumbnailCache.put(path, myIcon);
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            if (file != null) {
                this.myTimestampCache.put(path, file.getTimeStamp());
            }
        }
        return myIcon != NONE ? myIcon : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/GutterIconCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/GutterIconCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIconUpToDate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

