/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.level2.Library;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.res.AppResourceRepository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetRepositoryImpl
extends AssetRepository
implements Disposable {
    private AndroidFacet myFacet;

    public AssetRepositoryImpl(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(0);
        }
        this.myFacet = facet;
        Disposer.register((Disposable)this.myFacet, (Disposable)this);
    }

    public boolean isSupported() {
        return true;
    }

    @Nullable
    public InputStream openAsset(@NotNull String path, int mode) throws IOException {
        if (path == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(1);
        }
        assert (this.myFacet != null);
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getAssetsDirectories, Library::getAssetsFolder).map(assetDir -> {
            if (path == null) {
                AssetRepositoryImpl.$$$reportNull$$$0(8);
            }
            return assetDir.findFileByRelativePath(path);
        }).map(assetDir -> {
            if (assetDir == null) {
                return null;
            }
            try {
                return assetDir.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static boolean isCachedFontFile(@NotNull VirtualFile file) {
        File fontCachePathFile;
        if (file == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(2);
        }
        if ((fontCachePathFile = DownloadableFontCacheService.getInstance().getFontPath()) == null) {
            return false;
        }
        VirtualFile fontCachePath = VirtualFileManager.getInstance().findFileByUrl("file://" + fontCachePathFile.getAbsolutePath());
        if (fontCachePath == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)fontCachePath, (VirtualFile)file, (boolean)true);
    }

    @Nullable
    public InputStream openNonAsset(int cookie, @NotNull String path, int mode) throws IOException {
        if (path == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(3);
        }
        assert (this.myFacet != null);
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl("file://" + path);
        if (file == null) {
            return null;
        }
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getResDirectories, Library::getResFolder).filter(resDir -> VfsUtilCore.isAncestor((VirtualFile)resDir, (VirtualFile)file, (boolean)true)).map(resDir -> {
            try {
                return file.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).findAny().orElseGet(() -> {
            if (AssetRepositoryImpl.isCachedFontFile(file)) {
                try {
                    return file.getInputStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        });
    }

    @NotNull
    private static Stream<VirtualFile> getDirectories(@NotNull AndroidFacet facet, @NotNull Function<IdeaSourceProvider, Collection<VirtualFile>> sourceMapper, @NotNull Function<Library, String> aarMapper) {
        if (facet == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(4);
        }
        if (sourceMapper == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(5);
        }
        if (aarMapper == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(6);
        }
        Stream dirsFromSources = Stream.concat(Stream.of(facet), AndroidUtils.getAllAndroidDependencies(facet.getModule(), true).stream()).flatMap(f -> IdeaSourceProvider.getAllIdeaSourceProviders(f).stream()).distinct().map(sourceMapper).flatMap(Collection::stream);
        VirtualFileManager manager = VirtualFileManager.getInstance();
        Stream<VirtualFile> dirsFromAars = AppResourceRepository.findAarLibraries(facet).stream().map(aarMapper).map(path -> manager.findFileByUrl("file://" + path)).filter(Objects::nonNull);
        Stream<VirtualFile> stream = Stream.concat(dirsFromSources, dirsFromAars);
        if (stream == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(7);
        }
        return stream;
    }

    public void dispose() {
        this.myFacet = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceMapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarMapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/AssetRepositoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/AssetRepositoryImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openAsset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCachedFontFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openNonAsset";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openAsset$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

