/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.common.editor.NlEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.WeakHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LayoutNavigationManager
implements Disposable {
    private static final WeakHashMap<VirtualFile, VirtualFile> ourNavigationCache = new WeakHashMap();
    private final Project myProject;

    public VirtualFile get(VirtualFile file) {
        return (VirtualFile)ourNavigationCache.get((Object)file);
    }

    private LayoutNavigationManager(@NotNull Project project) {
        if (project == null) {
            LayoutNavigationManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/editor/LayoutNavigationManager$1", "selectionChanged"));
            }
        });
    }

    public static LayoutNavigationManager getInstance(@NotNull Project project) {
        if (project == null) {
            LayoutNavigationManager.$$$reportNull$$$0(1);
        }
        return (LayoutNavigationManager)project.getComponent(LayoutNavigationManager.class);
    }

    public boolean pushFile(@NotNull VirtualFile source, @NotNull VirtualFile destination) {
        boolean isInDesignerMode;
        if (source == null) {
            LayoutNavigationManager.$$$reportNull$$$0(2);
        }
        if (destination == null) {
            LayoutNavigationManager.$$$reportNull$$$0(3);
        }
        ourNavigationCache.put((Object)destination, (Object)source);
        FileEditorManager manager = FileEditorManager.getInstance((Project)this.myProject);
        FileEditor sourceEditor = manager.getSelectedEditor(source);
        FileEditor destinationEditor = manager.getSelectedEditor(destination);
        if (destinationEditor == null) {
            FileEditor[] editors = manager.openFile(destination, true);
            if (editors.length == 0) {
                return false;
            }
        } else {
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.myProject, destination);
            List editors = manager.openEditor(openFileDescriptor, true);
            if (!editors.contains(destinationEditor)) {
                Logger.getInstance(LayoutNavigationManager.class).error("The editor was supposed to be already open");
                return false;
            }
        }
        manager.setSelectedEditor(destination, (isInDesignerMode = sourceEditor instanceof NlEditor) ? "android-designer2" : TextEditorProvider.getInstance().getEditorTypeId());
        return true;
    }

    public void popFile(@NotNull VirtualFile fileToPop, @NotNull VirtualFile parentFile) {
        if (fileToPop == null) {
            LayoutNavigationManager.$$$reportNull$$$0(4);
        }
        if (parentFile == null) {
            LayoutNavigationManager.$$$reportNull$$$0(5);
        }
        FileEditorManager manager = FileEditorManager.getInstance((Project)this.myProject);
        OpenFileDescriptor previousOpenFileDescriptor = new OpenFileDescriptor(this.myProject, parentFile);
        manager.openEditor(previousOpenFileDescriptor, true);
        ourNavigationCache.remove((Object)fileToPop);
    }

    public void dispose() {
        ourNavigationCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToPop";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/editor/LayoutNavigationManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "pushFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "popFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

