/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragDndTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintDragHandler
extends DragHandler {
    @Nullable
    protected SceneComponent myComponent;

    public ConstraintDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, DragType type) {
        if (editor == null) {
            ConstraintDragHandler.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            ConstraintDragHandler.$$$reportNull$$$0(1);
        }
        if (layout == null) {
            ConstraintDragHandler.$$$reportNull$$$0(2);
        }
        if (components == null) {
            ConstraintDragHandler.$$$reportNull$$$0(3);
        }
        super(editor, handler, layout, components, type);
        if (components.size() == 1) {
            NlComponent component2 = components.get(0);
            this.myComponent = new TemporarySceneComponent(layout.getScene(), component2);
            this.myComponent.setSize(editor.pxToDp(NlComponentHelperKt.getW(component2)), editor.pxToDp(NlComponentHelperKt.getH(component2)), false);
            this.myComponent.setTargetProvider((sceneComponent, isParent) -> ImmutableList.of((Object)new ConstraintDragDndTarget()), false);
            this.myComponent.setDrawState(SceneComponent.DrawState.DRAG);
            layout.addChild(this.myComponent);
        }
    }

    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        if (this.myComponent == null) {
            return;
        }
        Scene scene = ((ViewEditorImpl)this.editor).getSceneView().getScene();
        scene.needsRebuildList();
        int dx = x - this.myComponent.getDrawWidth() / 2;
        int dy = y - this.myComponent.getDrawHeight() / 2;
        for (Target target : this.myComponent.getTargets()) {
            if (!(target instanceof ConstraintDragDndTarget)) continue;
            target.mouseDown(dx, dy);
            break;
        }
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String result = super.update(x, y, modifiers);
        if (this.myComponent == null) {
            return "undefined";
        }
        Scene scene = ((ViewEditorImpl)this.editor).getSceneView().getScene();
        int dx = x - this.myComponent.getDrawWidth() / 2;
        int dy = y - this.myComponent.getDrawHeight() / 2;
        this.myComponent.setPosition(dx, dy);
        List<Target> targets = this.myComponent.getTargets();
        for (int i = 0; i < targets.size(); ++i) {
            if (!(targets.get(i) instanceof ConstraintDragDndTarget)) continue;
            ConstraintDragDndTarget target = (ConstraintDragDndTarget)targets.get(i);
            target.mouseDrag(dx, dy, targets);
            break;
        }
        scene.checkRequestLayoutStatus();
        return result;
    }

    @Override
    public void cancel() {
        Scene scene = ((ViewEditorImpl)this.editor).getSceneView().getScene();
        if (this.myComponent != null) {
            scene.removeComponent(this.myComponent);
        }
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            ConstraintDragHandler.$$$reportNull$$$0(4);
        }
        Scene scene = ((ViewEditorImpl)this.editor).getSceneView().getScene();
        if (this.myComponent != null) {
            NlComponent root = this.myComponent.getNlComponent().getRoot();
            NlWriteCommandAction.run(root, this.type.getDescription(), () -> root.ensureNamespace("app", "http://schemas.android.com/apk/res-auto"));
            int dx = this.editor.pxToDp(x) - this.myComponent.getDrawWidth() / 2;
            int dy = this.editor.pxToDp(y) - this.myComponent.getDrawHeight() / 2;
            for (Target target : this.myComponent.getTargets()) {
                if (!(target instanceof ConstraintDragDndTarget)) continue;
                ((ConstraintDragDndTarget)target).mouseRelease(dx, dy, (NlComponent)this.components.get(0));
                break;
            }
        }
        this.insertComponents(-1, insertType);
        scene.removeComponent(this.myComponent);
        scene.checkRequestLayoutStatus();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintDragHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

