/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.uibuilder.handlers.relative.ConstraintType;
import com.android.tools.lint.detector.api.LintUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyGraph {
    private static final String DEPENDENCY_FORMAT = "%1$s %2$s %3$s";
    private final Map<NlComponent, ViewData> myNodeToView = new HashMap<NlComponent, ViewData>();
    private final long myModelVersion;

    public DependencyGraph(NlComponent layout) {
        this.myModelVersion = layout.getModel().getModificationCount();
        String parentId = layout.getId();
        parentId = parentId != null ? LintUtils.stripIdPrefix((String)parentId) : "RelativeLayout";
        ViewData parentView = new ViewData(layout, parentId);
        this.myNodeToView.put(layout, parentView);
        HashMap<String, ViewData> idToView = new HashMap<String, ViewData>();
        idToView.put(parentId, parentView);
        for (NlComponent child : layout.getChildren()) {
            String id = child.getId();
            if (id != null) {
                id = LintUtils.stripIdPrefix((String)id);
            }
            ViewData view = new ViewData(child, id);
            this.myNodeToView.put(child, view);
            if (id == null) continue;
            idToView.put(id, view);
        }
        for (ViewData view : this.myNodeToView.values()) {
            for (AttributeSnapshot attribute : view.node.getAttributes()) {
                String name;
                ConstraintType type;
                if (!"http://schemas.android.com/apk/res/android".equals(attribute.namespace) || (type = ConstraintType.fromAttribute(name = attribute.name)) == null) continue;
                String value = attribute.value;
                if (type.targetParent) {
                    if (!"true".equals(value)) continue;
                    Constraint constraint = new Constraint(type, view, parentView);
                    view.dependsOn.add(constraint);
                    parentView.dependedOnBy.add(constraint);
                    continue;
                }
                String targetId = LintUtils.stripIdPrefix((String)value);
                ViewData target = (ViewData)idToView.get(targetId);
                if (target == view || target == null) continue;
                Constraint constraint = new Constraint(type, view, target);
                view.dependsOn.add(constraint);
                target.dependedOnBy.add(constraint);
            }
        }
    }

    public ViewData getView(NlComponent node) {
        return this.myNodeToView.get(node);
    }

    public Set<NlComponent> dependsOn(Collection<? extends NlComponent> nodes, boolean vertical) {
        ArrayList<ViewData> reachable = new ArrayList<ViewData>();
        HashSet<ViewData> visiting = new HashSet<ViewData>();
        for (NlComponent nlComponent : nodes) {
            ViewData view = this.myNodeToView.get(nlComponent);
            if (view == null) continue;
            this.findBackwards(view, visiting, reachable, vertical, view);
        }
        HashSet<NlComponent> dependents = new HashSet<NlComponent>(reachable.size());
        for (ViewData v : reachable) {
            dependents.add(v.node);
        }
        return dependents;
    }

    private void findBackwards(ViewData view, Set<ViewData> visiting, List<ViewData> reachable, boolean vertical, ViewData start) {
        visiting.add(view);
        reachable.add(view);
        for (Constraint constraint : view.dependedOnBy) {
            if (vertical && !constraint.type.verticalEdge || !vertical && !constraint.type.horizontalEdge) continue;
            assert (constraint.to == view);
            ViewData from = constraint.from;
            if (visiting.contains(from)) {
                List<Constraint> path = this.getPathTo(start.node, view.node, vertical);
                if (path == null) continue;
            }
            this.findBackwards(from, visiting, reachable, vertical, start);
        }
        visiting.remove(view);
    }

    @Nullable
    public List<Constraint> getPathTo(NlComponent from, NlComponent to, boolean vertical) {
        HashSet<ViewData> visiting = new HashSet<ViewData>();
        ArrayList<Constraint> path = new ArrayList<Constraint>();
        ViewData view = this.myNodeToView.get(from);
        if (view != null) {
            return DependencyGraph.findForwards(view, visiting, path, vertical, to);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static List<Constraint> findForwards(ViewData view, Set<ViewData> visiting, List<Constraint> path, boolean vertical, NlComponent target) {
        visiting.add(view);
        for (Constraint constraint : view.dependsOn) {
            if (vertical && !constraint.type.verticalEdge || !vertical && !constraint.type.horizontalEdge) continue;
            try {
                List<Constraint> chain;
                path.add(constraint);
                if (constraint.to.node == target) {
                    ArrayList<Constraint> arrayList = new ArrayList<Constraint>(path);
                    return arrayList;
                }
                assert (constraint.from == view);
                ViewData to = constraint.to;
                if (visiting.contains(to) || (chain = DependencyGraph.findForwards(to, visiting, path, vertical, target)) == null) continue;
                List<Constraint> list = chain;
                return list;
            }
            finally {
                path.remove(constraint);
            }
        }
        visiting.remove(view);
        return null;
    }

    public boolean isStale(NlComponent layout) {
        return this.myModelVersion != layout.getModel().getModificationCount();
    }

    static class Constraint {
        @NotNull
        public final ConstraintType type;
        public final ViewData from;
        public final ViewData to;

        Constraint(@NotNull ConstraintType type, @NotNull ViewData from, @NotNull ViewData to) {
            if (type == null) {
                Constraint.$$$reportNull$$$0(0);
            }
            if (from == null) {
                Constraint.$$$reportNull$$$0(1);
            }
            if (to == null) {
                Constraint.$$$reportNull$$$0(2);
            }
            this.type = type;
            this.from = from;
            this.to = to;
        }

        static String describePath(@NotNull List<Constraint> path, @Nullable String newName, @Nullable String newId) {
            if (path == null) {
                Constraint.$$$reportNull$$$0(3);
            }
            String s = "";
            for (int i = path.size() - 1; i >= 0; --i) {
                Constraint constraint = path.get(i);
                String suffix = i == path.size() - 1 ? constraint.to.id : s;
                s = String.format(DependencyGraph.DEPENDENCY_FORMAT, constraint.from.id, Constraint.stripLayoutAttributePrefix(constraint.type.name), suffix);
            }
            if (newName != null) {
                s = String.format(DependencyGraph.DEPENDENCY_FORMAT, s, Constraint.stripLayoutAttributePrefix(newName), newId != null ? LintUtils.stripIdPrefix((String)newId) : "?");
            }
            return s;
        }

        private static String stripLayoutAttributePrefix(String name) {
            if (name.startsWith("layout_")) {
                return name.substring("layout_".length());
            }
            return name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/relative/DependencyGraph$Constraint";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "describePath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ViewData {
        @NotNull
        public final NlComponent node;
        @Nullable
        public final String id;
        @NotNull
        public final List<Constraint> dependsOn;
        @NotNull
        public final List<Constraint> dependedOnBy;

        ViewData(@NotNull NlComponent node, @Nullable String id) {
            if (node == null) {
                ViewData.$$$reportNull$$$0(0);
            }
            this.dependsOn = new ArrayList<Constraint>(4);
            this.dependedOnBy = new ArrayList<Constraint>(8);
            this.node = node;
            this.id = id;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/uibuilder/handlers/relative/DependencyGraph$ViewData", "<init>"));
        }
    }
}

