/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layout3d;

import com.android.tools.idea.uibuilder.layout3d.Display3D;
import com.android.tools.idea.uibuilder.layout3d.Layout;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CheckLayout3d
extends JPanel {
    private static final boolean DEBUG_WITH_FILE = true;
    Display3D myDisplay3D = new Display3D();

    public CheckLayout3d() {
        super(new BorderLayout());
        this.add(this.myDisplay3D);
        this.myDisplay3D.addViewChangeListener(e -> this.savePref());
    }

    public static BufferedImage getTestImage() {
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File("/usr/local/google/home/hoford/phone.png"));
            return img;
        }
        catch (IOException e) {
            e.printStackTrace();
            int width = 1024;
            int height = 1920;
            img = UIUtil.createImage((int)width, (int)height, (int)1);
            int[] data = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < data.length; ++i) {
                data[i] = i % width * 255 / width << 16 | i / width * 255 / height << 8 | i >> 10;
            }
            return img;
        }
    }

    public static Layout.View getTestViews(BufferedImage img) {
        float w = img.getWidth();
        float h = img.getHeight();
        float block = w / 10.0f;
        float bottom = 398.0f;
        float button_w = 124.0f;
        float button_h = 108.0f;
        float gap = (w - button_w * 5.0f) / 6.0f;
        Layout.View v = new Layout.View(0.0f, 0.0f, w, h).addChild(new Layout.View(0.0f, 0.0f, w, 300.0f).addChild(new Layout.View(0.0f, 94.0f, w, 182.0f)), new Layout.View(gap * 1.0f + button_w * 0.0f, h - bottom, button_w, button_h), new Layout.View(gap * 2.0f + button_w * 1.0f, h - bottom, button_w, button_h), new Layout.View(gap * 3.0f + button_w * 2.0f, h - bottom, button_w, button_h), new Layout.View(gap * 4.0f + button_w * 3.0f, h - bottom, button_w, button_h), new Layout.View(gap * 5.0f + button_w * 4.0f, h - bottom, button_w, button_h));
        return v;
    }

    private void savePref() {
        Preferences prefs = Preferences.userNodeForPackage(CheckLayout3d.class);
        String ORIENTATION = "name_of_preference";
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
        Rectangle rect = topFrame.getBounds();
        prefs.put("name_of_preference", this.myDisplay3D.getOrientationString(rect));
    }

    public void loadPref() {
        Preferences prefs = Preferences.userNodeForPackage(CheckLayout3d.class);
        String ORIENTATION = "name_of_preference";
        String pref = prefs.get("name_of_preference", null);
        if (pref != null) {
            this.myDisplay3D.setup();
            Rectangle rect = this.myDisplay3D.parseOrientationString(pref);
            JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
            topFrame.setBounds(rect);
        }
    }

    public static void create(Layout.View views, BufferedImage img) {
        JFrame f = new JFrame("CheckTriangles");
        CheckLayout3d p = new CheckLayout3d();
        f.setContentPane(p);
        f.setBounds(100, 100, 512, 512);
        p.myDisplay3D.setTriData(new Layout(img, views));
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("CheckTriangles");
        CheckLayout3d p = new CheckLayout3d();
        f.setContentPane(p);
        f.setBounds(100, 100, 512, 512);
        BufferedImage img = CheckLayout3d.getTestImage();
        Layout.View views = CheckLayout3d.getTestViews(img);
        p.myDisplay3D.setTriData(new Layout(img, views));
        if (args.length < 1 || !args[0].equals("-r")) {
            p.loadPref();
        }
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

