/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.DBSCANColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ViewAndColorForm;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SimpleViewCreator
extends WidgetCreator {
    private final Rectangle mySelectionBounds;
    Rectangle myAndroidBounds;

    public SimpleViewCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            SimpleViewCreator.$$$reportNull$$$0(0);
        }
        if (model == null) {
            SimpleViewCreator.$$$reportNull$$$0(1);
        }
        if (screenView == null) {
            SimpleViewCreator.$$$reportNull$$$0(2);
        }
        if (selection == null) {
            SimpleViewCreator.$$$reportNull$$$0(3);
        }
        super(mockup, model, screenView);
        this.myAndroidBounds = new Rectangle();
        this.mySelectionBounds = selection;
        Rectangle cropping = this.getMockup().getComputedCropping();
        NlComponent component2 = this.getMockup().getComponent();
        float xScale = (float)NlComponentHelperKt.getW(component2) / (float)cropping.width;
        float yScale = (float)NlComponentHelperKt.getH(component2) / (float)cropping.height;
        this.myAndroidBounds.setBounds(Math.round(xScale * (float)this.mySelectionBounds.x), Math.round(yScale * (float)this.mySelectionBounds.y), Math.round(xScale * (float)this.mySelectionBounds.width), Math.round(yScale * (float)this.mySelectionBounds.height));
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        if ("View" == null) {
            SimpleViewCreator.$$$reportNull$$$0(4);
        }
        return "View";
    }

    protected void extractColor(@NotNull BufferedImage image, @NotNull ColorExtractor.ColorExtractorCallback callback) {
        if (image == null) {
            SimpleViewCreator.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            SimpleViewCreator.$$$reportNull$$$0(6);
        }
        Rectangle realCropping = this.getMockup().getComputedCropping();
        Rectangle selectionBounds = this.getSelectionBounds();
        BufferedImage subimage = image.getSubimage(realCropping.x + selectionBounds.x, realCropping.y + selectionBounds.y, selectionBounds.width, selectionBounds.height);
        DBSCANColorExtractor colorExtractor = new DBSCANColorExtractor(subimage, 1.3f, DBSCANColorExtractor.getMinClusterSize(subimage));
        ((ColorExtractor)colorExtractor).run(callback);
    }

    protected void extractColor(final ViewAndColorForm viewAndColorForm, BufferedImage image) {
        this.extractColor(image, new ColorExtractor.ColorExtractorCallback(){

            @Override
            public void result(Collection<ExtractedColor> rgbColors) {
                viewAndColorForm.addColors(rgbColors);
            }

            @Override
            public void progress(int progress) {
                viewAndColorForm.setProgress(progress);
            }
        });
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            SimpleViewCreator.$$$reportNull$$$0(7);
        }
        this.addLayoutEditorPositionAttribute(transaction, this.myAndroidBounds);
        this.addSizeAttributes(transaction, this.myAndroidBounds);
        this.addMockupAttributes(transaction, this.mySelectionBounds);
    }

    public Rectangle getAndroidBounds() {
        return this.myAndroidBounds;
    }

    public Rectangle getSelectionBounds() {
        return this.mySelectionBounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/creators/SimpleViewCreator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/SimpleViewCreator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidViewTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractColor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

