/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.ScoutArrange;
import com.android.tools.idea.uibuilder.scout.ScoutChainsArrange;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Scout {
    private static final String[] ourAttrsToDelete = new String[]{"padding", "paddingLeft", "paddingRight", "paddingStart", "paddingEnd", "paddingTop", "paddingBottom", "orientation"};
    private static int sMargin = 8;

    public static int getMargin() {
        return sMargin;
    }

    public static void setMargin(int margin) {
        sMargin = margin;
    }

    public static void arrangeWidgets(Arrange type, List<NlComponent> widgets, boolean applyConstraint) {
        switch (type) {
            case ChainVerticalRemove: 
            case ChainHorizontalRemove: 
            case ChainVerticalMoveUp: 
            case ChainVerticalMoveDown: 
            case ChainHorizontalMoveLeft: 
            case ChainHorizontalMoveRight: 
            case ChainInsertHorizontal: 
            case ChainInsertVertical: {
                ScoutChainsArrange.change(type, widgets);
                return;
            }
        }
        ScoutArrange.align(type, widgets, applyConstraint);
        Scout.commit(widgets, type.toString());
    }

    public static boolean chainCheck(List<NlComponent> widgets, ChainTest test) {
        return ScoutChainsArrange.chainCheck(widgets, test);
    }

    public static boolean containsOverlap(NlComponent root) {
        if (root == null) {
            return false;
        }
        if (root.getChildCount() == 0) {
            return false;
        }
        List<NlComponent> list = root.getChildren();
        int count = 0;
        Rectangle[] rec = new Rectangle[list.size()];
        for (NlComponent component2 : list) {
            rec[count] = new Rectangle();
            rec[count].x = ConstraintComponentUtilities.getDpX(component2);
            rec[count].y = ConstraintComponentUtilities.getDpY(component2);
            rec[count].width = ConstraintComponentUtilities.getDpWidth(component2);
            rec[count].height = ConstraintComponentUtilities.getDpHeight(component2);
            ++count;
        }
        for (int i = 0; i < rec.length; ++i) {
            Rectangle rectangle1 = rec[i];
            for (int j = i + 1; j < rec.length; ++j) {
                Rectangle rectangle2 = rec[j];
                if (!rectangle1.intersects(rectangle2)) continue;
                Rectangle r = rectangle1.intersection(rectangle2);
                if (r.width <= 2 || r.height <= 2) continue;
                return true;
            }
        }
        return false;
    }

    public static void inferConstraints(List<NlComponent> components) {
        for (NlComponent component2 : components) {
            if (component2.getParent() != null) continue;
            Scout.inferConstraints(component2);
            return;
        }
    }

    public static void inferConstraintsFromConvert(NlComponent root) {
        Scout.inferConstraints(root, true, true);
    }

    public static void inferConstraints(NlComponent root) {
        Scout.inferConstraints(root, true, false);
    }

    private static void inferConstraints(NlComponent root, boolean rejectOverlaps, boolean fromConvert) {
        if (root == null) {
            return;
        }
        for (NlComponent child : root.getChildren()) {
            NlComponentHelperKt.ensureId(child);
        }
        if (!ConstraintComponentUtilities.isConstraintLayout(root)) {
            return;
        }
        if (rejectOverlaps && Scout.containsOverlap(root)) {
            System.err.println("containsOverlap!");
            return;
        }
        for (NlComponent constraintWidget : root.getChildren()) {
            if (!ConstraintComponentUtilities.isConstraintLayout(constraintWidget) || constraintWidget.getChildren().isEmpty()) continue;
            Scout.inferConstraints(constraintWidget);
        }
        ArrayList<NlComponent> list = new ArrayList<NlComponent>(root.getChildren());
        list.add(0, root);
        if (list.size() == 1) {
            return;
        }
        NlComponent[] widgets = list.toArray(new NlComponent[list.size()]);
        ScoutWidget[] scoutWidgets = ScoutWidget.create(widgets, fromConvert);
        ScoutWidget.computeConstraints(scoutWidgets);
        if (fromConvert) {
            Scout.postInferCleanupFromConvert(scoutWidgets);
        }
    }

    private static void postInferCleanupFromConvert(ScoutWidget[] widgets) {
        int i;
        for (i = 0; i < ourAttrsToDelete.length; ++i) {
            widgets[0].mNlComponent.setAttribute("http://schemas.android.com/apk/res/android", ourAttrsToDelete[i], null);
        }
        for (i = 1; i < widgets.length; ++i) {
            ScoutWidget widget = widgets[i];
            if (!(!widget.isCandidateResizable(0) || widget.isConnected(Direction.TOP) && widget.isConnected(Direction.BOTTOM))) {
                widget.setVerticalDimensionBehaviour(ScoutWidget.DimensionBehaviour.FIXED);
            }
            if (!widget.isCandidateResizable(1) || widget.isConnected(Direction.LEFT) && widget.isConnected(Direction.RIGHT)) continue;
            widget.setHorizontalDimensionBehaviour(ScoutWidget.DimensionBehaviour.FIXED);
        }
    }

    public static void inferConstraintsAndCommit(List<NlComponent> components) {
        for (NlComponent component2 : components) {
            if (component2.getParent() != null) continue;
            Scout.inferConstraintsAndCommit(component2);
            return;
        }
    }

    public static void inferConstraintsAndCommit(NlComponent component2) {
        Scout.inferConstraints(component2, false, false);
        ArrayList<NlComponent> list = new ArrayList<NlComponent>(component2.getChildren());
        list.add(0, component2);
        Scout.commit(list, "Infering constraints");
    }

    private static void commit(@NotNull List<NlComponent> list, String label) {
        if (list == null) {
            Scout.$$$reportNull$$$0(0);
        }
        if (list.isEmpty()) {
            return;
        }
        NlWriteCommandAction.run(list, label, () -> {
            if (list == null) {
                Scout.$$$reportNull$$$0(1);
            }
            list.forEach(component2 -> component2.startAttributeTransaction().commit());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "list";
        objectArray2[1] = "com/android/tools/idea/uibuilder/scout/Scout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$commit$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ChainTest {
        InVerticalChain,
        InHorizontalChain,
        IsTopOfChain,
        IsBottomOfChain,
        IsNearVerticalChain,
        IsNearHorizontalChain;

    }

    public static enum Arrange {
        AlignVerticallyTop,
        AlignVerticallyMiddle,
        AlignVerticallyBottom,
        AlignHorizontallyLeft,
        AlignHorizontallyCenter,
        AlignHorizontallyRight,
        DistributeVertically,
        DistributeHorizontally,
        VerticalPack,
        HorizontalPack,
        ExpandVertically,
        AlignBaseline,
        ExpandHorizontally,
        CenterHorizontallyInParent,
        CenterVerticallyInParent,
        CenterVertically,
        CenterHorizontally,
        CreateHorizontalChain,
        CreateVerticalChain,
        ConnectTop,
        ConnectBottom,
        ConnectStart,
        ConnectEnd,
        ChainVerticalRemove,
        ChainHorizontalRemove,
        ChainVerticalMoveUp,
        ChainVerticalMoveDown,
        ChainHorizontalMoveLeft,
        ChainHorizontalMoveRight,
        ChainInsertHorizontal,
        ChainInsertVertical;

    }
}

