/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlComponentUtil;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NlDropInsertionPicker {
    private final JTree myTree;

    public NlDropInsertionPicker(@NotNull NlComponentTree tree) {
        if (tree == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(0);
        }
        this((JTree)((Object)tree));
    }

    NlDropInsertionPicker(@NotNull JTree tree) {
        if (tree == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(1);
        }
        this.myTree = tree;
    }

    @Nullable
    public Result findInsertionPointAt(@NotNull Point location, @NotNull List<NlComponent> dragged) {
        if (location == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(2);
        }
        if (dragged == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(3);
        }
        if (dragged.isEmpty()) {
            return this.findInsertionPointAt(location);
        }
        Result result = new Result();
        result.receiver = null;
        result.nextComponent = null;
        TreePath referencePath = this.myTree.getClosestPathForLocation(location.x, location.y);
        result.row = this.myTree.getRowForPath(referencePath);
        if (referencePath == null) {
            return null;
        }
        result.depth = 1;
        Object last = referencePath.getLastPathComponent();
        if (!(last instanceof NlComponent)) {
            return null;
        }
        NlComponent receiverComponent = (NlComponent)last;
        if (this.canChangeInsertionDepth(referencePath, receiverComponent)) {
            Rectangle referenceBounds;
            TreePath parentPath;
            while ((parentPath = referencePath.getParentPath()) != null && (referenceBounds = this.myTree.getPathBounds(referencePath)) != null && this.canSelectLowerDepth(result.row, result.depth) && location.x < referenceBounds.x) {
                --result.depth;
                referencePath = parentPath;
            }
            receiverComponent = (NlComponent)referencePath.getLastPathComponent();
        }
        if (this.canAddComponent(receiverComponent.getModel(), receiverComponent, dragged)) {
            result.receiver = receiverComponent;
            if (receiverComponent.getChildCount() != 0) {
                TreePath nextPath = this.myTree.getPathForRow(result.row + 1);
                result.nextComponent = nextPath == null ? null : (NlComponent)nextPath.getLastPathComponent();
            }
        } else {
            NlComponent parent = receiverComponent.getParent();
            --result.depth;
            if (parent == null) {
                result.receiver = receiverComponent;
            } else {
                result.receiver = parent;
                result.nextComponent = receiverComponent.getNextSibling();
            }
            if (!this.canAddComponent(result.receiver.getModel(), result.receiver, dragged)) {
                result.receiver = null;
                result.nextComponent = null;
                return null;
            }
        }
        return result;
    }

    public Result findInsertionPointAt(@NotNull Point location) {
        if (location == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(4);
        }
        TreePath path = this.myTree.getSelectionPath();
        TreePath parent = path.getParentPath();
        TreePath referencePath = this.myTree.getClosestPathForLocation(location.x, location.y);
        Result result = new Result();
        result.shouldDelegate = true;
        result.receiver = (NlComponent)parent.getLastPathComponent();
        if (referencePath == parent) {
            result.depth = 1;
            result.row = this.myTree.getRowForPath(referencePath);
            return result;
        }
        if (referencePath.getParentPath() == parent) {
            result.depth = 0;
            result.row = this.myTree.getRowForPath(referencePath);
            return result;
        }
        return null;
    }

    private boolean canChangeInsertionDepth(@NotNull TreePath path, @NotNull NlComponent component2) {
        if (path == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(5);
        }
        if (component2 == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(6);
        }
        return component2.getNextSibling() == null && this.myTree.getExpandedDescendants(path) == null;
    }

    protected boolean canAddComponent(@NotNull NlModel model, @NotNull NlComponent receiver, @NotNull List<NlComponent> dragged) {
        if (model == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(7);
        }
        if (receiver == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(8);
        }
        if (dragged == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(9);
        }
        return model.canAddComponents(dragged, receiver, receiver.getChild(0)) || NlComponentHelperKt.isMorphableToViewGroup(receiver) && !NlComponentUtil.isDescendant(receiver, dragged);
    }

    private boolean canSelectLowerDepth(int row, int relativeDepth) {
        return row == this.myTree.getRowCount() - 1 || relativeDepth > -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragged";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlDropInsertionPicker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findInsertionPointAt";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canChangeInsertionDepth";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "canAddComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Result {
        NlComponent receiver;
        NlComponent nextComponent;
        int depth;
        int row;
        boolean shouldDelegate = false;
    }
}

