/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarningLayer
extends Layer {
    public static final int PADDING = 5;
    private final ScreenView myScreenView;
    private final List<NlComponent> myAnnotatedComponents;

    public WarningLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            WarningLayer.$$$reportNull$$$0(0);
        }
        this.myAnnotatedComponents = Lists.newArrayList();
        this.myScreenView = screenView;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        if (gc == null) {
            WarningLayer.$$$reportNull$$$0(1);
        }
        if (!AndroidEditorSettings.getInstance().getGlobalState().isShowLint()) {
            return;
        }
        this.myAnnotatedComponents.clear();
        LintAnnotationsModel lintModel = this.myScreenView.getModel().getLintAnnotationsModel();
        if (lintModel == null) {
            return;
        }
        for (NlComponent component2 : lintModel.getComponentsWithIssues()) {
            Icon icon;
            if (!component2.isShowing() || (icon = lintModel.getIssueIcon(component2)) == null) continue;
            int x = Coordinates.getSwingX(this.myScreenView, NlComponentHelperKt.getX(component2));
            int y = Coordinates.getSwingY(this.myScreenView, NlComponentHelperKt.getY(component2));
            int w = Coordinates.getSwingDimension(this.myScreenView, NlComponentHelperKt.getW(component2));
            icon.paintIcon(null, gc, x + w - icon.getIconWidth() - 5, y + 5);
            this.myAnnotatedComponents.add(component2);
        }
    }

    @Override
    @Nullable
    public String getTooltip(int mx, int my) {
        LintAnnotationsModel lintModel = this.myScreenView.getModel().getLintAnnotationsModel();
        if (lintModel == null) {
            return null;
        }
        for (NlComponent component2 : this.myAnnotatedComponents) {
            Icon icon = lintModel.getIssueIcon(component2);
            if (icon == null) continue;
            int x = Coordinates.getSwingX(this.myScreenView, NlComponentHelperKt.getX(component2));
            int y = Coordinates.getSwingY(this.myScreenView, NlComponentHelperKt.getY(component2));
            int w = Coordinates.getSwingDimension(this.myScreenView, NlComponentHelperKt.getW(component2));
            if (mx <= x + w - icon.getIconWidth() - 5 || mx >= x + w - 5 || my <= y + 5 || my >= y + 5 + icon.getIconHeight()) continue;
            return lintModel.getIssueMessage(component2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/WarningLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

