/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CheckSdkOperation
extends InstallOperation<File, File> {
    private static final String ERROR_CANT_EXECUTE = "%1$s file is not a valid executable";
    private static final String ERROR_NO_TOOLS_DIR = "SDK tools directory is missing";
    private static final String MESSAGE_CANT_RUN_TOOL;
    private static final String ERROR_CANT_RUN_TOOL;
    private static final String URL_MISSING_LIBRARIES = "https://developer.android.com/studio/troubleshoot.html#linux-libraries";
    private static final String LINK_MISSING_LIBRARIES = "Show Android SDK web page";
    private static final String TOOL_NAME;

    public CheckSdkOperation(InstallContext context) {
        super(context, 0.0);
    }

    private static Iterable<?> getUnableToRunMessage() {
        boolean isLinux64 = SystemInfo.isLinux && SystemInfo.is64Bit;
        String likelyReason = isLinux64 ? "One common reason for this is missing 32 bit compatibility libraries." : "One common reason for this failure is missing required libraries";
        String message = "Unable to run <strong>" + TOOL_NAME + "</strong> SDK tool.";
        ArrayList lines = Lists.newArrayList((Object[])new String[]{message, likelyReason, "Please fix the underlying issue and retry."});
        if (isLinux64) {
            String docHyperlink = "<a href=\"https://developer.android.com/studio/troubleshoot.html#linux-libraries\">Show Android SDK web page</a>";
            lines.add(docHyperlink);
        }
        return lines;
    }

    private static boolean checkCanRunSdkTool(File executable) throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{executable.getAbsolutePath()});
        CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
        int exitCode = handler.runProcess().getExitCode();
        return exitCode == 1;
    }

    private static boolean checkExecutePermission(@NotNull File executable) {
        if (executable == null) {
            CheckSdkOperation.$$$reportNull$$$0(0);
        }
        if (executable.canExecute()) {
            return true;
        }
        return SystemInfo.isUnix && executable.setExecutable(true);
    }

    private static boolean retryPrompt() {
        int button = Messages.showOkCancelDialog((String)MESSAGE_CANT_RUN_TOOL, (String)"Android Studio", (String)"Retry", (String)"Cancel", (Icon)Messages.getErrorIcon());
        return button == 0;
    }

    private static boolean checkRuns(File executable) {
        try {
            while (!CheckSdkOperation.checkCanRunSdkTool(executable)) {
                boolean shouldRetry = (Boolean)UIUtil.invokeAndWaitIfNeeded(CheckSdkOperation::retryPrompt);
                if (shouldRetry) continue;
                return false;
            }
        }
        catch (ExecutionException e) {
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File file) throws WizardException, InstallationCancelledException {
        File tool;
        if (indicator == null) {
            CheckSdkOperation.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CheckSdkOperation.$$$reportNull$$$0(2);
        }
        if (!(tool = new File(file, "emulator" + File.separator + TOOL_NAME)).isFile()) {
            tool = new File(file, "tools" + File.separator + TOOL_NAME);
        }
        if (!tool.isFile()) {
            throw new WizardException(ERROR_NO_TOOLS_DIR);
        }
        if (!CheckSdkOperation.checkExecutePermission(tool)) {
            throw new WizardException(String.format(ERROR_CANT_EXECUTE, tool.getAbsoluteFile()));
        }
        if (!CheckSdkOperation.checkRuns(tool)) {
            throw new WizardException(ERROR_CANT_RUN_TOOL);
        }
        File file2 = file;
        if (file2 == null) {
            CheckSdkOperation.$$$reportNull$$$0(3);
        }
        return file2;
    }

    @Override
    public void cleanup(@NotNull File result) {
        if (result == null) {
            CheckSdkOperation.$$$reportNull$$$0(4);
        }
    }

    static {
        TOOL_NAME = "mksdcard" + (SystemInfo.isWindows ? ".exe" : "");
        ERROR_CANT_RUN_TOOL = "Unable to run " + TOOL_NAME + " SDK tool.";
        MESSAGE_CANT_RUN_TOOL = "<html><p>" + Joiner.on((String)"</p><p>").join(CheckSdkOperation.getUnableToRunMessage()) + "</p></html>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/install/CheckSdkOperation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/install/CheckSdkOperation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkExecutePermission";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

