/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlTagNameProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLayoutXmlTagNameProvider
implements XmlTagNameProvider {
    private static final List<String> NAMESPACES = Collections.singletonList("");

    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        PsiFile file;
        if (tag == null) {
            AndroidLayoutXmlTagNameProvider.$$$reportNull$$$0(0);
        }
        if (!((file = tag.getContainingFile()) instanceof XmlFile) || !LayoutDomFileDescription.isLayoutFile((XmlFile)file)) {
            return;
        }
        XmlExtension xmlExtension = XmlExtension.getExtension((PsiFile)file);
        List variants = TagNameVariantCollector.getTagDescriptors((XmlTag)tag, NAMESPACES, null);
        HashSet supportAlternatives = Sets.newHashSet();
        for (XmlElementDescriptor descriptor : variants) {
            String qualifiedName = descriptor.getName((PsiElement)tag);
            if (!qualifiedName.startsWith("android.support.")) continue;
            supportAlternatives.add(AndroidUtils.getUnqualifiedName(qualifiedName));
        }
        HashSet addedNames = Sets.newHashSet();
        for (XmlElementDescriptor descriptor : variants) {
            int priority;
            String qualifiedName = descriptor.getName((PsiElement)tag);
            if (!addedNames.add(qualifiedName)) continue;
            String simpleName = AndroidUtils.getUnqualifiedName(qualifiedName);
            PsiElement declaration = descriptor.getDeclaration();
            LookupElementBuilder lookupElement = declaration == null ? LookupElementBuilder.create((String)qualifiedName) : LookupElementBuilder.create((Object)declaration, (String)qualifiedName);
            boolean isDeprecated = AndroidLayoutXmlTagNameProvider.isDeclarationDeprecated(declaration);
            if (isDeprecated) {
                lookupElement = lookupElement.withStrikeoutness(true);
            }
            if (simpleName != null) {
                lookupElement = lookupElement.withLookupString(simpleName);
            }
            if (descriptor instanceof PsiPresentableMetaData) {
                lookupElement = lookupElement.withIcon(((PsiPresentableMetaData)descriptor).getIcon());
            }
            if (xmlExtension.useXmlTagInsertHandler()) {
                lookupElement = lookupElement.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
            }
            int n = priority = isDeprecated ? 10 : 100;
            if (simpleName == null) {
                priority = supportAlternatives.contains(qualifiedName) ? --priority : (priority += 10);
            }
            elements.add(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority));
        }
    }

    private static boolean isDeclarationDeprecated(@Nullable PsiElement declaration) {
        if (!(declaration instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)declaration;
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        return modifierList.findAnnotation("java.lang.Deprecated") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/android/dom/AndroidLayoutXmlTagNameProvider", "addTagNameVariants"));
    }
}

