/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.google.common.base.Strings;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetApiConverter
extends ResolvingConverter<Integer> {
    private final Set<Integer> myAllVariants;

    public TargetApiConverter() {
        Range range = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(26));
        this.myAllVariants = ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.integers());
    }

    @Nullable
    public LookupElement createLookupElement(Integer api) {
        String codeName;
        if (api == null) {
            return null;
        }
        String lookupString = SdkVersionInfo.getBuildCode((int)api);
        if (lookupString == null) {
            return null;
        }
        StringBuilder typeText = new StringBuilder();
        if (lookupString.length() == 1 && (codeName = SdkVersionInfo.getCodeName((int)api)) != null) {
            typeText.append(codeName).append(", ");
        }
        typeText.append(api);
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)lookupString).withTypeText(typeText.toString(), true).withCaseSensitivity(false), (double)api.intValue());
    }

    @Nullable
    public PsiElement resolve(Integer o, ConvertContext context) {
        return super.resolve((Object)o, context);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        block4: {
            if (Strings.isNullOrEmpty((String)s)) {
                return "Value shouldn't be empty";
            }
            try {
                int api = Integer.parseInt(s);
                if (!TargetApiConverter.isLegalApi(api, context)) {
                    return String.format("%d is not a valid API level", api);
                }
            }
            catch (NumberFormatException e) {
                int buildCode = SdkVersionInfo.getApiByBuildCode((String)s, (boolean)false);
                if (buildCode != -1) break block4;
                return "Value is neither valid build code nor an integer";
            }
        }
        return null;
    }

    @Nullable
    public Integer fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        try {
            int api = Integer.parseInt(s);
            return TargetApiConverter.isLegalApi(api, context) ? Integer.valueOf(api) : null;
        }
        catch (NumberFormatException e) {
            int buildCode = SdkVersionInfo.getApiByBuildCode((String)s, (boolean)false);
            return buildCode == -1 ? null : Integer.valueOf(buildCode);
        }
    }

    private static boolean isLegalApi(int api, @NotNull ConvertContext context) {
        if (context == null) {
            TargetApiConverter.$$$reportNull$$$0(0);
        }
        return api >= 1 && api <= TargetApiConverter.getHighestKnownApi(context);
    }

    private static int getHighestKnownApi(@NotNull ConvertContext context) {
        Module module;
        if (context == null) {
            TargetApiConverter.$$$reportNull$$$0(1);
        }
        if ((module = context.getModule()) == null) {
            return 26;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return 26;
        }
        IAndroidTarget apiTarget = ConfigurationManager.getOrCreateInstance(module).getHighestApiTarget();
        if (apiTarget == null) {
            return 26;
        }
        return Math.max(apiTarget.getVersion().getApiLevel(), 26);
    }

    @Nullable
    public String toString(@Nullable Integer s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        return SdkVersionInfo.getBuildCode((int)s);
    }

    @NotNull
    public Collection<Integer> getVariants(ConvertContext context) {
        Set<Integer> set = this.myAllVariants;
        if (set == null) {
            TargetApiConverter.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/TargetApiConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/TargetApiConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLegalApi";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHighestKnownApi";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

