/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.navigation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.ClassMaps;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.navigation.NavActionElement;
import org.jetbrains.android.dom.navigation.NavDestinationElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationSchema
implements Disposable {
    public static final String TAG_ACTION = "action";
    public static final String ATTR_DESTINATION = "destination";
    public static final String TAG_INCLUDE = "include";
    public static final String NAVIGATOR_CLASS_NAME = "android.support.navigation.app.nav.Navigator";
    public static final String NAV_GRAPH_NAVIGATOR_CLASS_NAME = "android.support.navigation.app.nav.NavGraphNavigator";
    public static final String FRAGMENT_NAVIGATOR_CLASS_NAME = "android.support.navigation.app.nav.FragmentNavigator";
    public static final String ACTIVITY_NAVIGATOR_CLASS_NAME = "android.support.navigation.app.nav.ActivityNavigator";
    public static final Map<String, DestinationType> NAV_CLASS_TO_TYPE = ImmutableMap.of((Object)"android.support.navigation.app.nav.NavGraphNavigator", (Object)((Object)DestinationType.NAVIGATION), (Object)"android.support.navigation.app.nav.FragmentNavigator", (Object)((Object)DestinationType.FRAGMENT), (Object)"android.support.navigation.app.nav.ActivityNavigator", (Object)((Object)DestinationType.ACTIVITY));
    public static final String ANNOTATION_NAV_TAG_NAME = "android.support.navigation.app.nav.Navigator.Name";
    public static final String ATTR_NAV_TYPE = "navType";
    public static final String ATTR_START_DESTINATION = "startDestination";
    public static final Map<String, DestinationType> DESTINATION_SUPERCLASS_TO_TYPE = ImmutableMap.of((Object)"android.app.Activity", (Object)((Object)DestinationType.ACTIVITY), (Object)"android.app.Fragment", (Object)((Object)DestinationType.FRAGMENT), (Object)"android.support.v4.app.Fragment", (Object)((Object)DestinationType.FRAGMENT));
    private static final Map<AndroidFacet, NavigationSchema> ourSchemas = new HashMap<AndroidFacet, NavigationSchema>();
    private Map<String, DestinationType> myTagToDestinationType;
    private Map<DestinationType, String> myTypeToRootTag;
    private Map<DestinationType, Map<String, PsiClass>> myNavTagToClass;
    private final ClassMaps myClassMaps;

    @NotNull
    public static NavigationSchema getOrCreateSchema(@NotNull AndroidFacet facet) {
        NavigationSchema result;
        if (facet == null) {
            NavigationSchema.$$$reportNull$$$0(0);
        }
        if ((result = ourSchemas.get((Object)facet)) == null) {
            result = new NavigationSchema(facet);
            ourSchemas.put(facet, result);
            Disposer.register((Disposable)facet, (Disposable)result);
        }
        NavigationSchema navigationSchema = result;
        if (navigationSchema == null) {
            NavigationSchema.$$$reportNull$$$0(1);
        }
        return navigationSchema;
    }

    private NavigationSchema(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavigationSchema.$$$reportNull$$$0(2);
        }
        this.myClassMaps = ClassMaps.getInstance(facet);
    }

    public void dispose() {
        ourSchemas.remove((Object)this.myClassMaps.getFacet());
    }

    @Nullable
    public PsiClass getDestinationClassByTag(@NotNull String tagName) {
        if (tagName == null) {
            NavigationSchema.$$$reportNull$$$0(3);
        }
        for (Map<String, PsiClass> typeMap : this.getTypeTagClassMap().values()) {
            PsiClass c = typeMap.get(tagName);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    @NotNull
    private Map<DestinationType, Map<String, PsiClass>> getTypeTagClassMap() {
        this.initIfNeeded();
        Map<DestinationType, Map<String, PsiClass>> map = this.myNavTagToClass;
        if (map == null) {
            NavigationSchema.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    public Map<String, PsiClass> getDestinationClassByTagMap(@NotNull DestinationType type) {
        if (type == null) {
            NavigationSchema.$$$reportNull$$$0(5);
        }
        this.initIfNeeded();
        Map<String, PsiClass> map = this.myNavTagToClass.get((Object)type);
        if (map == null) {
            NavigationSchema.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    private Map<String, PsiClass> getClassMap(@NotNull String className) {
        Map<String, PsiClass> result;
        if (className == null) {
            NavigationSchema.$$$reportNull$$$0(7);
        }
        if ((result = this.myClassMaps.getClassMap(className)).isEmpty()) {
            throw new RuntimeException();
        }
        Map<String, PsiClass> map = result;
        if (map == null) {
            NavigationSchema.$$$reportNull$$$0(8);
        }
        return map;
    }

    private void initIfNeeded() {
        if (this.myNavTagToClass == null) {
            HashMap<DestinationType, Map<String, PsiClass>> result = new HashMap<DestinationType, Map<String, PsiClass>>();
            HashMap<String, DestinationType> tagToType = new HashMap<String, DestinationType>();
            HashMap<DestinationType, Map<String, PsiClass>> classNameMaps = new HashMap<DestinationType, Map<String, PsiClass>>();
            for (Map.Entry<String, DestinationType> entry : NAV_CLASS_TO_TYPE.entrySet()) {
                classNameMaps.put(entry.getValue(), this.getClassMap(entry.getKey()));
                result.put(entry.getValue(), new HashMap());
            }
            result.put(DestinationType.OTHER, new HashMap());
            Map<String, PsiClass> map = this.getClassMap(NAVIGATOR_CLASS_NAME);
            for (String className : map.keySet()) {
                PsiClass c = map.get(className);
                for (PsiAnnotation annotation : AnnotationUtil.getAllAnnotations((PsiModifierListOwner)c, (boolean)false, null)) {
                    String value;
                    if (!ANNOTATION_NAV_TAG_NAME.equals(annotation.getQualifiedName()) || (value = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"value")) == null) continue;
                    DestinationType resolvedType = null;
                    for (DestinationType type : classNameMaps.keySet()) {
                        Map classNameMap = (Map)classNameMaps.get((Object)type);
                        if (!classNameMap.containsKey(className)) continue;
                        resolvedType = type;
                        break;
                    }
                    if (resolvedType == null) {
                        resolvedType = DestinationType.OTHER;
                    }
                    ((Map)result.get((Object)resolvedType)).put(value, c);
                    tagToType.put(value, resolvedType);
                }
            }
            this.myNavTagToClass = result;
            this.myTagToDestinationType = tagToType;
            HashMap<DestinationType, String> hashMap = new HashMap<DestinationType, String>();
            HashMap<DestinationType, PsiClass> typeToBestClass = new HashMap<DestinationType, PsiClass>();
            for (String tag : this.myTagToDestinationType.keySet()) {
                DestinationType type = this.myTagToDestinationType.get(tag);
                PsiClass psiClass = this.myNavTagToClass.get((Object)type).get(tag);
                if (typeToBestClass.containsKey((Object)type) && !((PsiClass)typeToBestClass.get((Object)type)).isInheritor(psiClass, true)) continue;
                typeToBestClass.put(type, psiClass);
                hashMap.put(type, tag);
            }
            this.myTypeToRootTag = hashMap;
        }
    }

    @NotNull
    public Multimap<Class<? extends AndroidDomElement>, String> getDestinationSubtags(@NotNull String tagName) {
        if (tagName == null) {
            NavigationSchema.$$$reportNull$$$0(9);
        }
        this.initIfNeeded();
        HashMultimap result = HashMultimap.create();
        if (this.myTagToDestinationType.get(tagName) == DestinationType.NAVIGATION) {
            for (Map<String, PsiClass> typeMap : this.getTypeTagClassMap().values()) {
                for (String subTag : typeMap.keySet()) {
                    result.put(NavDestinationElement.class, (Object)subTag);
                }
            }
        }
        result.put(NavActionElement.class, (Object)TAG_ACTION);
        HashMultimap hashMultimap = result;
        if (hashMultimap == null) {
            NavigationSchema.$$$reportNull$$$0(10);
        }
        return hashMultimap;
    }

    @Nullable
    public DestinationType getDestinationType(@NotNull String tag) {
        if (tag == null) {
            NavigationSchema.$$$reportNull$$$0(11);
        }
        this.initIfNeeded();
        return this.myTagToDestinationType.get(tag);
    }

    @Nullable
    public String getTag(@NotNull DestinationType type) {
        if (type == null) {
            NavigationSchema.$$$reportNull$$$0(12);
        }
        this.initIfNeeded();
        return this.myTypeToRootTag.get((Object)type);
    }

    @Nullable
    public String getTagForComponentSuperclass(@NotNull String superclassName) {
        if (superclassName == null) {
            NavigationSchema.$$$reportNull$$$0(13);
        }
        this.initIfNeeded();
        DestinationType type = DESTINATION_SUPERCLASS_TO_TYPE.get(superclassName);
        if (type != null) {
            return this.getTag(type);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public String findTagForComponent(@Nullable PsiClass layoutClass) {
        while (layoutClass != null) {
            String tag;
            String qName = layoutClass.getQualifiedName();
            if (qName != null && (tag = this.getTagForComponentSuperclass(qName)) != null) {
                return tag;
            }
            layoutClass = layoutClass.getSuperClass();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/navigation/NavigationSchema";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superclassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/navigation/NavigationSchema";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSchema";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeTagClassMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationClassByTagMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationSubtags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSchema";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationClassByTag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationClassByTagMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClassMap";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationSubtags";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTagForComponentSuperclass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum DestinationType {
        NAVIGATION,
        FRAGMENT,
        ACTIVITY,
        OTHER;

    }
}

